<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timesheet_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the response data for the Get_Timesheet operation.
 * @subpackage Structs
 */
class Timesheet_Response_DataType extends AbstractStructBase
{
    /**
     * The Timesheet
     * Meta information extracted from the WSDL
     * - documentation: Element that contains the response data for the Get_Timesheet operation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TimesheetType[]
     */
    public $Timesheet;
    /**
     * Constructor method for Timesheet_Response_DataType
     * @uses Timesheet_Response_DataType::setTimesheet()
     * @param \StructType\TimesheetType[] $timesheet
     */
    public function __construct(array $timesheet = array())
    {
        $this
            ->setTimesheet($timesheet);
    }
    /**
     * Get Timesheet value
     * @return \StructType\TimesheetType[]|null
     */
    public function getTimesheet()
    {
        return $this->Timesheet;
    }
    /**
     * This method is responsible for validating the values passed to the setTimesheet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimesheet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimesheetForArrayConstraintsFromSetTimesheet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Response_DataTypeTimesheetItem) {
            // validation for constraint: itemType
            if (!$timesheet_Response_DataTypeTimesheetItem instanceof \StructType\TimesheetType) {
                $invalidValues[] = is_object($timesheet_Response_DataTypeTimesheetItem) ? get_class($timesheet_Response_DataTypeTimesheetItem) : sprintf('%s(%s)', gettype($timesheet_Response_DataTypeTimesheetItem), var_export($timesheet_Response_DataTypeTimesheetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Timesheet property can only contain items of type \StructType\TimesheetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Timesheet value
     * @throws \InvalidArgumentException
     * @param \StructType\TimesheetType[] $timesheet
     * @return \StructType\Timesheet_Response_DataType
     */
    public function setTimesheet(array $timesheet = array())
    {
        // validation for constraint: array
        if ('' !== ($timesheetArrayErrorMessage = self::validateTimesheetForArrayConstraintsFromSetTimesheet($timesheet))) {
            throw new \InvalidArgumentException($timesheetArrayErrorMessage, __LINE__);
        }
        $this->Timesheet = $timesheet;
        return $this;
    }
    /**
     * Add item to Timesheet value
     * @throws \InvalidArgumentException
     * @param \StructType\TimesheetType $item
     * @return \StructType\Timesheet_Response_DataType
     */
    public function addToTimesheet(\StructType\TimesheetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimesheetType) {
            throw new \InvalidArgumentException(sprintf('The Timesheet property can only contain items of type \StructType\TimesheetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Timesheet[] = $item;
        return $this;
    }
}
