<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Either submit the receipt or don't lock the receipt. You can't save a receipt for later while also locking the receipt. | Receipt Data
 * @subpackage Structs
 */
class Receipt_DataType extends AbstractStructBase
{
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable both editing this Receipt and creating a Receipt Adjustment inside the Workday application.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Bill_of_Lading
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading recorded on Receipt. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_of_Lading;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requester of Requisition received by the Receipt. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition recorded on Receipt. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\RequisitionObjectType
     */
    public $Requisition_Reference;
    /**
     * The Tracking_Number
     * Meta information extracted from the WSDL
     * - documentation: Tracking Number recorded on Receipt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tracking_Number;
    /**
     * The Supplier_Order_Ref
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Reference recorded on Receipt.This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Order_Ref;
    /**
     * The Shipment_Date_Time
     * Meta information extracted from the WSDL
     * - documentation: Shipment date/time recorded on ASN which receipt was created from. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Date_Time;
    /**
     * The Shipment_Contact
     * Meta information extracted from the WSDL
     * - documentation: Shipment Contact recorded on ASN which receipt was created from. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Contact;
    /**
     * The Bill_of_Lading_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading Quantity recorded on Receipt. This field is outbound only; any data submitted will be ignored. | Bill of Lading Quanatity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Bill_of_Lading_Quantity;
    /**
     * The License_Plate
     * Meta information extracted from the WSDL
     * - documentation: License Plate recorded on ASN which receipt was created from. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $License_Plate;
    /**
     * The Shipment_Ref
     * Meta information extracted from the WSDL
     * - documentation: Shipment Reference recorded for Receipt. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Ref;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Document Status of the Receipt. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Last_Updated
     * Meta information extracted from the WSDL
     * - documentation: Date and Time that the Receipt was Last Updated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated;
    /**
     * The Created_for_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Created for Worker. Used for Contingent Worker Receipts.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Created_for_Worker_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Header level comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Receipt Adjustments that adjusts current Receipt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_AdjustmentObjectType[]
     */
    public $Receipt_Adjustment_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requisition Type of Requisitions included in Receipt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The Item_Receipt_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: All Purchase Order Line References must be associated with the same Purchase Order in a Receipt. | Purchase Order Line References must be unique. Cannot use the same Purchase Order Line for more than one Item Receipt Line. | Goods
     * item receipt lines
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Receipt_Line_Replacement_DataType[]
     */
    public $Item_Receipt_Line_Replacement_Data;
    /**
     * The Contingent_Worker_Receipt_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public $Contingent_Worker_Receipt_Line_Replacement_Data;
    /**
     * The Receipt_Service_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Service_Line_Replacement_DataType[]
     */
    public $Receipt_Service_Line_Replacement_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachments
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Receipt_DataType
     * @uses Receipt_DataType::setReceipt_Number()
     * @uses Receipt_DataType::setLocked_in_Workday()
     * @uses Receipt_DataType::setSubmit()
     * @uses Receipt_DataType::setCompany_Reference()
     * @uses Receipt_DataType::setBill_of_Lading()
     * @uses Receipt_DataType::setRequester_Reference()
     * @uses Receipt_DataType::setRequisition_Reference()
     * @uses Receipt_DataType::setTracking_Number()
     * @uses Receipt_DataType::setSupplier_Order_Ref()
     * @uses Receipt_DataType::setShipment_Date_Time()
     * @uses Receipt_DataType::setShipment_Contact()
     * @uses Receipt_DataType::setBill_of_Lading_Quantity()
     * @uses Receipt_DataType::setLicense_Plate()
     * @uses Receipt_DataType::setShipment_Ref()
     * @uses Receipt_DataType::setDocument_Status_Reference()
     * @uses Receipt_DataType::setSupplier_Reference()
     * @uses Receipt_DataType::setDocument_Date()
     * @uses Receipt_DataType::setLast_Updated()
     * @uses Receipt_DataType::setCreated_for_Worker_Reference()
     * @uses Receipt_DataType::setMemo()
     * @uses Receipt_DataType::setReceipt_Adjustment_Reference()
     * @uses Receipt_DataType::setRequisition_Type_Reference()
     * @uses Receipt_DataType::setItem_Receipt_Line_Replacement_Data()
     * @uses Receipt_DataType::setContingent_Worker_Receipt_Line_Replacement_Data()
     * @uses Receipt_DataType::setReceipt_Service_Line_Replacement_Data()
     * @uses Receipt_DataType::setAttachment_Data()
     * @param string $receipt_Number
     * @param bool $locked_in_Workday
     * @param bool $submit
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $bill_of_Lading
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @param string $tracking_Number
     * @param string $supplier_Order_Ref
     * @param string $shipment_Date_Time
     * @param string $shipment_Contact
     * @param float $bill_of_Lading_Quantity
     * @param string $license_Plate
     * @param string $shipment_Ref
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $document_Date
     * @param string $last_Updated
     * @param \StructType\WorkerObjectType $created_for_Worker_Reference
     * @param string $memo
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\Item_Receipt_Line_Replacement_DataType[] $item_Receipt_Line_Replacement_Data
     * @param \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType $contingent_Worker_Receipt_Line_Replacement_Data
     * @param \StructType\Receipt_Service_Line_Replacement_DataType[] $receipt_Service_Line_Replacement_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct($receipt_Number = null, $locked_in_Workday = null, $submit = null, \StructType\CompanyObjectType $company_Reference = null, $bill_of_Lading = null, \StructType\WorkerObjectType $requester_Reference = null, \StructType\RequisitionObjectType $requisition_Reference = null, $tracking_Number = null, $supplier_Order_Ref = null, $shipment_Date_Time = null, $shipment_Contact = null, $bill_of_Lading_Quantity = null, $license_Plate = null, $shipment_Ref = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $document_Date = null, $last_Updated = null, \StructType\WorkerObjectType $created_for_Worker_Reference = null, $memo = null, array $receipt_Adjustment_Reference = array(), array $requisition_Type_Reference = array(), array $item_Receipt_Line_Replacement_Data = array(), \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType $contingent_Worker_Receipt_Line_Replacement_Data = null, array $receipt_Service_Line_Replacement_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setReceipt_Number($receipt_Number)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setSubmit($submit)
            ->setCompany_Reference($company_Reference)
            ->setBill_of_Lading($bill_of_Lading)
            ->setRequester_Reference($requester_Reference)
            ->setRequisition_Reference($requisition_Reference)
            ->setTracking_Number($tracking_Number)
            ->setSupplier_Order_Ref($supplier_Order_Ref)
            ->setShipment_Date_Time($shipment_Date_Time)
            ->setShipment_Contact($shipment_Contact)
            ->setBill_of_Lading_Quantity($bill_of_Lading_Quantity)
            ->setLicense_Plate($license_Plate)
            ->setShipment_Ref($shipment_Ref)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setDocument_Date($document_Date)
            ->setLast_Updated($last_Updated)
            ->setCreated_for_Worker_Reference($created_for_Worker_Reference)
            ->setMemo($memo)
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setItem_Receipt_Line_Replacement_Data($item_Receipt_Line_Replacement_Data)
            ->setContingent_Worker_Receipt_Line_Replacement_Data($contingent_Worker_Receipt_Line_Replacement_Data)
            ->setReceipt_Service_Line_Replacement_Data($receipt_Service_Line_Replacement_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Receipt_DataType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Receipt_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Receipt_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Bill_of_Lading value
     * @return string|null
     */
    public function getBill_of_Lading()
    {
        return $this->Bill_of_Lading;
    }
    /**
     * Set Bill_of_Lading value
     * @param string $bill_of_Lading
     * @return \StructType\Receipt_DataType
     */
    public function setBill_of_Lading($bill_of_Lading = null)
    {
        // validation for constraint: string
        if (!is_null($bill_of_Lading) && !is_string($bill_of_Lading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_of_Lading, true), gettype($bill_of_Lading)), __LINE__);
        }
        $this->Bill_of_Lading = $bill_of_Lading;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\RequisitionObjectType|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * Set Requisition_Reference value
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setRequisition_Reference(\StructType\RequisitionObjectType $requisition_Reference = null)
    {
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
    /**
     * Get Tracking_Number value
     * @return string|null
     */
    public function getTracking_Number()
    {
        return $this->Tracking_Number;
    }
    /**
     * Set Tracking_Number value
     * @param string $tracking_Number
     * @return \StructType\Receipt_DataType
     */
    public function setTracking_Number($tracking_Number = null)
    {
        // validation for constraint: string
        if (!is_null($tracking_Number) && !is_string($tracking_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tracking_Number, true), gettype($tracking_Number)), __LINE__);
        }
        $this->Tracking_Number = $tracking_Number;
        return $this;
    }
    /**
     * Get Supplier_Order_Ref value
     * @return string|null
     */
    public function getSupplier_Order_Ref()
    {
        return $this->Supplier_Order_Ref;
    }
    /**
     * Set Supplier_Order_Ref value
     * @param string $supplier_Order_Ref
     * @return \StructType\Receipt_DataType
     */
    public function setSupplier_Order_Ref($supplier_Order_Ref = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Order_Ref) && !is_string($supplier_Order_Ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Order_Ref, true), gettype($supplier_Order_Ref)), __LINE__);
        }
        $this->Supplier_Order_Ref = $supplier_Order_Ref;
        return $this;
    }
    /**
     * Get Shipment_Date_Time value
     * @return string|null
     */
    public function getShipment_Date_Time()
    {
        return $this->Shipment_Date_Time;
    }
    /**
     * Set Shipment_Date_Time value
     * @param string $shipment_Date_Time
     * @return \StructType\Receipt_DataType
     */
    public function setShipment_Date_Time($shipment_Date_Time = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Date_Time) && !is_string($shipment_Date_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Date_Time, true), gettype($shipment_Date_Time)), __LINE__);
        }
        $this->Shipment_Date_Time = $shipment_Date_Time;
        return $this;
    }
    /**
     * Get Shipment_Contact value
     * @return string|null
     */
    public function getShipment_Contact()
    {
        return $this->Shipment_Contact;
    }
    /**
     * Set Shipment_Contact value
     * @param string $shipment_Contact
     * @return \StructType\Receipt_DataType
     */
    public function setShipment_Contact($shipment_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Contact) && !is_string($shipment_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Contact, true), gettype($shipment_Contact)), __LINE__);
        }
        $this->Shipment_Contact = $shipment_Contact;
        return $this;
    }
    /**
     * Get Bill_of_Lading_Quantity value
     * @return float|null
     */
    public function getBill_of_Lading_Quantity()
    {
        return $this->Bill_of_Lading_Quantity;
    }
    /**
     * Set Bill_of_Lading_Quantity value
     * @param float $bill_of_Lading_Quantity
     * @return \StructType\Receipt_DataType
     */
    public function setBill_of_Lading_Quantity($bill_of_Lading_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($bill_of_Lading_Quantity) && !(is_float($bill_of_Lading_Quantity) || is_numeric($bill_of_Lading_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bill_of_Lading_Quantity, true), gettype($bill_of_Lading_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(mb_substr($bill_of_Lading_Quantity, false !== mb_strpos($bill_of_Lading_Quantity, '.') ? mb_strpos($bill_of_Lading_Quantity, '.') + 1 : mb_strlen($bill_of_Lading_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($bill_of_Lading_Quantity, true), mb_strlen(mb_substr($bill_of_Lading_Quantity, mb_strpos($bill_of_Lading_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bill_of_Lading_Quantity) && $bill_of_Lading_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bill_of_Lading_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($bill_of_Lading_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity))), __LINE__);
        }
        $this->Bill_of_Lading_Quantity = $bill_of_Lading_Quantity;
        return $this;
    }
    /**
     * Get License_Plate value
     * @return string|null
     */
    public function getLicense_Plate()
    {
        return $this->License_Plate;
    }
    /**
     * Set License_Plate value
     * @param string $license_Plate
     * @return \StructType\Receipt_DataType
     */
    public function setLicense_Plate($license_Plate = null)
    {
        // validation for constraint: string
        if (!is_null($license_Plate) && !is_string($license_Plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_Plate, true), gettype($license_Plate)), __LINE__);
        }
        $this->License_Plate = $license_Plate;
        return $this;
    }
    /**
     * Get Shipment_Ref value
     * @return string|null
     */
    public function getShipment_Ref()
    {
        return $this->Shipment_Ref;
    }
    /**
     * Set Shipment_Ref value
     * @param string $shipment_Ref
     * @return \StructType\Receipt_DataType
     */
    public function setShipment_Ref($shipment_Ref = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Ref) && !is_string($shipment_Ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Ref, true), gettype($shipment_Ref)), __LINE__);
        }
        $this->Shipment_Ref = $shipment_Ref;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Receipt_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Last_Updated value
     * @return string|null
     */
    public function getLast_Updated()
    {
        return $this->Last_Updated;
    }
    /**
     * Set Last_Updated value
     * @param string $last_Updated
     * @return \StructType\Receipt_DataType
     */
    public function setLast_Updated($last_Updated = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated) && !is_string($last_Updated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated, true), gettype($last_Updated)), __LINE__);
        }
        $this->Last_Updated = $last_Updated;
        return $this;
    }
    /**
     * Get Created_for_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getCreated_for_Worker_Reference()
    {
        return $this->Created_for_Worker_Reference;
    }
    /**
     * Set Created_for_Worker_Reference value
     * @param \StructType\WorkerObjectType $created_for_Worker_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setCreated_for_Worker_Reference(\StructType\WorkerObjectType $created_for_Worker_Reference = null)
    {
        $this->Created_for_Worker_Reference = $created_for_Worker_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType[]|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Adjustment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_DataTypeReceipt_Adjustment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_DataTypeReceipt_Adjustment_ReferenceItem instanceof \StructType\Receipt_AdjustmentObjectType) {
                $invalidValues[] = is_object($receipt_DataTypeReceipt_Adjustment_ReferenceItem) ? get_class($receipt_DataTypeReceipt_Adjustment_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_DataTypeReceipt_Adjustment_ReferenceItem), var_export($receipt_DataTypeReceipt_Adjustment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setReceipt_Adjustment_Reference(array $receipt_Adjustment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Adjustment_ReferenceArrayErrorMessage = self::validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference($receipt_Adjustment_Reference))) {
            throw new \InvalidArgumentException($receipt_Adjustment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Add item to Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType $item
     * @return \StructType\Receipt_DataType
     */
    public function addToReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_AdjustmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Adjustment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_DataTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_DataTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($receipt_DataTypeRequisition_Type_ReferenceItem) ? get_class($receipt_DataTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_DataTypeRequisition_Type_ReferenceItem), var_export($receipt_DataTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Receipt_DataType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Receipt_DataType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Replacement_Data value
     * @return \StructType\Item_Receipt_Line_Replacement_DataType[]|null
     */
    public function getItem_Receipt_Line_Replacement_Data()
    {
        return $this->Item_Receipt_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_Replacement_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_DataTypeItem_Receipt_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_DataTypeItem_Receipt_Line_Replacement_DataItem instanceof \StructType\Item_Receipt_Line_Replacement_DataType) {
                $invalidValues[] = is_object($receipt_DataTypeItem_Receipt_Line_Replacement_DataItem) ? get_class($receipt_DataTypeItem_Receipt_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($receipt_DataTypeItem_Receipt_Line_Replacement_DataItem), var_export($receipt_DataTypeItem_Receipt_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Replacement_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_DataType[] $item_Receipt_Line_Replacement_Data
     * @return \StructType\Receipt_DataType
     */
    public function setItem_Receipt_Line_Replacement_Data(array $item_Receipt_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_Replacement_DataArrayErrorMessage = self::validateItem_Receipt_Line_Replacement_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Data($item_Receipt_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Data = $item_Receipt_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_DataType $item
     * @return \StructType\Receipt_DataType
     */
    public function addToItem_Receipt_Line_Replacement_Data(\StructType\Item_Receipt_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Receipt_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Replacement_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Contingent_Worker_Receipt_Line_Replacement_Data value
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType|null
     */
    public function getContingent_Worker_Receipt_Line_Replacement_Data()
    {
        return $this->Contingent_Worker_Receipt_Line_Replacement_Data;
    }
    /**
     * Set Contingent_Worker_Receipt_Line_Replacement_Data value
     * @param \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType $contingent_Worker_Receipt_Line_Replacement_Data
     * @return \StructType\Receipt_DataType
     */
    public function setContingent_Worker_Receipt_Line_Replacement_Data(\StructType\Contingent_Worker_Receipt_Line_Replacement_DataType $contingent_Worker_Receipt_Line_Replacement_Data = null)
    {
        $this->Contingent_Worker_Receipt_Line_Replacement_Data = $contingent_Worker_Receipt_Line_Replacement_Data;
        return $this;
    }
    /**
     * Get Receipt_Service_Line_Replacement_Data value
     * @return \StructType\Receipt_Service_Line_Replacement_DataType[]|null
     */
    public function getReceipt_Service_Line_Replacement_Data()
    {
        return $this->Receipt_Service_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Service_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Service_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Service_Line_Replacement_DataForArrayConstraintsFromSetReceipt_Service_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_DataTypeReceipt_Service_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_DataTypeReceipt_Service_Line_Replacement_DataItem instanceof \StructType\Receipt_Service_Line_Replacement_DataType) {
                $invalidValues[] = is_object($receipt_DataTypeReceipt_Service_Line_Replacement_DataItem) ? get_class($receipt_DataTypeReceipt_Service_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($receipt_DataTypeReceipt_Service_Line_Replacement_DataItem), var_export($receipt_DataTypeReceipt_Service_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Service_Line_Replacement_Data property can only contain items of type \StructType\Receipt_Service_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Service_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Service_Line_Replacement_DataType[] $receipt_Service_Line_Replacement_Data
     * @return \StructType\Receipt_DataType
     */
    public function setReceipt_Service_Line_Replacement_Data(array $receipt_Service_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Service_Line_Replacement_DataArrayErrorMessage = self::validateReceipt_Service_Line_Replacement_DataForArrayConstraintsFromSetReceipt_Service_Line_Replacement_Data($receipt_Service_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($receipt_Service_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Service_Line_Replacement_Data = $receipt_Service_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Service_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Service_Line_Replacement_DataType $item
     * @return \StructType\Receipt_DataType
     */
    public function addToReceipt_Service_Line_Replacement_Data(\StructType\Receipt_Service_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Service_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Service_Line_Replacement_Data property can only contain items of type \StructType\Receipt_Service_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Service_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($receipt_DataTypeAttachment_DataItem) ? get_class($receipt_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($receipt_DataTypeAttachment_DataItem), var_export($receipt_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Receipt_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Receipt_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
