<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Group_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Resource reference for update and all Resource data items
 * @subpackage Structs
 */
class Put_Supplier_Group_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Group for update only purposes
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType
     */
    public $Supplier_Group_Reference;
    /**
     * The Supplier_Group_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group Data
     * @var \StructType\Supplier_Group_DataType
     */
    public $Supplier_Group_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Group_RequestType
     * @uses Put_Supplier_Group_RequestType::setSupplier_Group_Reference()
     * @uses Put_Supplier_Group_RequestType::setSupplier_Group_Data()
     * @uses Put_Supplier_Group_RequestType::setAdd_Only()
     * @uses Put_Supplier_Group_RequestType::setVersion()
     * @param \StructType\Supplier_GroupObjectType $supplier_Group_Reference
     * @param \StructType\Supplier_Group_DataType $supplier_Group_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_GroupObjectType $supplier_Group_Reference = null, \StructType\Supplier_Group_DataType $supplier_Group_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Group_Reference($supplier_Group_Reference)
            ->setSupplier_Group_Data($supplier_Group_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * Set Supplier_Group_Reference value
     * @param \StructType\Supplier_GroupObjectType $supplier_Group_Reference
     * @return \StructType\Put_Supplier_Group_RequestType
     */
    public function setSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $supplier_Group_Reference = null)
    {
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Get Supplier_Group_Data value
     * @return \StructType\Supplier_Group_DataType|null
     */
    public function getSupplier_Group_Data()
    {
        return $this->Supplier_Group_Data;
    }
    /**
     * Set Supplier_Group_Data value
     * @param \StructType\Supplier_Group_DataType $supplier_Group_Data
     * @return \StructType\Put_Supplier_Group_RequestType
     */
    public function setSupplier_Group_Data(\StructType\Supplier_Group_DataType $supplier_Group_Data = null)
    {
        $this->Supplier_Group_Data = $supplier_Group_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_Group_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Group_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
