<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Type_Enrichment_TemplatesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing Purchase Item Request Type Enrichment Templates data
 * @subpackage Structs
 */
class Purchase_Item_Request_Type_Enrichment_TemplatesType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Enrichment_Templates_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enrichment Template
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType
     */
    public $Purchase_Item_Request_Enrichment_Templates_Reference;
    /**
     * The Line_Order_for_Enrichment_Template
     * Meta information extracted from the WSDL
     * - documentation: Order in which this enrichment template show show in the business process workflow
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 2
     * @var float
     */
    public $Line_Order_for_Enrichment_Template;
    /**
     * The Enrichment_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enrichment Template
     * @var \StructType\Purchase_Item_Request_Template__All_ObjectType
     */
    public $Enrichment_Template_Reference;
    /**
     * Constructor method for Purchase_Item_Request_Type_Enrichment_TemplatesType
     * @uses Purchase_Item_Request_Type_Enrichment_TemplatesType::setPurchase_Item_Request_Enrichment_Templates_Reference()
     * @uses Purchase_Item_Request_Type_Enrichment_TemplatesType::setLine_Order_for_Enrichment_Template()
     * @uses Purchase_Item_Request_Type_Enrichment_TemplatesType::setEnrichment_Template_Reference()
     * @param \StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType $purchase_Item_Request_Enrichment_Templates_Reference
     * @param float $line_Order_for_Enrichment_Template
     * @param \StructType\Purchase_Item_Request_Template__All_ObjectType $enrichment_Template_Reference
     */
    public function __construct(\StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType $purchase_Item_Request_Enrichment_Templates_Reference = null, $line_Order_for_Enrichment_Template = null, \StructType\Purchase_Item_Request_Template__All_ObjectType $enrichment_Template_Reference = null)
    {
        $this
            ->setPurchase_Item_Request_Enrichment_Templates_Reference($purchase_Item_Request_Enrichment_Templates_Reference)
            ->setLine_Order_for_Enrichment_Template($line_Order_for_Enrichment_Template)
            ->setEnrichment_Template_Reference($enrichment_Template_Reference);
    }
    /**
     * Get Purchase_Item_Request_Enrichment_Templates_Reference value
     * @return \StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType|null
     */
    public function getPurchase_Item_Request_Enrichment_Templates_Reference()
    {
        return $this->Purchase_Item_Request_Enrichment_Templates_Reference;
    }
    /**
     * Set Purchase_Item_Request_Enrichment_Templates_Reference value
     * @param \StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType $purchase_Item_Request_Enrichment_Templates_Reference
     * @return \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType
     */
    public function setPurchase_Item_Request_Enrichment_Templates_Reference(\StructType\Purchase_Item_Request_Enrichment_TemplatesObjectType $purchase_Item_Request_Enrichment_Templates_Reference = null)
    {
        $this->Purchase_Item_Request_Enrichment_Templates_Reference = $purchase_Item_Request_Enrichment_Templates_Reference;
        return $this;
    }
    /**
     * Get Line_Order_for_Enrichment_Template value
     * @return float|null
     */
    public function getLine_Order_for_Enrichment_Template()
    {
        return $this->Line_Order_for_Enrichment_Template;
    }
    /**
     * Set Line_Order_for_Enrichment_Template value
     * @param float $line_Order_for_Enrichment_Template
     * @return \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType
     */
    public function setLine_Order_for_Enrichment_Template($line_Order_for_Enrichment_Template = null)
    {
        // validation for constraint: float
        if (!is_null($line_Order_for_Enrichment_Template) && !(is_float($line_Order_for_Enrichment_Template) || is_numeric($line_Order_for_Enrichment_Template))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Order_for_Enrichment_Template, true), gettype($line_Order_for_Enrichment_Template)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Order_for_Enrichment_Template) && mb_strlen(mb_substr($line_Order_for_Enrichment_Template, false !== mb_strpos($line_Order_for_Enrichment_Template, '.') ? mb_strpos($line_Order_for_Enrichment_Template, '.') + 1 : mb_strlen($line_Order_for_Enrichment_Template))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Order_for_Enrichment_Template, true), mb_strlen(mb_substr($line_Order_for_Enrichment_Template, mb_strpos($line_Order_for_Enrichment_Template, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Order_for_Enrichment_Template) && $line_Order_for_Enrichment_Template < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Order_for_Enrichment_Template, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($line_Order_for_Enrichment_Template) && mb_strlen(preg_replace('/(\D)/', '', $line_Order_for_Enrichment_Template)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($line_Order_for_Enrichment_Template, true), mb_strlen(preg_replace('/(\D)/', '', $line_Order_for_Enrichment_Template))), __LINE__);
        }
        $this->Line_Order_for_Enrichment_Template = $line_Order_for_Enrichment_Template;
        return $this;
    }
    /**
     * Get Enrichment_Template_Reference value
     * @return \StructType\Purchase_Item_Request_Template__All_ObjectType|null
     */
    public function getEnrichment_Template_Reference()
    {
        return $this->Enrichment_Template_Reference;
    }
    /**
     * Set Enrichment_Template_Reference value
     * @param \StructType\Purchase_Item_Request_Template__All_ObjectType $enrichment_Template_Reference
     * @return \StructType\Purchase_Item_Request_Type_Enrichment_TemplatesType
     */
    public function setEnrichment_Template_Reference(\StructType\Purchase_Item_Request_Template__All_ObjectType $enrichment_Template_Reference = null)
    {
        $this->Enrichment_Template_Reference = $enrichment_Template_Reference;
        return $this;
    }
}
