<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost Response Element that represents the Reference to the Internal Service Delivery Document along with its content
 * @subpackage Structs
 */
class Internal_Service_Delivery_Response_DataType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the Reference to the Internal Service Delivery Document along with its content
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_OutboundType[]
     */
    public $Internal_Service_Delivery;
    /**
     * Constructor method for Internal_Service_Delivery_Response_DataType
     * @uses Internal_Service_Delivery_Response_DataType::setInternal_Service_Delivery()
     * @param \StructType\Internal_Service_Delivery_OutboundType[] $internal_Service_Delivery
     */
    public function __construct(array $internal_Service_Delivery = array())
    {
        $this
            ->setInternal_Service_Delivery($internal_Service_Delivery);
    }
    /**
     * Get Internal_Service_Delivery value
     * @return \StructType\Internal_Service_Delivery_OutboundType[]|null
     */
    public function getInternal_Service_Delivery()
    {
        return $this->Internal_Service_Delivery;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Delivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Delivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_DeliveryForArrayConstraintsFromSetInternal_Service_Delivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem instanceof \StructType\Internal_Service_Delivery_OutboundType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem) ? get_class($internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem), var_export($internal_Service_Delivery_Response_DataTypeInternal_Service_DeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Delivery property can only contain items of type \StructType\Internal_Service_Delivery_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Delivery value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_OutboundType[] $internal_Service_Delivery
     * @return \StructType\Internal_Service_Delivery_Response_DataType
     */
    public function setInternal_Service_Delivery(array $internal_Service_Delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_DeliveryArrayErrorMessage = self::validateInternal_Service_DeliveryForArrayConstraintsFromSetInternal_Service_Delivery($internal_Service_Delivery))) {
            throw new \InvalidArgumentException($internal_Service_DeliveryArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Delivery = $internal_Service_Delivery;
        return $this;
    }
    /**
     * Add item to Internal_Service_Delivery value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_OutboundType $item
     * @return \StructType\Internal_Service_Delivery_Response_DataType
     */
    public function addToInternal_Service_Delivery(\StructType\Internal_Service_Delivery_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Delivery_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Delivery property can only contain items of type \StructType\Internal_Service_Delivery_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Delivery[] = $item;
        return $this;
    }
}
