<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Goods_Line_Add_Hold_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Goods Line Add Hold Data
 * @subpackage Structs
 */
class Goods_Line_Add_Hold_DataType extends AbstractStructBase
{
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line NumbercXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@lineNumber | Purchase Order Line Number from which the business asset was ordered | This is the Supplier Contract Line Number for the Supplier
     * Contract Line you wish to put on Hold. | RFQ Line Number | The line number of the Purchase Order. | Line Number
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Number;
    /**
     * Constructor method for Goods_Line_Add_Hold_DataType
     * @uses Goods_Line_Add_Hold_DataType::setLine_Number()
     * @param string $line_Number
     */
    public function __construct($line_Number = null)
    {
        $this
            ->setLine_Number($line_Number);
    }
    /**
     * Get Line_Number value
     * @return string|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param string $line_Number
     * @return \StructType\Goods_Line_Add_Hold_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: string
        if (!is_null($line_Number) && !is_string($line_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($line_Number) && mb_strlen($line_Number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($line_Number)), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
}
