<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Expense Report Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Expense_Report_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Applicant, Contingent Worker, or Employee
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType[]
     */
    public $Expense_Payee_Reference;
    /**
     * The Expense_Payee_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The type of Expense Payee for the expense report (Applicant, Contingent Worker, or Employee).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Expense_Payee_Type_Reference;
    /**
     * The Expense_Report_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Report From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_From_Date;
    /**
     * The Expense_Report_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Report To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_To_Date;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Expense_Report_Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the payment status of the expense report (paid or unpaid)
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Expense_Report_Payment_Status_Reference;
    /**
     * The Created_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Created From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_From_Date;
    /**
     * The Created_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Created To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Created_To_Date;
    /**
     * The Approved_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Approved From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_From_Date;
    /**
     * The Approved_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Approved To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Approved_To_Date;
    /**
     * The Payment_Updated_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Payment Updated From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Updated_From_Date;
    /**
     * The Payment_Updated_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Payment Updated To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Updated_To_Date;
    /**
     * The Payment_Update_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the payment update type (Expense Report Payment Paid or Expense Report Payment Canceled)
     * - minOccurs: 0
     * @var \StructType\Event_Lite_TypeObjectType
     */
    public $Payment_Update_Type_Reference;
    /**
     * The Market_Code
     * Meta information extracted from the WSDL
     * - documentation: Market Code for an expense report line on the expense report with either a Credit Card or a Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Market_Code;
    /**
     * The Corporate_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the corporate credit card account for an expense report line on the expense report with either a Credit Card or a Credit Card Transaction
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Account_Reference;
    /**
     * Constructor method for Expense_Report_Request_CriteriaType
     * @uses Expense_Report_Request_CriteriaType::setOrganization_Reference()
     * @uses Expense_Report_Request_CriteriaType::setExpense_Payee_Reference()
     * @uses Expense_Report_Request_CriteriaType::setExpense_Payee_Type_Reference()
     * @uses Expense_Report_Request_CriteriaType::setExpense_Report_From_Date()
     * @uses Expense_Report_Request_CriteriaType::setExpense_Report_To_Date()
     * @uses Expense_Report_Request_CriteriaType::setDocument_Number()
     * @uses Expense_Report_Request_CriteriaType::setExpense_Report_Payment_Status_Reference()
     * @uses Expense_Report_Request_CriteriaType::setCreated_From_Date()
     * @uses Expense_Report_Request_CriteriaType::setCreated_To_Date()
     * @uses Expense_Report_Request_CriteriaType::setApproved_From_Date()
     * @uses Expense_Report_Request_CriteriaType::setApproved_To_Date()
     * @uses Expense_Report_Request_CriteriaType::setPayment_Updated_From_Date()
     * @uses Expense_Report_Request_CriteriaType::setPayment_Updated_To_Date()
     * @uses Expense_Report_Request_CriteriaType::setPayment_Update_Type_Reference()
     * @uses Expense_Report_Request_CriteriaType::setMarket_Code()
     * @uses Expense_Report_Request_CriteriaType::setCorporate_Account_Reference()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $expense_Payee_Type_Reference
     * @param string $expense_Report_From_Date
     * @param string $expense_Report_To_Date
     * @param string $document_Number
     * @param \StructType\Document_Payment_StatusObjectType $expense_Report_Payment_Status_Reference
     * @param string $created_From_Date
     * @param string $created_To_Date
     * @param string $approved_From_Date
     * @param string $approved_To_Date
     * @param string $payment_Updated_From_Date
     * @param string $payment_Updated_To_Date
     * @param \StructType\Event_Lite_TypeObjectType $payment_Update_Type_Reference
     * @param string $market_Code
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     */
    public function __construct(array $organization_Reference = array(), array $expense_Payee_Reference = array(), array $expense_Payee_Type_Reference = array(), $expense_Report_From_Date = null, $expense_Report_To_Date = null, $document_Number = null, \StructType\Document_Payment_StatusObjectType $expense_Report_Payment_Status_Reference = null, $created_From_Date = null, $created_To_Date = null, $approved_From_Date = null, $approved_To_Date = null, $payment_Updated_From_Date = null, $payment_Updated_To_Date = null, \StructType\Event_Lite_TypeObjectType $payment_Update_Type_Reference = null, $market_Code = null, \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setExpense_Payee_Type_Reference($expense_Payee_Type_Reference)
            ->setExpense_Report_From_Date($expense_Report_From_Date)
            ->setExpense_Report_To_Date($expense_Report_To_Date)
            ->setDocument_Number($document_Number)
            ->setExpense_Report_Payment_Status_Reference($expense_Report_Payment_Status_Reference)
            ->setCreated_From_Date($created_From_Date)
            ->setCreated_To_Date($created_To_Date)
            ->setApproved_From_Date($approved_From_Date)
            ->setApproved_To_Date($approved_To_Date)
            ->setPayment_Updated_From_Date($payment_Updated_From_Date)
            ->setPayment_Updated_To_Date($payment_Updated_To_Date)
            ->setPayment_Update_Type_Reference($payment_Update_Type_Reference)
            ->setMarket_Code($market_Code)
            ->setCorporate_Account_Reference($corporate_Account_Reference);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($expense_Report_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($expense_Report_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Request_CriteriaTypeOrganization_ReferenceItem), var_export($expense_Report_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType[]|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem instanceof \StructType\Expense_PayeeObjectType) {
                $invalidValues[] = is_object($expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem) ? get_class($expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem), var_export($expense_Report_Request_CriteriaTypeExpense_Payee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setExpense_Payee_Reference(array $expense_Payee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_ReferenceArrayErrorMessage = self::validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference($expense_Payee_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $item
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function addToExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_PayeeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Payee_Type_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getExpense_Payee_Type_Reference()
    {
        return $this->Expense_Payee_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_Type_ReferenceForArrayConstraintsFromSetExpense_Payee_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) ? get_class($expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem), var_export($expense_Report_Request_CriteriaTypeExpense_Payee_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Type_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $expense_Payee_Type_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setExpense_Payee_Type_Reference(array $expense_Payee_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_Type_ReferenceArrayErrorMessage = self::validateExpense_Payee_Type_ReferenceForArrayConstraintsFromSetExpense_Payee_Type_Reference($expense_Payee_Type_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Type_Reference = $expense_Payee_Type_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function addToExpense_Payee_Type_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Type_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Report_From_Date value
     * @return string|null
     */
    public function getExpense_Report_From_Date()
    {
        return $this->Expense_Report_From_Date;
    }
    /**
     * Set Expense_Report_From_Date value
     * @param string $expense_Report_From_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setExpense_Report_From_Date($expense_Report_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_From_Date) && !is_string($expense_Report_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_From_Date, true), gettype($expense_Report_From_Date)), __LINE__);
        }
        $this->Expense_Report_From_Date = $expense_Report_From_Date;
        return $this;
    }
    /**
     * Get Expense_Report_To_Date value
     * @return string|null
     */
    public function getExpense_Report_To_Date()
    {
        return $this->Expense_Report_To_Date;
    }
    /**
     * Set Expense_Report_To_Date value
     * @param string $expense_Report_To_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setExpense_Report_To_Date($expense_Report_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_To_Date) && !is_string($expense_Report_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_To_Date, true), gettype($expense_Report_To_Date)), __LINE__);
        }
        $this->Expense_Report_To_Date = $expense_Report_To_Date;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Expense_Report_Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getExpense_Report_Payment_Status_Reference()
    {
        return $this->Expense_Report_Payment_Status_Reference;
    }
    /**
     * Set Expense_Report_Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $expense_Report_Payment_Status_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setExpense_Report_Payment_Status_Reference(\StructType\Document_Payment_StatusObjectType $expense_Report_Payment_Status_Reference = null)
    {
        $this->Expense_Report_Payment_Status_Reference = $expense_Report_Payment_Status_Reference;
        return $this;
    }
    /**
     * Get Created_From_Date value
     * @return string|null
     */
    public function getCreated_From_Date()
    {
        return $this->Created_From_Date;
    }
    /**
     * Set Created_From_Date value
     * @param string $created_From_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setCreated_From_Date($created_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($created_From_Date) && !is_string($created_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_From_Date, true), gettype($created_From_Date)), __LINE__);
        }
        $this->Created_From_Date = $created_From_Date;
        return $this;
    }
    /**
     * Get Created_To_Date value
     * @return string|null
     */
    public function getCreated_To_Date()
    {
        return $this->Created_To_Date;
    }
    /**
     * Set Created_To_Date value
     * @param string $created_To_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setCreated_To_Date($created_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($created_To_Date) && !is_string($created_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created_To_Date, true), gettype($created_To_Date)), __LINE__);
        }
        $this->Created_To_Date = $created_To_Date;
        return $this;
    }
    /**
     * Get Approved_From_Date value
     * @return string|null
     */
    public function getApproved_From_Date()
    {
        return $this->Approved_From_Date;
    }
    /**
     * Set Approved_From_Date value
     * @param string $approved_From_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setApproved_From_Date($approved_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_From_Date) && !is_string($approved_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_From_Date, true), gettype($approved_From_Date)), __LINE__);
        }
        $this->Approved_From_Date = $approved_From_Date;
        return $this;
    }
    /**
     * Get Approved_To_Date value
     * @return string|null
     */
    public function getApproved_To_Date()
    {
        return $this->Approved_To_Date;
    }
    /**
     * Set Approved_To_Date value
     * @param string $approved_To_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setApproved_To_Date($approved_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($approved_To_Date) && !is_string($approved_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved_To_Date, true), gettype($approved_To_Date)), __LINE__);
        }
        $this->Approved_To_Date = $approved_To_Date;
        return $this;
    }
    /**
     * Get Payment_Updated_From_Date value
     * @return string|null
     */
    public function getPayment_Updated_From_Date()
    {
        return $this->Payment_Updated_From_Date;
    }
    /**
     * Set Payment_Updated_From_Date value
     * @param string $payment_Updated_From_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setPayment_Updated_From_Date($payment_Updated_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Updated_From_Date) && !is_string($payment_Updated_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Updated_From_Date, true), gettype($payment_Updated_From_Date)), __LINE__);
        }
        $this->Payment_Updated_From_Date = $payment_Updated_From_Date;
        return $this;
    }
    /**
     * Get Payment_Updated_To_Date value
     * @return string|null
     */
    public function getPayment_Updated_To_Date()
    {
        return $this->Payment_Updated_To_Date;
    }
    /**
     * Set Payment_Updated_To_Date value
     * @param string $payment_Updated_To_Date
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setPayment_Updated_To_Date($payment_Updated_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Updated_To_Date) && !is_string($payment_Updated_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Updated_To_Date, true), gettype($payment_Updated_To_Date)), __LINE__);
        }
        $this->Payment_Updated_To_Date = $payment_Updated_To_Date;
        return $this;
    }
    /**
     * Get Payment_Update_Type_Reference value
     * @return \StructType\Event_Lite_TypeObjectType|null
     */
    public function getPayment_Update_Type_Reference()
    {
        return $this->Payment_Update_Type_Reference;
    }
    /**
     * Set Payment_Update_Type_Reference value
     * @param \StructType\Event_Lite_TypeObjectType $payment_Update_Type_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setPayment_Update_Type_Reference(\StructType\Event_Lite_TypeObjectType $payment_Update_Type_Reference = null)
    {
        $this->Payment_Update_Type_Reference = $payment_Update_Type_Reference;
        return $this;
    }
    /**
     * Get Market_Code value
     * @return string|null
     */
    public function getMarket_Code()
    {
        return $this->Market_Code;
    }
    /**
     * Set Market_Code value
     * @param string $market_Code
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setMarket_Code($market_Code = null)
    {
        // validation for constraint: string
        if (!is_null($market_Code) && !is_string($market_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($market_Code, true), gettype($market_Code)), __LINE__);
        }
        $this->Market_Code = $market_Code;
        return $this;
    }
    /**
     * Get Corporate_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Account_Reference()
    {
        return $this->Corporate_Account_Reference;
    }
    /**
     * Set Corporate_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     * @return \StructType\Expense_Report_Request_CriteriaType
     */
    public function setCorporate_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null)
    {
        $this->Corporate_Account_Reference = $corporate_Account_Reference;
        return $this;
    }
}
