<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Condition_Rule_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper containing data for Condition Rule.
 * @subpackage Structs
 */
class Condition_Rule_Data_WWSType extends AbstractStructBase
{
    /**
     * The Condition_Rule_ID
     * Meta information extracted from the WSDL
     * - documentation: Text value for reference ID for Condition Rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Condition_Rule_ID;
    /**
     * The Rule_Description
     * Meta information extracted from the WSDL
     * - documentation: Text description of Condition Rule.
     * - maxOccurs: 1
     * @var string
     */
    public $Rule_Description;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Text comment for Condition Rule.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Condition_Rule_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Categories for Condition Rule.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Condition_Rule_CategoryObjectType[]
     */
    public $Condition_Rule_Category_Reference;
    /**
     * The Condition_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Data for each Condition Rule
     * - maxOccurs: unbounded
     * @var \StructType\Condition_Item_Data_WWSType[]
     */
    public $Condition_Item_Data;
    /**
     * The Countries_Reference
     * Meta information extracted from the WSDL
     * - documentation: Countries for Condition Rule
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CountryObjectType[]
     */
    public $Countries_Reference;
    /**
     * Constructor method for Condition_Rule_Data_WWSType
     * @uses Condition_Rule_Data_WWSType::setCondition_Rule_ID()
     * @uses Condition_Rule_Data_WWSType::setRule_Description()
     * @uses Condition_Rule_Data_WWSType::setComment()
     * @uses Condition_Rule_Data_WWSType::setCondition_Rule_Category_Reference()
     * @uses Condition_Rule_Data_WWSType::setCondition_Item_Data()
     * @uses Condition_Rule_Data_WWSType::setCountries_Reference()
     * @param string $condition_Rule_ID
     * @param string $rule_Description
     * @param string $comment
     * @param \StructType\Condition_Rule_CategoryObjectType[] $condition_Rule_Category_Reference
     * @param \StructType\Condition_Item_Data_WWSType[] $condition_Item_Data
     * @param \StructType\CountryObjectType[] $countries_Reference
     */
    public function __construct($condition_Rule_ID = null, $rule_Description = null, $comment = null, array $condition_Rule_Category_Reference = array(), array $condition_Item_Data = array(), array $countries_Reference = array())
    {
        $this
            ->setCondition_Rule_ID($condition_Rule_ID)
            ->setRule_Description($rule_Description)
            ->setComment($comment)
            ->setCondition_Rule_Category_Reference($condition_Rule_Category_Reference)
            ->setCondition_Item_Data($condition_Item_Data)
            ->setCountries_Reference($countries_Reference);
    }
    /**
     * Get Condition_Rule_ID value
     * @return string|null
     */
    public function getCondition_Rule_ID()
    {
        return $this->Condition_Rule_ID;
    }
    /**
     * Set Condition_Rule_ID value
     * @param string $condition_Rule_ID
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setCondition_Rule_ID($condition_Rule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($condition_Rule_ID) && !is_string($condition_Rule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condition_Rule_ID, true), gettype($condition_Rule_ID)), __LINE__);
        }
        $this->Condition_Rule_ID = $condition_Rule_ID;
        return $this;
    }
    /**
     * Get Rule_Description value
     * @return string|null
     */
    public function getRule_Description()
    {
        return $this->Rule_Description;
    }
    /**
     * Set Rule_Description value
     * @param string $rule_Description
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setRule_Description($rule_Description = null)
    {
        // validation for constraint: string
        if (!is_null($rule_Description) && !is_string($rule_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rule_Description, true), gettype($rule_Description)), __LINE__);
        }
        $this->Rule_Description = $rule_Description;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Condition_Rule_Category_Reference value
     * @return \StructType\Condition_Rule_CategoryObjectType[]|null
     */
    public function getCondition_Rule_Category_Reference()
    {
        return $this->Condition_Rule_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCondition_Rule_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCondition_Rule_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCondition_Rule_Category_ReferenceForArrayConstraintsFromSetCondition_Rule_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem instanceof \StructType\Condition_Rule_CategoryObjectType) {
                $invalidValues[] = is_object($condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem) ? get_class($condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem) : sprintf('%s(%s)', gettype($condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem), var_export($condition_Rule_Data_WWSTypeCondition_Rule_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Condition_Rule_Category_Reference property can only contain items of type \StructType\Condition_Rule_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Condition_Rule_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Rule_CategoryObjectType[] $condition_Rule_Category_Reference
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setCondition_Rule_Category_Reference(array $condition_Rule_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($condition_Rule_Category_ReferenceArrayErrorMessage = self::validateCondition_Rule_Category_ReferenceForArrayConstraintsFromSetCondition_Rule_Category_Reference($condition_Rule_Category_Reference))) {
            throw new \InvalidArgumentException($condition_Rule_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Condition_Rule_Category_Reference = $condition_Rule_Category_Reference;
        return $this;
    }
    /**
     * Add item to Condition_Rule_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Rule_CategoryObjectType $item
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function addToCondition_Rule_Category_Reference(\StructType\Condition_Rule_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Condition_Rule_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Condition_Rule_Category_Reference property can only contain items of type \StructType\Condition_Rule_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Condition_Rule_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Condition_Item_Data value
     * @return \StructType\Condition_Item_Data_WWSType[]|null
     */
    public function getCondition_Item_Data()
    {
        return $this->Condition_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCondition_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCondition_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCondition_Item_DataForArrayConstraintsFromSetCondition_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $condition_Rule_Data_WWSTypeCondition_Item_DataItem) {
            // validation for constraint: itemType
            if (!$condition_Rule_Data_WWSTypeCondition_Item_DataItem instanceof \StructType\Condition_Item_Data_WWSType) {
                $invalidValues[] = is_object($condition_Rule_Data_WWSTypeCondition_Item_DataItem) ? get_class($condition_Rule_Data_WWSTypeCondition_Item_DataItem) : sprintf('%s(%s)', gettype($condition_Rule_Data_WWSTypeCondition_Item_DataItem), var_export($condition_Rule_Data_WWSTypeCondition_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Condition_Item_Data property can only contain items of type \StructType\Condition_Item_Data_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Condition_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Item_Data_WWSType[] $condition_Item_Data
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setCondition_Item_Data(array $condition_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($condition_Item_DataArrayErrorMessage = self::validateCondition_Item_DataForArrayConstraintsFromSetCondition_Item_Data($condition_Item_Data))) {
            throw new \InvalidArgumentException($condition_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Condition_Item_Data = $condition_Item_Data;
        return $this;
    }
    /**
     * Add item to Condition_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_Item_Data_WWSType $item
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function addToCondition_Item_Data(\StructType\Condition_Item_Data_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Condition_Item_Data_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Condition_Item_Data property can only contain items of type \StructType\Condition_Item_Data_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Condition_Item_Data[] = $item;
        return $this;
    }
    /**
     * Get Countries_Reference value
     * @return \StructType\CountryObjectType[]|null
     */
    public function getCountries_Reference()
    {
        return $this->Countries_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCountries_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCountries_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCountries_ReferenceForArrayConstraintsFromSetCountries_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $condition_Rule_Data_WWSTypeCountries_ReferenceItem) {
            // validation for constraint: itemType
            if (!$condition_Rule_Data_WWSTypeCountries_ReferenceItem instanceof \StructType\CountryObjectType) {
                $invalidValues[] = is_object($condition_Rule_Data_WWSTypeCountries_ReferenceItem) ? get_class($condition_Rule_Data_WWSTypeCountries_ReferenceItem) : sprintf('%s(%s)', gettype($condition_Rule_Data_WWSTypeCountries_ReferenceItem), var_export($condition_Rule_Data_WWSTypeCountries_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Countries_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Countries_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType[] $countries_Reference
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function setCountries_Reference(array $countries_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($countries_ReferenceArrayErrorMessage = self::validateCountries_ReferenceForArrayConstraintsFromSetCountries_Reference($countries_Reference))) {
            throw new \InvalidArgumentException($countries_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Countries_Reference = $countries_Reference;
        return $this;
    }
    /**
     * Add item to Countries_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryObjectType $item
     * @return \StructType\Condition_Rule_Data_WWSType
     */
    public function addToCountries_Reference(\StructType\CountryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Countries_Reference property can only contain items of type \StructType\CountryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Countries_Reference[] = $item;
        return $this;
    }
}
