<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_AmendmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Contract Amendment
 * @subpackage Structs
 */
class Supplier_Contract_AmendmentType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Amendment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Amendment Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_AmendmentObjectType
     */
    public $Supplier_Contract_Amendment_Reference;
    /**
     * The Contract_Version
     * Meta information extracted from the WSDL
     * - documentation: Supplier contract version number
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Contract_Version;
    /**
     * The Amendment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier contract amendment status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Amendment_Status_Reference;
    /**
     * The Supplier_Contract_Amendment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Amendment_DataType[]
     */
    public $Supplier_Contract_Amendment_Data;
    /**
     * Constructor method for Supplier_Contract_AmendmentType
     * @uses Supplier_Contract_AmendmentType::setSupplier_Contract_Amendment_Reference()
     * @uses Supplier_Contract_AmendmentType::setContract_Version()
     * @uses Supplier_Contract_AmendmentType::setAmendment_Status_Reference()
     * @uses Supplier_Contract_AmendmentType::setSupplier_Contract_Amendment_Data()
     * @param \StructType\Supplier_Contract_AmendmentObjectType $supplier_Contract_Amendment_Reference
     * @param float $contract_Version
     * @param \StructType\Document_StatusObjectType $amendment_Status_Reference
     * @param \StructType\Supplier_Contract_Amendment_DataType[] $supplier_Contract_Amendment_Data
     */
    public function __construct(\StructType\Supplier_Contract_AmendmentObjectType $supplier_Contract_Amendment_Reference = null, $contract_Version = null, \StructType\Document_StatusObjectType $amendment_Status_Reference = null, array $supplier_Contract_Amendment_Data = array())
    {
        $this
            ->setSupplier_Contract_Amendment_Reference($supplier_Contract_Amendment_Reference)
            ->setContract_Version($contract_Version)
            ->setAmendment_Status_Reference($amendment_Status_Reference)
            ->setSupplier_Contract_Amendment_Data($supplier_Contract_Amendment_Data);
    }
    /**
     * Get Supplier_Contract_Amendment_Reference value
     * @return \StructType\Supplier_Contract_AmendmentObjectType|null
     */
    public function getSupplier_Contract_Amendment_Reference()
    {
        return $this->Supplier_Contract_Amendment_Reference;
    }
    /**
     * Set Supplier_Contract_Amendment_Reference value
     * @param \StructType\Supplier_Contract_AmendmentObjectType $supplier_Contract_Amendment_Reference
     * @return \StructType\Supplier_Contract_AmendmentType
     */
    public function setSupplier_Contract_Amendment_Reference(\StructType\Supplier_Contract_AmendmentObjectType $supplier_Contract_Amendment_Reference = null)
    {
        $this->Supplier_Contract_Amendment_Reference = $supplier_Contract_Amendment_Reference;
        return $this;
    }
    /**
     * Get Contract_Version value
     * @return float|null
     */
    public function getContract_Version()
    {
        return $this->Contract_Version;
    }
    /**
     * Set Contract_Version value
     * @param float $contract_Version
     * @return \StructType\Supplier_Contract_AmendmentType
     */
    public function setContract_Version($contract_Version = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Version) && !(is_float($contract_Version) || is_numeric($contract_Version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Version, true), gettype($contract_Version)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($contract_Version) && mb_strlen(mb_substr($contract_Version, false !== mb_strpos($contract_Version, '.') ? mb_strpos($contract_Version, '.') + 1 : mb_strlen($contract_Version))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($contract_Version, true), mb_strlen(mb_substr($contract_Version, mb_strpos($contract_Version, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($contract_Version) && $contract_Version < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($contract_Version, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($contract_Version) && mb_strlen(preg_replace('/(\D)/', '', $contract_Version)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($contract_Version, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Version))), __LINE__);
        }
        $this->Contract_Version = $contract_Version;
        return $this;
    }
    /**
     * Get Amendment_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getAmendment_Status_Reference()
    {
        return $this->Amendment_Status_Reference;
    }
    /**
     * Set Amendment_Status_Reference value
     * @param \StructType\Document_StatusObjectType $amendment_Status_Reference
     * @return \StructType\Supplier_Contract_AmendmentType
     */
    public function setAmendment_Status_Reference(\StructType\Document_StatusObjectType $amendment_Status_Reference = null)
    {
        $this->Amendment_Status_Reference = $amendment_Status_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Amendment_Data value
     * @return \StructType\Supplier_Contract_Amendment_DataType[]|null
     */
    public function getSupplier_Contract_Amendment_Data()
    {
        return $this->Supplier_Contract_Amendment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Amendment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Amendment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Amendment_DataForArrayConstraintsFromSetSupplier_Contract_Amendment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem instanceof \StructType\Supplier_Contract_Amendment_DataType) {
                $invalidValues[] = is_object($supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem) ? get_class($supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem) : sprintf('%s(%s)', gettype($supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem), var_export($supplier_Contract_AmendmentTypeSupplier_Contract_Amendment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Amendment_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Amendment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_DataType[] $supplier_Contract_Amendment_Data
     * @return \StructType\Supplier_Contract_AmendmentType
     */
    public function setSupplier_Contract_Amendment_Data(array $supplier_Contract_Amendment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Amendment_DataArrayErrorMessage = self::validateSupplier_Contract_Amendment_DataForArrayConstraintsFromSetSupplier_Contract_Amendment_Data($supplier_Contract_Amendment_Data))) {
            throw new \InvalidArgumentException($supplier_Contract_Amendment_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Amendment_Data = $supplier_Contract_Amendment_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Amendment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Amendment_DataType $item
     * @return \StructType\Supplier_Contract_AmendmentType
     */
    public function addToSupplier_Contract_Amendment_Data(\StructType\Supplier_Contract_Amendment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Amendment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Amendment_Data property can only contain items of type \StructType\Supplier_Contract_Amendment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Amendment_Data[] = $item;
        return $this;
    }
}
