<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_ConnectionType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Element contains the owning Supplier Reference and Supplier Connection Data
 * @subpackage Structs
 */
class Supplier_ConnectionType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Reference which owns Supplier Connections in Supplier Connection Data
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Connection_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplier_Connection_DataType
     */
    public $Supplier_Connection_Data;
    /**
     * Constructor method for Supplier_ConnectionType
     * @uses Supplier_ConnectionType::setSupplier_Reference()
     * @uses Supplier_ConnectionType::setSupplier_Connection_Data()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Supplier_Connection_DataType $supplier_Connection_Data
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Supplier_Connection_DataType $supplier_Connection_Data = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Connection_Data($supplier_Connection_Data);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_ConnectionType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_Data value
     * @return \StructType\Supplier_Connection_DataType|null
     */
    public function getSupplier_Connection_Data()
    {
        return $this->Supplier_Connection_Data;
    }
    /**
     * Set Supplier_Connection_Data value
     * @param \StructType\Supplier_Connection_DataType $supplier_Connection_Data
     * @return \StructType\Supplier_ConnectionType
     */
    public function setSupplier_Connection_Data(\StructType\Supplier_Connection_DataType $supplier_Connection_Data = null)
    {
        $this->Supplier_Connection_Data = $supplier_Connection_Data;
        return $this;
    }
}
