<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Request for Quote line data.
 * @subpackage Structs
 */
class Request_for_Quote_Line_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Line_ID;
    /**
     * The Request_for_Quote_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Reference.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_LineObjectType
     */
    public $Request_for_Quote_Line_Reference;
    /**
     * The Line_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Line Type Reference
     * @var \StructType\Request_for_Quote_Line_TypeObjectType
     */
    public $Line_Type_Reference;
    /**
     * The Requisition_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition Line sourced to the Request for Quote Line. This field is read only.
     * - minOccurs: 0
     * @var \StructType\Requisition_LineObjectType
     */
    public $Requisition_Line_Reference;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 5
     * @var float
     */
    public $Line_Number;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Target_Price
     * Meta information extracted from the WSDL
     * - documentation: Target Price. | Target Price recorded on Request for Quote Line. | Target Price of the RFQ Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Target_Price;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Requested Delivery Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Response_Required
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate whether the line needs to be in present when processing RFQ Response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Response_Required;
    /**
     * The Unit_Price_Required
     * Meta information extracted from the WSDL
     * - documentation: Price Required.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Unit_Price_Required;
    /**
     * The Lead_Time_Required
     * Meta information extracted from the WSDL
     * - documentation: Lead Time Required.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Lead_Time_Required;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Request_for_Quote_Line_Bid_Requirement_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Bid Requirement Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Line_Bid_Requirement_DataType[]
     */
    public $Request_for_Quote_Line_Bid_Requirement_Data;
    /**
     * The Request_for_Quote_Line_Split_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Split Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Line_Splits_DataType[]
     */
    public $Request_for_Quote_Line_Split_Data;
    /**
     * The Business_Document_Line_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Line_Attachment_Data;
    /**
     * Constructor method for Request_for_Quote_Line_DataType
     * @uses Request_for_Quote_Line_DataType::setRequest_for_Quote_Line_ID()
     * @uses Request_for_Quote_Line_DataType::setRequest_for_Quote_Line_Reference()
     * @uses Request_for_Quote_Line_DataType::setLine_Type_Reference()
     * @uses Request_for_Quote_Line_DataType::setRequisition_Line_Reference()
     * @uses Request_for_Quote_Line_DataType::setLine_Number()
     * @uses Request_for_Quote_Line_DataType::setItem_Reference()
     * @uses Request_for_Quote_Line_DataType::setItem_Description()
     * @uses Request_for_Quote_Line_DataType::setSpend_Category_Reference()
     * @uses Request_for_Quote_Line_DataType::setQuantity()
     * @uses Request_for_Quote_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Request_for_Quote_Line_DataType::setUnit_Cost()
     * @uses Request_for_Quote_Line_DataType::setExtended_Amount()
     * @uses Request_for_Quote_Line_DataType::setTarget_Price()
     * @uses Request_for_Quote_Line_DataType::setRequested_Delivery_Date()
     * @uses Request_for_Quote_Line_DataType::setStart_Date()
     * @uses Request_for_Quote_Line_DataType::setEnd_Date()
     * @uses Request_for_Quote_Line_DataType::setResponse_Required()
     * @uses Request_for_Quote_Line_DataType::setUnit_Price_Required()
     * @uses Request_for_Quote_Line_DataType::setLead_Time_Required()
     * @uses Request_for_Quote_Line_DataType::setWorktags_Reference()
     * @uses Request_for_Quote_Line_DataType::setMemo()
     * @uses Request_for_Quote_Line_DataType::setRequest_for_Quote_Line_Bid_Requirement_Data()
     * @uses Request_for_Quote_Line_DataType::setRequest_for_Quote_Line_Split_Data()
     * @uses Request_for_Quote_Line_DataType::setBusiness_Document_Line_Attachment_Data()
     * @param string $request_for_Quote_Line_ID
     * @param \StructType\Request_for_Quote_LineObjectType $request_for_Quote_Line_Reference
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @param float $line_Number
     * @param \StructType\Purchase_ItemObjectType $item_Reference
     * @param string $item_Description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param float $target_Price
     * @param string $requested_Delivery_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param bool $response_Required
     * @param bool $unit_Price_Required
     * @param bool $lead_Time_Required
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $memo
     * @param \StructType\Request_for_Quote_Line_Bid_Requirement_DataType[] $request_for_Quote_Line_Bid_Requirement_Data
     * @param \StructType\Request_for_Quote_Line_Splits_DataType[] $request_for_Quote_Line_Split_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     */
    public function __construct($request_for_Quote_Line_ID = null, \StructType\Request_for_Quote_LineObjectType $request_for_Quote_Line_Reference = null, \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null, \StructType\Requisition_LineObjectType $requisition_Line_Reference = null, $line_Number = null, \StructType\Purchase_ItemObjectType $item_Reference = null, $item_Description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, $target_Price = null, $requested_Delivery_Date = null, $start_Date = null, $end_Date = null, $response_Required = null, $unit_Price_Required = null, $lead_Time_Required = null, array $worktags_Reference = array(), $memo = null, array $request_for_Quote_Line_Bid_Requirement_Data = array(), array $request_for_Quote_Line_Split_Data = array(), array $business_Document_Line_Attachment_Data = array())
    {
        $this
            ->setRequest_for_Quote_Line_ID($request_for_Quote_Line_ID)
            ->setRequest_for_Quote_Line_Reference($request_for_Quote_Line_Reference)
            ->setLine_Type_Reference($line_Type_Reference)
            ->setRequisition_Line_Reference($requisition_Line_Reference)
            ->setLine_Number($line_Number)
            ->setItem_Reference($item_Reference)
            ->setItem_Description($item_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setTarget_Price($target_Price)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setResponse_Required($response_Required)
            ->setUnit_Price_Required($unit_Price_Required)
            ->setLead_Time_Required($lead_Time_Required)
            ->setWorktags_Reference($worktags_Reference)
            ->setMemo($memo)
            ->setRequest_for_Quote_Line_Bid_Requirement_Data($request_for_Quote_Line_Bid_Requirement_Data)
            ->setRequest_for_Quote_Line_Split_Data($request_for_Quote_Line_Split_Data)
            ->setBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data);
    }
    /**
     * Get Request_for_Quote_Line_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_Line_ID()
    {
        return $this->Request_for_Quote_Line_ID;
    }
    /**
     * Set Request_for_Quote_Line_ID value
     * @param string $request_for_Quote_Line_ID
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequest_for_Quote_Line_ID($request_for_Quote_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Line_ID) && !is_string($request_for_Quote_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Line_ID, true), gettype($request_for_Quote_Line_ID)), __LINE__);
        }
        $this->Request_for_Quote_Line_ID = $request_for_Quote_Line_ID;
        return $this;
    }
    /**
     * Get Request_for_Quote_Line_Reference value
     * @return \StructType\Request_for_Quote_LineObjectType|null
     */
    public function getRequest_for_Quote_Line_Reference()
    {
        return $this->Request_for_Quote_Line_Reference;
    }
    /**
     * Set Request_for_Quote_Line_Reference value
     * @param \StructType\Request_for_Quote_LineObjectType $request_for_Quote_Line_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequest_for_Quote_Line_Reference(\StructType\Request_for_Quote_LineObjectType $request_for_Quote_Line_Reference = null)
    {
        $this->Request_for_Quote_Line_Reference = $request_for_Quote_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Type_Reference value
     * @return \StructType\Request_for_Quote_Line_TypeObjectType|null
     */
    public function getLine_Type_Reference()
    {
        return $this->Line_Type_Reference;
    }
    /**
     * Set Line_Type_Reference value
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setLine_Type_Reference(\StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null)
    {
        $this->Line_Type_Reference = $line_Type_Reference;
        return $this;
    }
    /**
     * Get Requisition_Line_Reference value
     * @return \StructType\Requisition_LineObjectType|null
     */
    public function getRequisition_Line_Reference()
    {
        return $this->Requisition_Line_Reference;
    }
    /**
     * Set Requisition_Line_Reference value
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequisition_Line_Reference(\StructType\Requisition_LineObjectType $requisition_Line_Reference = null)
    {
        $this->Requisition_Line_Reference = $requisition_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $item_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setItem_Reference(\StructType\Purchase_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Target_Price value
     * @return float|null
     */
    public function getTarget_Price()
    {
        return $this->Target_Price;
    }
    /**
     * Set Target_Price value
     * @param float $target_Price
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setTarget_Price($target_Price = null)
    {
        // validation for constraint: float
        if (!is_null($target_Price) && !(is_float($target_Price) || is_numeric($target_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($target_Price, true), gettype($target_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($target_Price) && mb_strlen(mb_substr($target_Price, false !== mb_strpos($target_Price, '.') ? mb_strpos($target_Price, '.') + 1 : mb_strlen($target_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($target_Price, true), mb_strlen(mb_substr($target_Price, mb_strpos($target_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($target_Price) && $target_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($target_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($target_Price) && mb_strlen(preg_replace('/(\D)/', '', $target_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($target_Price, true), mb_strlen(preg_replace('/(\D)/', '', $target_Price))), __LINE__);
        }
        $this->Target_Price = $target_Price;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Response_Required value
     * @return bool|null
     */
    public function getResponse_Required()
    {
        return $this->Response_Required;
    }
    /**
     * Set Response_Required value
     * @param bool $response_Required
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setResponse_Required($response_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($response_Required) && !is_bool($response_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($response_Required, true), gettype($response_Required)), __LINE__);
        }
        $this->Response_Required = $response_Required;
        return $this;
    }
    /**
     * Get Unit_Price_Required value
     * @return bool|null
     */
    public function getUnit_Price_Required()
    {
        return $this->Unit_Price_Required;
    }
    /**
     * Set Unit_Price_Required value
     * @param bool $unit_Price_Required
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setUnit_Price_Required($unit_Price_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($unit_Price_Required) && !is_bool($unit_Price_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unit_Price_Required, true), gettype($unit_Price_Required)), __LINE__);
        }
        $this->Unit_Price_Required = $unit_Price_Required;
        return $this;
    }
    /**
     * Get Lead_Time_Required value
     * @return bool|null
     */
    public function getLead_Time_Required()
    {
        return $this->Lead_Time_Required;
    }
    /**
     * Set Lead_Time_Required value
     * @param bool $lead_Time_Required
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setLead_Time_Required($lead_Time_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($lead_Time_Required) && !is_bool($lead_Time_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lead_Time_Required, true), gettype($lead_Time_Required)), __LINE__);
        }
        $this->Lead_Time_Required = $lead_Time_Required;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Line_DataTypeWorktags_ReferenceItem) ? get_class($request_for_Quote_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Line_DataTypeWorktags_ReferenceItem), var_export($request_for_Quote_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Request_for_Quote_Line_Bid_Requirement_Data value
     * @return \StructType\Request_for_Quote_Line_Bid_Requirement_DataType[]|null
     */
    public function getRequest_for_Quote_Line_Bid_Requirement_Data()
    {
        return $this->Request_for_Quote_Line_Bid_Requirement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Line_Bid_Requirement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Line_Bid_Requirement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Line_Bid_Requirement_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Bid_Requirement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem instanceof \StructType\Request_for_Quote_Line_Bid_Requirement_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem) ? get_class($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem), var_export($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Bid_Requirement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Line_Bid_Requirement_Data property can only contain items of type \StructType\Request_for_Quote_Line_Bid_Requirement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Line_Bid_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_Bid_Requirement_DataType[] $request_for_Quote_Line_Bid_Requirement_Data
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequest_for_Quote_Line_Bid_Requirement_Data(array $request_for_Quote_Line_Bid_Requirement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Line_Bid_Requirement_DataArrayErrorMessage = self::validateRequest_for_Quote_Line_Bid_Requirement_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Bid_Requirement_Data($request_for_Quote_Line_Bid_Requirement_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Line_Bid_Requirement_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Line_Bid_Requirement_Data = $request_for_Quote_Line_Bid_Requirement_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Line_Bid_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_Bid_Requirement_DataType $item
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function addToRequest_for_Quote_Line_Bid_Requirement_Data(\StructType\Request_for_Quote_Line_Bid_Requirement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Line_Bid_Requirement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Line_Bid_Requirement_Data property can only contain items of type \StructType\Request_for_Quote_Line_Bid_Requirement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Line_Bid_Requirement_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Line_Split_Data value
     * @return \StructType\Request_for_Quote_Line_Splits_DataType[]|null
     */
    public function getRequest_for_Quote_Line_Split_Data()
    {
        return $this->Request_for_Quote_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Line_Split_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem instanceof \StructType\Request_for_Quote_Line_Splits_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem) ? get_class($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem), var_export($request_for_Quote_Line_DataTypeRequest_for_Quote_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Line_Split_Data property can only contain items of type \StructType\Request_for_Quote_Line_Splits_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_Splits_DataType[] $request_for_Quote_Line_Split_Data
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setRequest_for_Quote_Line_Split_Data(array $request_for_Quote_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Line_Split_DataArrayErrorMessage = self::validateRequest_for_Quote_Line_Split_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Split_Data($request_for_Quote_Line_Split_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Line_Split_Data = $request_for_Quote_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_Splits_DataType $item
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function addToRequest_for_Quote_Line_Split_Data(\StructType\Request_for_Quote_Line_Splits_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Line_Splits_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Line_Split_Data property can only contain items of type \StructType\Request_for_Quote_Line_Splits_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Line_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Line_Attachment_Data()
    {
        return $this->Business_Document_Line_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Line_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Line_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) ? get_class($request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem), var_export($request_for_Quote_Line_DataTypeBusiness_Document_Line_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function setBusiness_Document_Line_Attachment_Data(array $business_Document_Line_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Line_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Line_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data = $business_Document_Line_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_Line_DataType
     */
    public function addToBusiness_Document_Line_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data[] = $item;
        return $this;
    }
}
