<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Schedule_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Purchase Order Schedule Response Data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Purchase_Order_Schedule_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Schedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_ScheduleType[]
     */
    public $Purchase_Order_Schedule;
    /**
     * Constructor method for Purchase_Order_Schedule_Response_DataType
     * @uses Purchase_Order_Schedule_Response_DataType::setPurchase_Order_Schedule()
     * @param \StructType\Purchase_Order_ScheduleType[] $purchase_Order_Schedule
     */
    public function __construct(array $purchase_Order_Schedule = array())
    {
        $this
            ->setPurchase_Order_Schedule($purchase_Order_Schedule);
    }
    /**
     * Get Purchase_Order_Schedule value
     * @return \StructType\Purchase_Order_ScheduleType[]|null
     */
    public function getPurchase_Order_Schedule()
    {
        return $this->Purchase_Order_Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Schedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Schedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_ScheduleForArrayConstraintsFromSetPurchase_Order_Schedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem instanceof \StructType\Purchase_Order_ScheduleType) {
                $invalidValues[] = is_object($purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem) ? get_class($purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem) : sprintf('%s(%s)', gettype($purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem), var_export($purchase_Order_Schedule_Response_DataTypePurchase_Order_ScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Schedule property can only contain items of type \StructType\Purchase_Order_ScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_ScheduleType[] $purchase_Order_Schedule
     * @return \StructType\Purchase_Order_Schedule_Response_DataType
     */
    public function setPurchase_Order_Schedule(array $purchase_Order_Schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_ScheduleArrayErrorMessage = self::validatePurchase_Order_ScheduleForArrayConstraintsFromSetPurchase_Order_Schedule($purchase_Order_Schedule))) {
            throw new \InvalidArgumentException($purchase_Order_ScheduleArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Schedule = $purchase_Order_Schedule;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_ScheduleType $item
     * @return \StructType\Purchase_Order_Schedule_Response_DataType
     */
    public function addToPurchase_Order_Schedule(\StructType\Purchase_Order_ScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_ScheduleType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Schedule property can only contain items of type \StructType\Purchase_Order_ScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Schedule[] = $item;
        return $this;
    }
}
