<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line_Alternate_Item_Attribute_Value_Data_OutboundType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents Alternate Item Identifiers for a Line
 * @subpackage Structs
 */
class Line_Alternate_Item_Attribute_Value_Data_OutboundType extends AbstractStructBase
{
    /**
     * The External_Name
     * Meta information extracted from the WSDL
     * - documentation: External Name of Alternate Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Name;
    /**
     * The Alternate_Identifier_Value
     * Meta information extracted from the WSDL
     * - documentation: Alternate Identifier Value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alternate_Identifier_Value;
    /**
     * The Manufacturer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Manufacturer associated with the Item Identifier Type
     * - minOccurs: 0
     * @var \StructType\ManufacturerObjectType
     */
    public $Manufacturer_Reference;
    /**
     * Constructor method for Line_Alternate_Item_Attribute_Value_Data_OutboundType
     * @uses Line_Alternate_Item_Attribute_Value_Data_OutboundType::setExternal_Name()
     * @uses Line_Alternate_Item_Attribute_Value_Data_OutboundType::setAlternate_Identifier_Value()
     * @uses Line_Alternate_Item_Attribute_Value_Data_OutboundType::setManufacturer_Reference()
     * @param string $external_Name
     * @param string $alternate_Identifier_Value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     */
    public function __construct($external_Name = null, $alternate_Identifier_Value = null, \StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this
            ->setExternal_Name($external_Name)
            ->setAlternate_Identifier_Value($alternate_Identifier_Value)
            ->setManufacturer_Reference($manufacturer_Reference);
    }
    /**
     * Get External_Name value
     * @return string|null
     */
    public function getExternal_Name()
    {
        return $this->External_Name;
    }
    /**
     * Set External_Name value
     * @param string $external_Name
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType
     */
    public function setExternal_Name($external_Name = null)
    {
        // validation for constraint: string
        if (!is_null($external_Name) && !is_string($external_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Name, true), gettype($external_Name)), __LINE__);
        }
        $this->External_Name = $external_Name;
        return $this;
    }
    /**
     * Get Alternate_Identifier_Value value
     * @return string|null
     */
    public function getAlternate_Identifier_Value()
    {
        return $this->Alternate_Identifier_Value;
    }
    /**
     * Set Alternate_Identifier_Value value
     * @param string $alternate_Identifier_Value
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType
     */
    public function setAlternate_Identifier_Value($alternate_Identifier_Value = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Identifier_Value) && !is_string($alternate_Identifier_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Identifier_Value, true), gettype($alternate_Identifier_Value)), __LINE__);
        }
        $this->Alternate_Identifier_Value = $alternate_Identifier_Value;
        return $this;
    }
    /**
     * Get Manufacturer_Reference value
     * @return \StructType\ManufacturerObjectType|null
     */
    public function getManufacturer_Reference()
    {
        return $this->Manufacturer_Reference;
    }
    /**
     * Set Manufacturer_Reference value
     * @param \StructType\ManufacturerObjectType $manufacturer_Reference
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_OutboundType
     */
    public function setManufacturer_Reference(\StructType\ManufacturerObjectType $manufacturer_Reference = null)
    {
        $this->Manufacturer_Reference = $manufacturer_Reference;
        return $this;
    }
}
