<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Guest data.
 * @subpackage Structs
 */
class Guest__HV__DataType extends AbstractStructBase
{
    /**
     * The Guest_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Guest for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Guest_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Payee reference for Guest.
     * - maxOccurs: unbounded
     * @var \StructType\Expense_PayeeObjectType[]
     */
    public $Expense_Payee_Reference;
    /**
     * The Guest_Name
     * Meta information extracted from the WSDL
     * - documentation: Guest Name
     * - maxOccurs: 1
     * @var string
     */
    public $Guest_Name;
    /**
     * The Guest_Company
     * Meta information extracted from the WSDL
     * - documentation: Guest Company
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Company;
    /**
     * The Guest_Title
     * Meta information extracted from the WSDL
     * - documentation: Guest Title
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Title;
    /**
     * Constructor method for Guest__HV__DataType
     * @uses Guest__HV__DataType::setGuest_Reference()
     * @uses Guest__HV__DataType::setExpense_Payee_Reference()
     * @uses Guest__HV__DataType::setGuest_Name()
     * @uses Guest__HV__DataType::setGuest_Company()
     * @uses Guest__HV__DataType::setGuest_Title()
     * @param \StructType\Unique_IdentifierObjectType $guest_Reference
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @param string $guest_Name
     * @param string $guest_Company
     * @param string $guest_Title
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $guest_Reference = null, array $expense_Payee_Reference = array(), $guest_Name = null, $guest_Company = null, $guest_Title = null)
    {
        $this
            ->setGuest_Reference($guest_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setGuest_Name($guest_Name)
            ->setGuest_Company($guest_Company)
            ->setGuest_Title($guest_Title);
    }
    /**
     * Get Guest_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getGuest_Reference()
    {
        return $this->Guest_Reference;
    }
    /**
     * Set Guest_Reference value
     * @param \StructType\Unique_IdentifierObjectType $guest_Reference
     * @return \StructType\Guest__HV__DataType
     */
    public function setGuest_Reference(\StructType\Unique_IdentifierObjectType $guest_Reference = null)
    {
        $this->Guest_Reference = $guest_Reference;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType[]|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_HV_DataTypeExpense_Payee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$guest_HV_DataTypeExpense_Payee_ReferenceItem instanceof \StructType\Expense_PayeeObjectType) {
                $invalidValues[] = is_object($guest_HV_DataTypeExpense_Payee_ReferenceItem) ? get_class($guest_HV_DataTypeExpense_Payee_ReferenceItem) : sprintf('%s(%s)', gettype($guest_HV_DataTypeExpense_Payee_ReferenceItem), var_export($guest_HV_DataTypeExpense_Payee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @return \StructType\Guest__HV__DataType
     */
    public function setExpense_Payee_Reference(array $expense_Payee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_ReferenceArrayErrorMessage = self::validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference($expense_Payee_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $item
     * @return \StructType\Guest__HV__DataType
     */
    public function addToExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_PayeeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Guest_Name value
     * @return string|null
     */
    public function getGuest_Name()
    {
        return $this->Guest_Name;
    }
    /**
     * Set Guest_Name value
     * @param string $guest_Name
     * @return \StructType\Guest__HV__DataType
     */
    public function setGuest_Name($guest_Name = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Name) && !is_string($guest_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Name, true), gettype($guest_Name)), __LINE__);
        }
        $this->Guest_Name = $guest_Name;
        return $this;
    }
    /**
     * Get Guest_Company value
     * @return string|null
     */
    public function getGuest_Company()
    {
        return $this->Guest_Company;
    }
    /**
     * Set Guest_Company value
     * @param string $guest_Company
     * @return \StructType\Guest__HV__DataType
     */
    public function setGuest_Company($guest_Company = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Company) && !is_string($guest_Company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Company, true), gettype($guest_Company)), __LINE__);
        }
        $this->Guest_Company = $guest_Company;
        return $this;
    }
    /**
     * Get Guest_Title value
     * @return string|null
     */
    public function getGuest_Title()
    {
        return $this->Guest_Title;
    }
    /**
     * Set Guest_Title value
     * @param string $guest_Title
     * @return \StructType\Guest__HV__DataType
     */
    public function setGuest_Title($guest_Title = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Title) && !is_string($guest_Title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Title, true), gettype($guest_Title)), __LINE__);
        }
        $this->Guest_Title = $guest_Title;
        return $this;
    }
}
