<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Entity_Contact_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: If Default Bill To Contact option is selected, there must be at least one Customer Invoice email address related to the contact. | Element containing Business Entity Contact reference for update and all Business Entity Contact data
 * items
 * @subpackage Structs
 */
class Business_Entity_Contact_DataType extends AbstractStructBase
{
    /**
     * The Primary_Bill_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Primary Bill To Contact to choose one contact to be as primary.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Primary_Bill_To_Contact;
    /**
     * The Default_Bill_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Sets Contact as the default Bill-To Contact for the Billable Entity.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_Bill_To_Contact;
    /**
     * The Business_Entity_Contact_ID
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Contact ID. This is the Business Entity Contact unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Entity_Contact_ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier that the contact is for
     * - choice: Supplier_Reference | Billable_Entity_Reference | Financial_Institution_Reference | Tax_Authority_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Billable_Entity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Customer or Sponsor that the contact is for
     * - choice: Supplier_Reference | Billable_Entity_Reference | Financial_Institution_Reference | Tax_Authority_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Billable_EntityObjectType
     */
    public $Billable_Entity_Reference;
    /**
     * The Financial_Institution_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Financial Institution that the contact is for
     * - choice: Supplier_Reference | Billable_Entity_Reference | Financial_Institution_Reference | Tax_Authority_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Financial_InstitutionObjectType
     */
    public $Financial_Institution_Reference;
    /**
     * The Tax_Authority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Authority that the contact is for
     * - choice: Supplier_Reference | Billable_Entity_Reference | Financial_Institution_Reference | Tax_Authority_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Tax_AuthorityObjectType
     */
    public $Tax_Authority_Reference;
    /**
     * The Business_Entity_Contact_Personal_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Contact Personal Data
     * @var \StructType\Business_Entity_Contact_Personal_DataType
     */
    public $Business_Entity_Contact_Personal_Data;
    /**
     * The Business_Entity_Contact_Type_Tenanted_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Contact_Type_Tenanted_DataType[]
     */
    public $Business_Entity_Contact_Type_Tenanted_Data;
    /**
     * The External_ID_Data
     * Meta information extracted from the WSDL
     * - documentation: External ID Data
     * - minOccurs: 0
     * @var \StructType\External_Integration_ID_DataType
     */
    public $External_ID_Data;
    /**
     * Constructor method for Business_Entity_Contact_DataType
     * @uses Business_Entity_Contact_DataType::setPrimary_Bill_To_Contact()
     * @uses Business_Entity_Contact_DataType::setDefault_Bill_To_Contact()
     * @uses Business_Entity_Contact_DataType::setBusiness_Entity_Contact_ID()
     * @uses Business_Entity_Contact_DataType::setSupplier_Reference()
     * @uses Business_Entity_Contact_DataType::setBillable_Entity_Reference()
     * @uses Business_Entity_Contact_DataType::setFinancial_Institution_Reference()
     * @uses Business_Entity_Contact_DataType::setTax_Authority_Reference()
     * @uses Business_Entity_Contact_DataType::setBusiness_Entity_Contact_Personal_Data()
     * @uses Business_Entity_Contact_DataType::setBusiness_Entity_Contact_Type_Tenanted_Data()
     * @uses Business_Entity_Contact_DataType::setExternal_ID_Data()
     * @param bool $primary_Bill_To_Contact
     * @param bool $default_Bill_To_Contact
     * @param string $business_Entity_Contact_ID
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Billable_EntityObjectType $billable_Entity_Reference
     * @param \StructType\Financial_InstitutionObjectType $financial_Institution_Reference
     * @param \StructType\Tax_AuthorityObjectType $tax_Authority_Reference
     * @param \StructType\Business_Entity_Contact_Personal_DataType $business_Entity_Contact_Personal_Data
     * @param \StructType\Business_Entity_Contact_Type_Tenanted_DataType[] $business_Entity_Contact_Type_Tenanted_Data
     * @param \StructType\External_Integration_ID_DataType $external_ID_Data
     */
    public function __construct($primary_Bill_To_Contact = null, $default_Bill_To_Contact = null, $business_Entity_Contact_ID = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Billable_EntityObjectType $billable_Entity_Reference = null, \StructType\Financial_InstitutionObjectType $financial_Institution_Reference = null, \StructType\Tax_AuthorityObjectType $tax_Authority_Reference = null, \StructType\Business_Entity_Contact_Personal_DataType $business_Entity_Contact_Personal_Data = null, array $business_Entity_Contact_Type_Tenanted_Data = array(), \StructType\External_Integration_ID_DataType $external_ID_Data = null)
    {
        $this
            ->setPrimary_Bill_To_Contact($primary_Bill_To_Contact)
            ->setDefault_Bill_To_Contact($default_Bill_To_Contact)
            ->setBusiness_Entity_Contact_ID($business_Entity_Contact_ID)
            ->setSupplier_Reference($supplier_Reference)
            ->setBillable_Entity_Reference($billable_Entity_Reference)
            ->setFinancial_Institution_Reference($financial_Institution_Reference)
            ->setTax_Authority_Reference($tax_Authority_Reference)
            ->setBusiness_Entity_Contact_Personal_Data($business_Entity_Contact_Personal_Data)
            ->setBusiness_Entity_Contact_Type_Tenanted_Data($business_Entity_Contact_Type_Tenanted_Data)
            ->setExternal_ID_Data($external_ID_Data);
    }
    /**
     * Get Primary_Bill_To_Contact value
     * @return bool|null
     */
    public function getPrimary_Bill_To_Contact()
    {
        return $this->Primary_Bill_To_Contact;
    }
    /**
     * Set Primary_Bill_To_Contact value
     * @param bool $primary_Bill_To_Contact
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setPrimary_Bill_To_Contact($primary_Bill_To_Contact = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary_Bill_To_Contact) && !is_bool($primary_Bill_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary_Bill_To_Contact, true), gettype($primary_Bill_To_Contact)), __LINE__);
        }
        $this->Primary_Bill_To_Contact = $primary_Bill_To_Contact;
        return $this;
    }
    /**
     * Get Default_Bill_To_Contact value
     * @return bool|null
     */
    public function getDefault_Bill_To_Contact()
    {
        return $this->Default_Bill_To_Contact;
    }
    /**
     * Set Default_Bill_To_Contact value
     * @param bool $default_Bill_To_Contact
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setDefault_Bill_To_Contact($default_Bill_To_Contact = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_Bill_To_Contact) && !is_bool($default_Bill_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_Bill_To_Contact, true), gettype($default_Bill_To_Contact)), __LINE__);
        }
        $this->Default_Bill_To_Contact = $default_Bill_To_Contact;
        return $this;
    }
    /**
     * Get Business_Entity_Contact_ID value
     * @return string|null
     */
    public function getBusiness_Entity_Contact_ID()
    {
        return $this->Business_Entity_Contact_ID;
    }
    /**
     * Set Business_Entity_Contact_ID value
     * @param string $business_Entity_Contact_ID
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setBusiness_Entity_Contact_ID($business_Entity_Contact_ID = null)
    {
        // validation for constraint: string
        if (!is_null($business_Entity_Contact_ID) && !is_string($business_Entity_Contact_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Entity_Contact_ID, true), gettype($business_Entity_Contact_ID)), __LINE__);
        }
        $this->Business_Entity_Contact_ID = $business_Entity_Contact_ID;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return isset($this->Supplier_Reference) ? $this->Supplier_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Billable_Entity_Reference',
            'Financial_Institution_Reference',
            'Tax_Authority_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Billable_Entity_Reference, Financial_Institution_Reference, Tax_Authority_Reference)
        if ('' !== ($supplier_ReferenceChoiceErrorMessage = self::validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Reference) || (is_array($supplier_Reference) && empty($supplier_Reference))) {
            unset($this->Supplier_Reference);
        } else {
            $this->Supplier_Reference = $supplier_Reference;
        }
        return $this;
    }
    /**
     * Get Billable_Entity_Reference value
     * @return \StructType\Billable_EntityObjectType|null
     */
    public function getBillable_Entity_Reference()
    {
        return isset($this->Billable_Entity_Reference) ? $this->Billable_Entity_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBillable_Entity_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillable_Entity_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBillable_Entity_ReferenceForChoiceConstraintsFromSetBillable_Entity_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Reference',
            'Financial_Institution_Reference',
            'Tax_Authority_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Billable_Entity_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Billable_Entity_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Billable_Entity_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Billable_EntityObjectType $billable_Entity_Reference
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setBillable_Entity_Reference(\StructType\Billable_EntityObjectType $billable_Entity_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Billable_Entity_Reference, Financial_Institution_Reference, Tax_Authority_Reference)
        if ('' !== ($billable_Entity_ReferenceChoiceErrorMessage = self::validateBillable_Entity_ReferenceForChoiceConstraintsFromSetBillable_Entity_Reference($billable_Entity_Reference))) {
            throw new \InvalidArgumentException($billable_Entity_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($billable_Entity_Reference) || (is_array($billable_Entity_Reference) && empty($billable_Entity_Reference))) {
            unset($this->Billable_Entity_Reference);
        } else {
            $this->Billable_Entity_Reference = $billable_Entity_Reference;
        }
        return $this;
    }
    /**
     * Get Financial_Institution_Reference value
     * @return \StructType\Financial_InstitutionObjectType|null
     */
    public function getFinancial_Institution_Reference()
    {
        return isset($this->Financial_Institution_Reference) ? $this->Financial_Institution_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFinancial_Institution_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancial_Institution_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFinancial_Institution_ReferenceForChoiceConstraintsFromSetFinancial_Institution_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Reference',
            'Billable_Entity_Reference',
            'Tax_Authority_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Financial_Institution_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Financial_Institution_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Financial_Institution_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Financial_InstitutionObjectType $financial_Institution_Reference
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setFinancial_Institution_Reference(\StructType\Financial_InstitutionObjectType $financial_Institution_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Billable_Entity_Reference, Financial_Institution_Reference, Tax_Authority_Reference)
        if ('' !== ($financial_Institution_ReferenceChoiceErrorMessage = self::validateFinancial_Institution_ReferenceForChoiceConstraintsFromSetFinancial_Institution_Reference($financial_Institution_Reference))) {
            throw new \InvalidArgumentException($financial_Institution_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($financial_Institution_Reference) || (is_array($financial_Institution_Reference) && empty($financial_Institution_Reference))) {
            unset($this->Financial_Institution_Reference);
        } else {
            $this->Financial_Institution_Reference = $financial_Institution_Reference;
        }
        return $this;
    }
    /**
     * Get Tax_Authority_Reference value
     * @return \StructType\Tax_AuthorityObjectType|null
     */
    public function getTax_Authority_Reference()
    {
        return isset($this->Tax_Authority_Reference) ? $this->Tax_Authority_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTax_Authority_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Authority_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTax_Authority_ReferenceForChoiceConstraintsFromSetTax_Authority_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Reference',
            'Billable_Entity_Reference',
            'Financial_Institution_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Tax_Authority_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Tax_Authority_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Tax_Authority_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_AuthorityObjectType $tax_Authority_Reference
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setTax_Authority_Reference(\StructType\Tax_AuthorityObjectType $tax_Authority_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Billable_Entity_Reference, Financial_Institution_Reference, Tax_Authority_Reference)
        if ('' !== ($tax_Authority_ReferenceChoiceErrorMessage = self::validateTax_Authority_ReferenceForChoiceConstraintsFromSetTax_Authority_Reference($tax_Authority_Reference))) {
            throw new \InvalidArgumentException($tax_Authority_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($tax_Authority_Reference) || (is_array($tax_Authority_Reference) && empty($tax_Authority_Reference))) {
            unset($this->Tax_Authority_Reference);
        } else {
            $this->Tax_Authority_Reference = $tax_Authority_Reference;
        }
        return $this;
    }
    /**
     * Get Business_Entity_Contact_Personal_Data value
     * @return \StructType\Business_Entity_Contact_Personal_DataType|null
     */
    public function getBusiness_Entity_Contact_Personal_Data()
    {
        return $this->Business_Entity_Contact_Personal_Data;
    }
    /**
     * Set Business_Entity_Contact_Personal_Data value
     * @param \StructType\Business_Entity_Contact_Personal_DataType $business_Entity_Contact_Personal_Data
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setBusiness_Entity_Contact_Personal_Data(\StructType\Business_Entity_Contact_Personal_DataType $business_Entity_Contact_Personal_Data = null)
    {
        $this->Business_Entity_Contact_Personal_Data = $business_Entity_Contact_Personal_Data;
        return $this;
    }
    /**
     * Get Business_Entity_Contact_Type_Tenanted_Data value
     * @return \StructType\Business_Entity_Contact_Type_Tenanted_DataType[]|null
     */
    public function getBusiness_Entity_Contact_Type_Tenanted_Data()
    {
        return $this->Business_Entity_Contact_Type_Tenanted_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Entity_Contact_Type_Tenanted_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Entity_Contact_Type_Tenanted_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Entity_Contact_Type_Tenanted_DataForArrayConstraintsFromSetBusiness_Entity_Contact_Type_Tenanted_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem) {
            // validation for constraint: itemType
            if (!$business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem instanceof \StructType\Business_Entity_Contact_Type_Tenanted_DataType) {
                $invalidValues[] = is_object($business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem) ? get_class($business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem) : sprintf('%s(%s)', gettype($business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem), var_export($business_Entity_Contact_DataTypeBusiness_Entity_Contact_Type_Tenanted_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Entity_Contact_Type_Tenanted_Data property can only contain items of type \StructType\Business_Entity_Contact_Type_Tenanted_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Entity_Contact_Type_Tenanted_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Contact_Type_Tenanted_DataType[] $business_Entity_Contact_Type_Tenanted_Data
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setBusiness_Entity_Contact_Type_Tenanted_Data(array $business_Entity_Contact_Type_Tenanted_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Entity_Contact_Type_Tenanted_DataArrayErrorMessage = self::validateBusiness_Entity_Contact_Type_Tenanted_DataForArrayConstraintsFromSetBusiness_Entity_Contact_Type_Tenanted_Data($business_Entity_Contact_Type_Tenanted_Data))) {
            throw new \InvalidArgumentException($business_Entity_Contact_Type_Tenanted_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Entity_Contact_Type_Tenanted_Data = $business_Entity_Contact_Type_Tenanted_Data;
        return $this;
    }
    /**
     * Add item to Business_Entity_Contact_Type_Tenanted_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Contact_Type_Tenanted_DataType $item
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function addToBusiness_Entity_Contact_Type_Tenanted_Data(\StructType\Business_Entity_Contact_Type_Tenanted_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Entity_Contact_Type_Tenanted_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Entity_Contact_Type_Tenanted_Data property can only contain items of type \StructType\Business_Entity_Contact_Type_Tenanted_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Entity_Contact_Type_Tenanted_Data[] = $item;
        return $this;
    }
    /**
     * Get External_ID_Data value
     * @return \StructType\External_Integration_ID_DataType|null
     */
    public function getExternal_ID_Data()
    {
        return $this->External_ID_Data;
    }
    /**
     * Set External_ID_Data value
     * @param \StructType\External_Integration_ID_DataType $external_ID_Data
     * @return \StructType\Business_Entity_Contact_DataType
     */
    public function setExternal_ID_Data(\StructType\External_Integration_ID_DataType $external_ID_Data = null)
    {
        $this->External_ID_Data = $external_ID_Data;
        return $this;
    }
}
