<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Change_Order_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't create service lines for External Warehouse type purchase orders. | Enter the original External Reference Number on the purchase order. You can't change the External Reference Number value. | You can't specify a third party
 * tax code in the transaction tax code reference. | Element containing Purchase Order Change Order Data and the Lines to be Changed
 * @subpackage Structs
 */
class Purchase_Order_Change_Order_WWS_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order to be changed
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Change_Order_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Change Order ID. This is the Purchase Order Change Order unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Change_Order_Reference_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft. If Purchase Order
     * Issue Option is External, the Purchase Change Order will automatically be submitted and marked as Issued.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Change_Order_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to a Change Order Reason code that describes the change performed by the change order.
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Change_Order_Reason_Reference;
    /**
     * The Change_Order_Reason_Comments
     * Meta information extracted from the WSDL
     * - documentation: Comments that describe the change performed by the change order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Change_Order_Reason_Comments;
    /**
     * The Purchase_Order_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing tenanted Purchase Order Type in the system.
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType
     */
    public $Purchase_Order_Type_Reference;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Reference to an External Purchase Order Number.
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Acknowledgement_Expected
     * Meta information extracted from the WSDL
     * - documentation: True if this Purchase Order is expecting a POA
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Acknowledgement_Expected;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Other_Charges
     * Meta information extracted from the WSDL
     * - documentation: If there are Other Charges, then there must be at least one line with a Spend Category that has Allocate Other Charges. | An optional addition of Other Charges for the Requisition. | Other Charges
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Other_Charges;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for the Payment Terms associated with the Purchase Order. The Payment Terms will be defaulted if one is specified for the Supplier specified on the Purchase Order.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Override Payment Type acceptable for the Supplier referenced on the Purchase Order. If provided, it must be a valid payment type for the Supplier.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: The anticipated date by which the Purchase Order should be fulfilled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms Request Reference
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Method Request Reference
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Shipping_Instruction
     * Meta information extracted from the WSDL
     * - documentation: Shipping Instruction Data on Purchase Order Change Order
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Instruction;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_BaseObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Order_From_Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Order-from Connection tied to an existing Supplier supplying the goods.
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Order_From_Supplier_Connection_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Read only field. This is the currency reference on the purchase order.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Default_Tax_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Option.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Default_Tax_Option_Reference;
    /**
     * The Default_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Tax Code for the Purchase Order
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Tax_Code_Reference;
    /**
     * The Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Issue Option. If Purchase Order Issue Option is External, the Purchase Order Change Order will automatically be submitted and marked as Issued.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Issue_Option_Reference;
    /**
     * The Purchase_Order_Issue_Email_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Default PO Issue Email Replacement Data allows the user to change the Supplier PO Issue Email on the Purchase Order Change Order. If the element is omitted, no changes are made. If the element is supplied then the Supplier PO Issue
     * Emails are updated with the emails specified in this element's subelements. If none are specified, the Supplier PO Issue Email is cleared.
     * - minOccurs: 0
     * @var \StructType\Default_PO_Issue_Email_Replacement_DataType
     */
    public $Purchase_Order_Issue_Email_Replacement_Data;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the named buyer for the purchase order.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Bill_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Name of the Bill-To Contact for the Purchase Order.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Bill_To_Contact_Reference;
    /**
     * The Bill_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Name of the Bill-To Contact.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_To_Contact_Detail;
    /**
     * The Bill_To_Address_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Bill_To_Address_ReferenceType
     */
    public $Bill_To_Address_Data;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Name of the Ship-To Contact for the Purchase Order.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Ship_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Name of the Ship-To Contact.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Contact_Detail;
    /**
     * The Ship_To_Address_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Ship_To_Address_ReferenceType
     */
    public $Ship_To_Address_Data;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Document Link for Purchase Order Change Order
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Free form text describing the purpose of the Purchase Order
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Internal_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for internal notes that cannot be viewed by the supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Memo;
    /**
     * The Percent_To_Retain
     * Meta information extracted from the WSDL
     * - documentation: Percent to Retain for Purchase Order.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Percent_To_Retain;
    /**
     * The Estimated_Retention_Release_Date
     * Meta information extracted from the WSDL
     * - documentation: Estimated Retention Release Date for Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Estimated_Retention_Release_Date;
    /**
     * The Third_Party_Retention
     * Meta information extracted from the WSDL
     * - documentation: 3rd Party Retention for Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Third_Party_Retention;
    /**
     * The Retention_Memo
     * Meta information extracted from the WSDL
     * - documentation: Retention Memo for Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Retention_Memo;
    /**
     * The Prepayment_Release_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Prepaid Amortization Type
     * - minOccurs: 0
     * @var \StructType\Prepaid_Amortization_TypeObjectType
     */
    public $Prepayment_Release_Type_Reference;
    /**
     * The Expected_Release_Date
     * Meta information extracted from the WSDL
     * - documentation: The Expected Amortization Date is used when the Prepaid Amortization Type is set to "Manual"
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expected_Release_Date;
    /**
     * The Use_Prepaid_Posting_Rules_for_Receipt_Accruals
     * Meta information extracted from the WSDL
     * - documentation: Use Prepaid Accounting Posting Rules for Receipt Accruals option.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Prepaid_Posting_Rules_for_Receipt_Accruals;
    /**
     * The Procedure_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Procedure Information associated with the Bill Only Purchase Order.
     * - minOccurs: 0
     * @var \StructType\Procedure_Information_DataType
     */
    public $Procedure_Information_Data;
    /**
     * The Change_Order_Goods_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Change_Order_Item_Order_Line_WWS_DataType[]
     */
    public $Change_Order_Goods_Line_Data;
    /**
     * The Change_Order_Service_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Change_Order_Service_Order_Line_WWS_DataType[]
     */
    public $Change_Order_Service_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Purchase_Order_Change_Order_WWS_DataType
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPurchase_Order_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setChange_Order_Reference_ID()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setSubmit()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setChange_Order_Reason_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setChange_Order_Reason_Comments()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPurchase_Order_Type_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setExternal_PO_Number()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setDocument_Date()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setAcknowledgement_Expected()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setTax_Amount()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setFreight_Amount()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setOther_Charges()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPayment_Terms_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setOverride_Payment_Type_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setDue_Date()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShipping_Terms_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShipping_Method_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShipping_Instruction()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setSupplier_Contract_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setOrder_From_Supplier_Connection_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setCurrency_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setDefault_Tax_Option_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setDefault_Tax_Code_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setIssue_Option_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPurchase_Order_Issue_Email_Replacement_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setBuyer_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setBill_To_Contact_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setBill_To_Contact_Detail()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setBill_To_Address_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShip_To_Contact_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShip_To_Contact_Detail()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setShip_To_Address_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setDocument_Link()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setMemo()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setInternal_Memo()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPercent_To_Retain()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setEstimated_Retention_Release_Date()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setThird_Party_Retention()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setRetention_Memo()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setPrepayment_Release_Type_Reference()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setExpected_Release_Date()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setUse_Prepaid_Posting_Rules_for_Receipt_Accruals()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setProcedure_Information_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setChange_Order_Goods_Line_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setChange_Order_Service_Line_Data()
     * @uses Purchase_Order_Change_Order_WWS_DataType::setAttachment_Data()
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param string $change_Order_Reference_ID
     * @param bool $submit
     * @param \StructType\Reason_CodeObjectType $change_Order_Reason_Reference
     * @param string $change_Order_Reason_Comments
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @param string $external_PO_Number
     * @param string $document_Date
     * @param bool $acknowledgement_Expected
     * @param float $tax_Amount
     * @param float $freight_Amount
     * @param float $other_Charges
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param string $due_Date
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param string $shipping_Instruction
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Supplier_Connection_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @param \StructType\Default_PO_Issue_Email_Replacement_DataType $purchase_Order_Issue_Email_Replacement_Data
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param \StructType\WorkerObjectType $bill_To_Contact_Reference
     * @param string $bill_To_Contact_Detail
     * @param \StructType\Bill_To_Address_ReferenceType $bill_To_Address_Data
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param string $ship_To_Contact_Detail
     * @param \StructType\Ship_To_Address_ReferenceType $ship_To_Address_Data
     * @param string $document_Link
     * @param string $memo
     * @param string $internal_Memo
     * @param float $percent_To_Retain
     * @param string $estimated_Retention_Release_Date
     * @param bool $third_Party_Retention
     * @param string $retention_Memo
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @param string $expected_Release_Date
     * @param bool $use_Prepaid_Posting_Rules_for_Receipt_Accruals
     * @param \StructType\Procedure_Information_DataType $procedure_Information_Data
     * @param \StructType\Change_Order_Item_Order_Line_WWS_DataType[] $change_Order_Goods_Line_Data
     * @param \StructType\Change_Order_Service_Order_Line_WWS_DataType[] $change_Order_Service_Line_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $change_Order_Reference_ID = null, $submit = null, \StructType\Reason_CodeObjectType $change_Order_Reason_Reference = null, $change_Order_Reason_Comments = null, \StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null, $external_PO_Number = null, $document_Date = null, $acknowledgement_Expected = null, $tax_Amount = null, $freight_Amount = null, $other_Charges = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, $due_Date = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, $shipping_Instruction = null, \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null, \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Supplier_Connection_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null, \StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null, \StructType\Default_PO_Issue_Email_Replacement_DataType $purchase_Order_Issue_Email_Replacement_Data = null, \StructType\WorkerObjectType $buyer_Reference = null, \StructType\WorkerObjectType $bill_To_Contact_Reference = null, $bill_To_Contact_Detail = null, \StructType\Bill_To_Address_ReferenceType $bill_To_Address_Data = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, $ship_To_Contact_Detail = null, \StructType\Ship_To_Address_ReferenceType $ship_To_Address_Data = null, $document_Link = null, $memo = null, $internal_Memo = null, $percent_To_Retain = null, $estimated_Retention_Release_Date = null, $third_Party_Retention = null, $retention_Memo = null, \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null, $expected_Release_Date = null, $use_Prepaid_Posting_Rules_for_Receipt_Accruals = null, \StructType\Procedure_Information_DataType $procedure_Information_Data = null, array $change_Order_Goods_Line_Data = array(), array $change_Order_Service_Line_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setChange_Order_Reference_ID($change_Order_Reference_ID)
            ->setSubmit($submit)
            ->setChange_Order_Reason_Reference($change_Order_Reason_Reference)
            ->setChange_Order_Reason_Comments($change_Order_Reason_Comments)
            ->setPurchase_Order_Type_Reference($purchase_Order_Type_Reference)
            ->setExternal_PO_Number($external_PO_Number)
            ->setDocument_Date($document_Date)
            ->setAcknowledgement_Expected($acknowledgement_Expected)
            ->setTax_Amount($tax_Amount)
            ->setFreight_Amount($freight_Amount)
            ->setOther_Charges($other_Charges)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setDue_Date($due_Date)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setShipping_Instruction($shipping_Instruction)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setOrder_From_Supplier_Connection_Reference($order_From_Supplier_Connection_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setDefault_Tax_Option_Reference($default_Tax_Option_Reference)
            ->setDefault_Tax_Code_Reference($default_Tax_Code_Reference)
            ->setIssue_Option_Reference($issue_Option_Reference)
            ->setPurchase_Order_Issue_Email_Replacement_Data($purchase_Order_Issue_Email_Replacement_Data)
            ->setBuyer_Reference($buyer_Reference)
            ->setBill_To_Contact_Reference($bill_To_Contact_Reference)
            ->setBill_To_Contact_Detail($bill_To_Contact_Detail)
            ->setBill_To_Address_Data($bill_To_Address_Data)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setShip_To_Contact_Detail($ship_To_Contact_Detail)
            ->setShip_To_Address_Data($ship_To_Address_Data)
            ->setDocument_Link($document_Link)
            ->setMemo($memo)
            ->setInternal_Memo($internal_Memo)
            ->setPercent_To_Retain($percent_To_Retain)
            ->setEstimated_Retention_Release_Date($estimated_Retention_Release_Date)
            ->setThird_Party_Retention($third_Party_Retention)
            ->setRetention_Memo($retention_Memo)
            ->setPrepayment_Release_Type_Reference($prepayment_Release_Type_Reference)
            ->setExpected_Release_Date($expected_Release_Date)
            ->setUse_Prepaid_Posting_Rules_for_Receipt_Accruals($use_Prepaid_Posting_Rules_for_Receipt_Accruals)
            ->setProcedure_Information_Data($procedure_Information_Data)
            ->setChange_Order_Goods_Line_Data($change_Order_Goods_Line_Data)
            ->setChange_Order_Service_Line_Data($change_Order_Service_Line_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Reference_ID value
     * @return string|null
     */
    public function getChange_Order_Reference_ID()
    {
        return $this->Change_Order_Reference_ID;
    }
    /**
     * Set Change_Order_Reference_ID value
     * @param string $change_Order_Reference_ID
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setChange_Order_Reference_ID($change_Order_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($change_Order_Reference_ID) && !is_string($change_Order_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_Order_Reference_ID, true), gettype($change_Order_Reference_ID)), __LINE__);
        }
        $this->Change_Order_Reference_ID = $change_Order_Reference_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Change_Order_Reason_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getChange_Order_Reason_Reference()
    {
        return $this->Change_Order_Reason_Reference;
    }
    /**
     * Set Change_Order_Reason_Reference value
     * @param \StructType\Reason_CodeObjectType $change_Order_Reason_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setChange_Order_Reason_Reference(\StructType\Reason_CodeObjectType $change_Order_Reason_Reference = null)
    {
        $this->Change_Order_Reason_Reference = $change_Order_Reason_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Reason_Comments value
     * @return string|null
     */
    public function getChange_Order_Reason_Comments()
    {
        return $this->Change_Order_Reason_Comments;
    }
    /**
     * Set Change_Order_Reason_Comments value
     * @param string $change_Order_Reason_Comments
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setChange_Order_Reason_Comments($change_Order_Reason_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($change_Order_Reason_Comments) && !is_string($change_Order_Reason_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_Order_Reason_Comments, true), gettype($change_Order_Reason_Comments)), __LINE__);
        }
        $this->Change_Order_Reason_Comments = $change_Order_Reason_Comments;
        return $this;
    }
    /**
     * Get Purchase_Order_Type_Reference value
     * @return \StructType\Order_TypeObjectType|null
     */
    public function getPurchase_Order_Type_Reference()
    {
        return $this->Purchase_Order_Type_Reference;
    }
    /**
     * Set Purchase_Order_Type_Reference value
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPurchase_Order_Type_Reference(\StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null)
    {
        $this->Purchase_Order_Type_Reference = $purchase_Order_Type_Reference;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Acknowledgement_Expected value
     * @return bool|null
     */
    public function getAcknowledgement_Expected()
    {
        return $this->Acknowledgement_Expected;
    }
    /**
     * Set Acknowledgement_Expected value
     * @param bool $acknowledgement_Expected
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setAcknowledgement_Expected($acknowledgement_Expected = null)
    {
        // validation for constraint: boolean
        if (!is_null($acknowledgement_Expected) && !is_bool($acknowledgement_Expected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acknowledgement_Expected, true), gettype($acknowledgement_Expected)), __LINE__);
        }
        $this->Acknowledgement_Expected = $acknowledgement_Expected;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Other_Charges value
     * @return float|null
     */
    public function getOther_Charges()
    {
        return $this->Other_Charges;
    }
    /**
     * Set Other_Charges value
     * @param float $other_Charges
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setOther_Charges($other_Charges = null)
    {
        // validation for constraint: float
        if (!is_null($other_Charges) && !(is_float($other_Charges) || is_numeric($other_Charges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_Charges, true), gettype($other_Charges)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($other_Charges) && mb_strlen(mb_substr($other_Charges, false !== mb_strpos($other_Charges, '.') ? mb_strpos($other_Charges, '.') + 1 : mb_strlen($other_Charges))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($other_Charges, true), mb_strlen(mb_substr($other_Charges, mb_strpos($other_Charges, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($other_Charges) && mb_strlen(preg_replace('/(\D)/', '', $other_Charges)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($other_Charges, true), mb_strlen(preg_replace('/(\D)/', '', $other_Charges))), __LINE__);
        }
        $this->Other_Charges = $other_Charges;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Shipping_Instruction value
     * @return string|null
     */
    public function getShipping_Instruction()
    {
        return $this->Shipping_Instruction;
    }
    /**
     * Set Shipping_Instruction value
     * @param string $shipping_Instruction
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShipping_Instruction($shipping_Instruction = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Instruction) && !is_string($shipping_Instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Instruction, true), gettype($shipping_Instruction)), __LINE__);
        }
        $this->Shipping_Instruction = $shipping_Instruction;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_Contract_BaseObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Order_From_Supplier_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getOrder_From_Supplier_Connection_Reference()
    {
        return $this->Order_From_Supplier_Connection_Reference;
    }
    /**
     * Set Order_From_Supplier_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Supplier_Connection_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setOrder_From_Supplier_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $order_From_Supplier_Connection_Reference = null)
    {
        $this->Order_From_Supplier_Connection_Reference = $order_From_Supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Default_Tax_Option_Reference value
     * @return \StructType\Tax_OptionObjectType|null
     */
    public function getDefault_Tax_Option_Reference()
    {
        return $this->Default_Tax_Option_Reference;
    }
    /**
     * Set Default_Tax_Option_Reference value
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setDefault_Tax_Option_Reference(\StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null)
    {
        $this->Default_Tax_Option_Reference = $default_Tax_Option_Reference;
        return $this;
    }
    /**
     * Get Default_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Tax_Code_Reference()
    {
        return $this->Default_Tax_Code_Reference;
    }
    /**
     * Set Default_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Tax_Code_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setDefault_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Tax_Code_Reference = null)
    {
        $this->Default_Tax_Code_Reference = $default_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getIssue_Option_Reference()
    {
        return $this->Issue_Option_Reference;
    }
    /**
     * Set Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setIssue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null)
    {
        $this->Issue_Option_Reference = $issue_Option_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Email_Replacement_Data value
     * @return \StructType\Default_PO_Issue_Email_Replacement_DataType|null
     */
    public function getPurchase_Order_Issue_Email_Replacement_Data()
    {
        return $this->Purchase_Order_Issue_Email_Replacement_Data;
    }
    /**
     * Set Purchase_Order_Issue_Email_Replacement_Data value
     * @param \StructType\Default_PO_Issue_Email_Replacement_DataType $purchase_Order_Issue_Email_Replacement_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPurchase_Order_Issue_Email_Replacement_Data(\StructType\Default_PO_Issue_Email_Replacement_DataType $purchase_Order_Issue_Email_Replacement_Data = null)
    {
        $this->Purchase_Order_Issue_Email_Replacement_Data = $purchase_Order_Issue_Email_Replacement_Data;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBill_To_Contact_Reference()
    {
        return $this->Bill_To_Contact_Reference;
    }
    /**
     * Set Bill_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $bill_To_Contact_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setBill_To_Contact_Reference(\StructType\WorkerObjectType $bill_To_Contact_Reference = null)
    {
        $this->Bill_To_Contact_Reference = $bill_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Detail value
     * @return string|null
     */
    public function getBill_To_Contact_Detail()
    {
        return $this->Bill_To_Contact_Detail;
    }
    /**
     * Set Bill_To_Contact_Detail value
     * @param string $bill_To_Contact_Detail
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setBill_To_Contact_Detail($bill_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact_Detail) && !is_string($bill_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact_Detail, true), gettype($bill_To_Contact_Detail)), __LINE__);
        }
        $this->Bill_To_Contact_Detail = $bill_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Bill_To_Address_Data value
     * @return \StructType\Bill_To_Address_ReferenceType|null
     */
    public function getBill_To_Address_Data()
    {
        return $this->Bill_To_Address_Data;
    }
    /**
     * Set Bill_To_Address_Data value
     * @param \StructType\Bill_To_Address_ReferenceType $bill_To_Address_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setBill_To_Address_Data(\StructType\Bill_To_Address_ReferenceType $bill_To_Address_Data = null)
    {
        $this->Bill_To_Address_Data = $bill_To_Address_Data;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Detail value
     * @return string|null
     */
    public function getShip_To_Contact_Detail()
    {
        return $this->Ship_To_Contact_Detail;
    }
    /**
     * Set Ship_To_Contact_Detail value
     * @param string $ship_To_Contact_Detail
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShip_To_Contact_Detail($ship_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact_Detail) && !is_string($ship_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact_Detail, true), gettype($ship_To_Contact_Detail)), __LINE__);
        }
        $this->Ship_To_Contact_Detail = $ship_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Ship_To_Address_Data value
     * @return \StructType\Ship_To_Address_ReferenceType|null
     */
    public function getShip_To_Address_Data()
    {
        return $this->Ship_To_Address_Data;
    }
    /**
     * Set Ship_To_Address_Data value
     * @param \StructType\Ship_To_Address_ReferenceType $ship_To_Address_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setShip_To_Address_Data(\StructType\Ship_To_Address_ReferenceType $ship_To_Address_Data = null)
    {
        $this->Ship_To_Address_Data = $ship_To_Address_Data;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Internal_Memo value
     * @return string|null
     */
    public function getInternal_Memo()
    {
        return $this->Internal_Memo;
    }
    /**
     * Set Internal_Memo value
     * @param string $internal_Memo
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setInternal_Memo($internal_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Memo) && !is_string($internal_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Memo, true), gettype($internal_Memo)), __LINE__);
        }
        $this->Internal_Memo = $internal_Memo;
        return $this;
    }
    /**
     * Get Percent_To_Retain value
     * @return float|null
     */
    public function getPercent_To_Retain()
    {
        return $this->Percent_To_Retain;
    }
    /**
     * Set Percent_To_Retain value
     * @param float $percent_To_Retain
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPercent_To_Retain($percent_To_Retain = null)
    {
        // validation for constraint: float
        if (!is_null($percent_To_Retain) && !(is_float($percent_To_Retain) || is_numeric($percent_To_Retain))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_To_Retain, true), gettype($percent_To_Retain)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($percent_To_Retain) && mb_strlen(mb_substr($percent_To_Retain, false !== mb_strpos($percent_To_Retain, '.') ? mb_strpos($percent_To_Retain, '.') + 1 : mb_strlen($percent_To_Retain))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($percent_To_Retain, true), mb_strlen(mb_substr($percent_To_Retain, mb_strpos($percent_To_Retain, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_To_Retain) && $percent_To_Retain < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_To_Retain, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($percent_To_Retain) && mb_strlen(preg_replace('/(\D)/', '', $percent_To_Retain)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($percent_To_Retain, true), mb_strlen(preg_replace('/(\D)/', '', $percent_To_Retain))), __LINE__);
        }
        $this->Percent_To_Retain = $percent_To_Retain;
        return $this;
    }
    /**
     * Get Estimated_Retention_Release_Date value
     * @return string|null
     */
    public function getEstimated_Retention_Release_Date()
    {
        return $this->Estimated_Retention_Release_Date;
    }
    /**
     * Set Estimated_Retention_Release_Date value
     * @param string $estimated_Retention_Release_Date
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setEstimated_Retention_Release_Date($estimated_Retention_Release_Date = null)
    {
        // validation for constraint: string
        if (!is_null($estimated_Retention_Release_Date) && !is_string($estimated_Retention_Release_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimated_Retention_Release_Date, true), gettype($estimated_Retention_Release_Date)), __LINE__);
        }
        $this->Estimated_Retention_Release_Date = $estimated_Retention_Release_Date;
        return $this;
    }
    /**
     * Get Third_Party_Retention value
     * @return bool|null
     */
    public function getThird_Party_Retention()
    {
        return $this->Third_Party_Retention;
    }
    /**
     * Set Third_Party_Retention value
     * @param bool $third_Party_Retention
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setThird_Party_Retention($third_Party_Retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($third_Party_Retention) && !is_bool($third_Party_Retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($third_Party_Retention, true), gettype($third_Party_Retention)), __LINE__);
        }
        $this->Third_Party_Retention = $third_Party_Retention;
        return $this;
    }
    /**
     * Get Retention_Memo value
     * @return string|null
     */
    public function getRetention_Memo()
    {
        return $this->Retention_Memo;
    }
    /**
     * Set Retention_Memo value
     * @param string $retention_Memo
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setRetention_Memo($retention_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($retention_Memo) && !is_string($retention_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retention_Memo, true), gettype($retention_Memo)), __LINE__);
        }
        $this->Retention_Memo = $retention_Memo;
        return $this;
    }
    /**
     * Get Prepayment_Release_Type_Reference value
     * @return \StructType\Prepaid_Amortization_TypeObjectType|null
     */
    public function getPrepayment_Release_Type_Reference()
    {
        return $this->Prepayment_Release_Type_Reference;
    }
    /**
     * Set Prepayment_Release_Type_Reference value
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setPrepayment_Release_Type_Reference(\StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null)
    {
        $this->Prepayment_Release_Type_Reference = $prepayment_Release_Type_Reference;
        return $this;
    }
    /**
     * Get Expected_Release_Date value
     * @return string|null
     */
    public function getExpected_Release_Date()
    {
        return $this->Expected_Release_Date;
    }
    /**
     * Set Expected_Release_Date value
     * @param string $expected_Release_Date
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setExpected_Release_Date($expected_Release_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expected_Release_Date) && !is_string($expected_Release_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expected_Release_Date, true), gettype($expected_Release_Date)), __LINE__);
        }
        $this->Expected_Release_Date = $expected_Release_Date;
        return $this;
    }
    /**
     * Get Use_Prepaid_Posting_Rules_for_Receipt_Accruals value
     * @return bool|null
     */
    public function getUse_Prepaid_Posting_Rules_for_Receipt_Accruals()
    {
        return $this->Use_Prepaid_Posting_Rules_for_Receipt_Accruals;
    }
    /**
     * Set Use_Prepaid_Posting_Rules_for_Receipt_Accruals value
     * @param bool $use_Prepaid_Posting_Rules_for_Receipt_Accruals
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setUse_Prepaid_Posting_Rules_for_Receipt_Accruals($use_Prepaid_Posting_Rules_for_Receipt_Accruals = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Prepaid_Posting_Rules_for_Receipt_Accruals) && !is_bool($use_Prepaid_Posting_Rules_for_Receipt_Accruals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Prepaid_Posting_Rules_for_Receipt_Accruals, true), gettype($use_Prepaid_Posting_Rules_for_Receipt_Accruals)), __LINE__);
        }
        $this->Use_Prepaid_Posting_Rules_for_Receipt_Accruals = $use_Prepaid_Posting_Rules_for_Receipt_Accruals;
        return $this;
    }
    /**
     * Get Procedure_Information_Data value
     * @return \StructType\Procedure_Information_DataType|null
     */
    public function getProcedure_Information_Data()
    {
        return $this->Procedure_Information_Data;
    }
    /**
     * Set Procedure_Information_Data value
     * @param \StructType\Procedure_Information_DataType $procedure_Information_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setProcedure_Information_Data(\StructType\Procedure_Information_DataType $procedure_Information_Data = null)
    {
        $this->Procedure_Information_Data = $procedure_Information_Data;
        return $this;
    }
    /**
     * Get Change_Order_Goods_Line_Data value
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType[]|null
     */
    public function getChange_Order_Goods_Line_Data()
    {
        return $this->Change_Order_Goods_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setChange_Order_Goods_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChange_Order_Goods_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChange_Order_Goods_Line_DataForArrayConstraintsFromSetChange_Order_Goods_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem instanceof \StructType\Change_Order_Item_Order_Line_WWS_DataType) {
                $invalidValues[] = is_object($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem) ? get_class($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem), var_export($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Goods_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Change_Order_Goods_Line_Data property can only contain items of type \StructType\Change_Order_Item_Order_Line_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Change_Order_Goods_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Item_Order_Line_WWS_DataType[] $change_Order_Goods_Line_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setChange_Order_Goods_Line_Data(array $change_Order_Goods_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($change_Order_Goods_Line_DataArrayErrorMessage = self::validateChange_Order_Goods_Line_DataForArrayConstraintsFromSetChange_Order_Goods_Line_Data($change_Order_Goods_Line_Data))) {
            throw new \InvalidArgumentException($change_Order_Goods_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Change_Order_Goods_Line_Data = $change_Order_Goods_Line_Data;
        return $this;
    }
    /**
     * Add item to Change_Order_Goods_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Item_Order_Line_WWS_DataType $item
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function addToChange_Order_Goods_Line_Data(\StructType\Change_Order_Item_Order_Line_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Change_Order_Item_Order_Line_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Change_Order_Goods_Line_Data property can only contain items of type \StructType\Change_Order_Item_Order_Line_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Change_Order_Goods_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Change_Order_Service_Line_Data value
     * @return \StructType\Change_Order_Service_Order_Line_WWS_DataType[]|null
     */
    public function getChange_Order_Service_Line_Data()
    {
        return $this->Change_Order_Service_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setChange_Order_Service_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChange_Order_Service_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChange_Order_Service_Line_DataForArrayConstraintsFromSetChange_Order_Service_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem instanceof \StructType\Change_Order_Service_Order_Line_WWS_DataType) {
                $invalidValues[] = is_object($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem) ? get_class($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem), var_export($purchase_Order_Change_Order_WWS_DataTypeChange_Order_Service_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Change_Order_Service_Line_Data property can only contain items of type \StructType\Change_Order_Service_Order_Line_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Change_Order_Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Service_Order_Line_WWS_DataType[] $change_Order_Service_Line_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setChange_Order_Service_Line_Data(array $change_Order_Service_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($change_Order_Service_Line_DataArrayErrorMessage = self::validateChange_Order_Service_Line_DataForArrayConstraintsFromSetChange_Order_Service_Line_Data($change_Order_Service_Line_Data))) {
            throw new \InvalidArgumentException($change_Order_Service_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Change_Order_Service_Line_Data = $change_Order_Service_Line_Data;
        return $this;
    }
    /**
     * Add item to Change_Order_Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Service_Order_Line_WWS_DataType $item
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function addToChange_Order_Service_Line_Data(\StructType\Change_Order_Service_Order_Line_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Change_Order_Service_Order_Line_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Change_Order_Service_Line_Data property can only contain items of type \StructType\Change_Order_Service_Order_Line_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Change_Order_Service_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType) {
                $invalidValues[] = is_object($purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem) ? get_class($purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem), var_export($purchase_Order_Change_Order_WWS_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $item
     * @return \StructType\Purchase_Order_Change_Order_WWS_DataType
     */
    public function addToAttachment_Data(\StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
