<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Sheet_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Project Role Standard Cost Rate Sheet.
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Sheet_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Project_Standard_Cost_Rate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Standard Cost Rate Sheet Request
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Standard_Cost_Rate_SheetObjectType[]
     */
    public $Project_Standard_Cost_Rate_Reference;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Sheet_Request_ReferencesType
     * @uses Project_Standard_Cost_Rate_Sheet_Request_ReferencesType::setProject_Standard_Cost_Rate_Reference()
     * @param \StructType\Project_Standard_Cost_Rate_SheetObjectType[] $project_Standard_Cost_Rate_Reference
     */
    public function __construct(array $project_Standard_Cost_Rate_Reference = array())
    {
        $this
            ->setProject_Standard_Cost_Rate_Reference($project_Standard_Cost_Rate_Reference);
    }
    /**
     * Get Project_Standard_Cost_Rate_Reference value
     * @return \StructType\Project_Standard_Cost_Rate_SheetObjectType[]|null
     */
    public function getProject_Standard_Cost_Rate_Reference()
    {
        return $this->Project_Standard_Cost_Rate_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Standard_Cost_Rate_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Standard_Cost_Rate_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Standard_Cost_Rate_ReferenceForArrayConstraintsFromSetProject_Standard_Cost_Rate_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem instanceof \StructType\Project_Standard_Cost_Rate_SheetObjectType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem) ? get_class($project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem), var_export($project_Standard_Cost_Rate_Sheet_Request_ReferencesTypeProject_Standard_Cost_Rate_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Standard_Cost_Rate_Reference property can only contain items of type \StructType\Project_Standard_Cost_Rate_SheetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Standard_Cost_Rate_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_SheetObjectType[] $project_Standard_Cost_Rate_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Request_ReferencesType
     */
    public function setProject_Standard_Cost_Rate_Reference(array $project_Standard_Cost_Rate_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Standard_Cost_Rate_ReferenceArrayErrorMessage = self::validateProject_Standard_Cost_Rate_ReferenceForArrayConstraintsFromSetProject_Standard_Cost_Rate_Reference($project_Standard_Cost_Rate_Reference))) {
            throw new \InvalidArgumentException($project_Standard_Cost_Rate_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Reference = $project_Standard_Cost_Rate_Reference;
        return $this;
    }
    /**
     * Add item to Project_Standard_Cost_Rate_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_SheetObjectType $item
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Request_ReferencesType
     */
    public function addToProject_Standard_Cost_Rate_Reference(\StructType\Project_Standard_Cost_Rate_SheetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Standard_Cost_Rate_SheetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Standard_Cost_Rate_Reference property can only contain items of type \StructType\Project_Standard_Cost_Rate_SheetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Reference[] = $item;
        return $this;
    }
}
