<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Task_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains project plan task template information, such as project task name, ID, offset dates, milestone flag, etc.
 * @subpackage Structs
 */
class Project_Plan_Task_Template_DataType extends AbstractStructBase
{
    /**
     * The Task_ID
     * Meta information extracted from the WSDL
     * - documentation: Contains a unique identifier for an instance of project plan task.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Task_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: The order of project plan task on the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Task_Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing task name data.
     * - minOccurs: 0
     * @var \StructType\Project_Task_Name_DataType
     */
    public $Task_Name_Data;
    /**
     * The Project_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: The instance of a project task.
     * - minOccurs: 0
     * @var \StructType\Project_TaskObjectType
     */
    public $Project_Task_Reference;
    /**
     * The Project_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker group for the project plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Member_ResourceObjectType
     */
    public $Project_Profile_Reference;
    /**
     * The Start_Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: The start date offset for the project plan template. | The start date offset associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Start_Date_Offset;
    /**
     * The End_Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: The end date offset for the project plan template. | The end date offset associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $End_Date_Offset;
    /**
     * The Percent_Complete
     * Meta information extracted from the WSDL
     * - documentation: The percent complete for the project plan template. | The percent complete for the project template. | Decimal value for Proposed Percent Complete of the Project Task selected. This value can be set via the Timesheet under certain
     * condition and is then copied to the Project Task on Approval of the Timesheet. | The value for Percent Complete Proposed can only be set where the Task is not 100% already on the Project and that Task is directly assigned to the worker. | Proposed
     * Percent Complete Complete cannot be greater than 100%. Percent complete is in decimal format value can not be greater than 1.00. | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Complete;
    /**
     * The Non_Billable
     * Meta information extracted from the WSDL
     * - documentation: If true, the project is non-billable for the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Billable;
    /**
     * The Milestone
     * Meta information extracted from the WSDL
     * - documentation: If true, the project plan task is a milestone for the project template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Milestone;
    /**
     * The Closed
     * Meta information extracted from the WSDL
     * - documentation: If true, the project plan task is closed for time entry for the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Closed;
    /**
     * The Utilization
     * Meta information extracted from the WSDL
     * - documentation: For informational purposes only to indicate that this project plan task qualifies for utilization calculations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Utilization;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Additional information for the project plan task of this project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Project_Plan_Task_Template_DataType
     * @uses Project_Plan_Task_Template_DataType::setTask_ID()
     * @uses Project_Plan_Task_Template_DataType::setOrder()
     * @uses Project_Plan_Task_Template_DataType::setTask_Name_Data()
     * @uses Project_Plan_Task_Template_DataType::setProject_Task_Reference()
     * @uses Project_Plan_Task_Template_DataType::setProject_Profile_Reference()
     * @uses Project_Plan_Task_Template_DataType::setStart_Date_Offset()
     * @uses Project_Plan_Task_Template_DataType::setEnd_Date_Offset()
     * @uses Project_Plan_Task_Template_DataType::setPercent_Complete()
     * @uses Project_Plan_Task_Template_DataType::setNon_Billable()
     * @uses Project_Plan_Task_Template_DataType::setMilestone()
     * @uses Project_Plan_Task_Template_DataType::setClosed()
     * @uses Project_Plan_Task_Template_DataType::setUtilization()
     * @uses Project_Plan_Task_Template_DataType::setMemo()
     * @param string $task_ID
     * @param string $order
     * @param \StructType\Project_Task_Name_DataType $task_Name_Data
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @param \StructType\Project_Member_ResourceObjectType $project_Profile_Reference
     * @param float $start_Date_Offset
     * @param float $end_Date_Offset
     * @param float $percent_Complete
     * @param bool $non_Billable
     * @param bool $milestone
     * @param bool $closed
     * @param bool $utilization
     * @param string $memo
     */
    public function __construct($task_ID = null, $order = null, \StructType\Project_Task_Name_DataType $task_Name_Data = null, \StructType\Project_TaskObjectType $project_Task_Reference = null, \StructType\Project_Member_ResourceObjectType $project_Profile_Reference = null, $start_Date_Offset = null, $end_Date_Offset = null, $percent_Complete = null, $non_Billable = null, $milestone = null, $closed = null, $utilization = null, $memo = null)
    {
        $this
            ->setTask_ID($task_ID)
            ->setOrder($order)
            ->setTask_Name_Data($task_Name_Data)
            ->setProject_Task_Reference($project_Task_Reference)
            ->setProject_Profile_Reference($project_Profile_Reference)
            ->setStart_Date_Offset($start_Date_Offset)
            ->setEnd_Date_Offset($end_Date_Offset)
            ->setPercent_Complete($percent_Complete)
            ->setNon_Billable($non_Billable)
            ->setMilestone($milestone)
            ->setClosed($closed)
            ->setUtilization($utilization)
            ->setMemo($memo);
    }
    /**
     * Get Task_ID value
     * @return string|null
     */
    public function getTask_ID()
    {
        return $this->Task_ID;
    }
    /**
     * Set Task_ID value
     * @param string $task_ID
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setTask_ID($task_ID = null)
    {
        // validation for constraint: string
        if (!is_null($task_ID) && !is_string($task_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($task_ID, true), gettype($task_ID)), __LINE__);
        }
        $this->Task_ID = $task_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Task_Name_Data value
     * @return \StructType\Project_Task_Name_DataType|null
     */
    public function getTask_Name_Data()
    {
        return $this->Task_Name_Data;
    }
    /**
     * Set Task_Name_Data value
     * @param \StructType\Project_Task_Name_DataType $task_Name_Data
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setTask_Name_Data(\StructType\Project_Task_Name_DataType $task_Name_Data = null)
    {
        $this->Task_Name_Data = $task_Name_Data;
        return $this;
    }
    /**
     * Get Project_Task_Reference value
     * @return \StructType\Project_TaskObjectType|null
     */
    public function getProject_Task_Reference()
    {
        return $this->Project_Task_Reference;
    }
    /**
     * Set Project_Task_Reference value
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setProject_Task_Reference(\StructType\Project_TaskObjectType $project_Task_Reference = null)
    {
        $this->Project_Task_Reference = $project_Task_Reference;
        return $this;
    }
    /**
     * Get Project_Profile_Reference value
     * @return \StructType\Project_Member_ResourceObjectType|null
     */
    public function getProject_Profile_Reference()
    {
        return $this->Project_Profile_Reference;
    }
    /**
     * Set Project_Profile_Reference value
     * @param \StructType\Project_Member_ResourceObjectType $project_Profile_Reference
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setProject_Profile_Reference(\StructType\Project_Member_ResourceObjectType $project_Profile_Reference = null)
    {
        $this->Project_Profile_Reference = $project_Profile_Reference;
        return $this;
    }
    /**
     * Get Start_Date_Offset value
     * @return float|null
     */
    public function getStart_Date_Offset()
    {
        return $this->Start_Date_Offset;
    }
    /**
     * Set Start_Date_Offset value
     * @param float $start_Date_Offset
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setStart_Date_Offset($start_Date_Offset = null)
    {
        // validation for constraint: float
        if (!is_null($start_Date_Offset) && !(is_float($start_Date_Offset) || is_numeric($start_Date_Offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($start_Date_Offset, true), gettype($start_Date_Offset)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($start_Date_Offset) && mb_strlen(mb_substr($start_Date_Offset, false !== mb_strpos($start_Date_Offset, '.') ? mb_strpos($start_Date_Offset, '.') + 1 : mb_strlen($start_Date_Offset))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($start_Date_Offset, true), mb_strlen(mb_substr($start_Date_Offset, mb_strpos($start_Date_Offset, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($start_Date_Offset) && $start_Date_Offset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($start_Date_Offset, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($start_Date_Offset) && mb_strlen(preg_replace('/(\D)/', '', $start_Date_Offset)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($start_Date_Offset, true), mb_strlen(preg_replace('/(\D)/', '', $start_Date_Offset))), __LINE__);
        }
        $this->Start_Date_Offset = $start_Date_Offset;
        return $this;
    }
    /**
     * Get End_Date_Offset value
     * @return float|null
     */
    public function getEnd_Date_Offset()
    {
        return $this->End_Date_Offset;
    }
    /**
     * Set End_Date_Offset value
     * @param float $end_Date_Offset
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setEnd_Date_Offset($end_Date_Offset = null)
    {
        // validation for constraint: float
        if (!is_null($end_Date_Offset) && !(is_float($end_Date_Offset) || is_numeric($end_Date_Offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($end_Date_Offset, true), gettype($end_Date_Offset)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($end_Date_Offset) && mb_strlen(mb_substr($end_Date_Offset, false !== mb_strpos($end_Date_Offset, '.') ? mb_strpos($end_Date_Offset, '.') + 1 : mb_strlen($end_Date_Offset))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($end_Date_Offset, true), mb_strlen(mb_substr($end_Date_Offset, mb_strpos($end_Date_Offset, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($end_Date_Offset) && $end_Date_Offset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($end_Date_Offset, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($end_Date_Offset) && mb_strlen(preg_replace('/(\D)/', '', $end_Date_Offset)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($end_Date_Offset, true), mb_strlen(preg_replace('/(\D)/', '', $end_Date_Offset))), __LINE__);
        }
        $this->End_Date_Offset = $end_Date_Offset;
        return $this;
    }
    /**
     * Get Percent_Complete value
     * @return float|null
     */
    public function getPercent_Complete()
    {
        return $this->Percent_Complete;
    }
    /**
     * Set Percent_Complete value
     * @param float $percent_Complete
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setPercent_Complete($percent_Complete = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Complete) && !(is_float($percent_Complete) || is_numeric($percent_Complete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Complete, true), gettype($percent_Complete)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Complete) && mb_strlen(mb_substr($percent_Complete, false !== mb_strpos($percent_Complete, '.') ? mb_strpos($percent_Complete, '.') + 1 : mb_strlen($percent_Complete))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Complete, true), mb_strlen(mb_substr($percent_Complete, mb_strpos($percent_Complete, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Complete) && $percent_Complete < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Complete, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Complete) && mb_strlen(preg_replace('/(\D)/', '', $percent_Complete)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Complete, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Complete))), __LINE__);
        }
        $this->Percent_Complete = $percent_Complete;
        return $this;
    }
    /**
     * Get Non_Billable value
     * @return bool|null
     */
    public function getNon_Billable()
    {
        return $this->{'Non-Billable'};
    }
    /**
     * Set Non_Billable value
     * @param bool $non_Billable
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setNon_Billable($non_Billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Billable) && !is_bool($non_Billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Billable, true), gettype($non_Billable)), __LINE__);
        }
        $this->Non_Billable = $this->{'Non-Billable'} = $non_Billable;
        return $this;
    }
    /**
     * Get Milestone value
     * @return bool|null
     */
    public function getMilestone()
    {
        return $this->Milestone;
    }
    /**
     * Set Milestone value
     * @param bool $milestone
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setMilestone($milestone = null)
    {
        // validation for constraint: boolean
        if (!is_null($milestone) && !is_bool($milestone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($milestone, true), gettype($milestone)), __LINE__);
        }
        $this->Milestone = $milestone;
        return $this;
    }
    /**
     * Get Closed value
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param bool $closed
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setClosed($closed = null)
    {
        // validation for constraint: boolean
        if (!is_null($closed) && !is_bool($closed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closed, true), gettype($closed)), __LINE__);
        }
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get Utilization value
     * @return bool|null
     */
    public function getUtilization()
    {
        return $this->Utilization;
    }
    /**
     * Set Utilization value
     * @param bool $utilization
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setUtilization($utilization = null)
    {
        // validation for constraint: boolean
        if (!is_null($utilization) && !is_bool($utilization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($utilization, true), gettype($utilization)), __LINE__);
        }
        $this->Utilization = $utilization;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Plan_Task_Template_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
