<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_CatalogType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element for Supplier Catalog Reference and Supplier Catalog Data.
 * @subpackage Structs
 */
class Supplier_CatalogType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Catalog.
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogObjectType
     */
    public $Supplier_Catalog_Reference;
    /**
     * The Supplier_Catalog_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Supplier Catalog data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Catalog_DataType[]
     */
    public $Supplier_Catalog_Data;
    /**
     * The Catalog_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_for_Supplier_Contract_DataType[]
     */
    public $Catalog_Item_Data;
    /**
     * Constructor method for Supplier_CatalogType
     * @uses Supplier_CatalogType::setSupplier_Catalog_Reference()
     * @uses Supplier_CatalogType::setSupplier_Catalog_Data()
     * @uses Supplier_CatalogType::setCatalog_Item_Data()
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @param \StructType\Supplier_Catalog_DataType[] $supplier_Catalog_Data
     * @param \StructType\Catalog_Item_for_Supplier_Contract_DataType[] $catalog_Item_Data
     */
    public function __construct(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null, array $supplier_Catalog_Data = array(), array $catalog_Item_Data = array())
    {
        $this
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference)
            ->setSupplier_Catalog_Data($supplier_Catalog_Data)
            ->setCatalog_Item_Data($catalog_Item_Data);
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Supplier_CatalogObjectType|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @return \StructType\Supplier_CatalogType
     */
    public function setSupplier_Catalog_Reference(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null)
    {
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Get Supplier_Catalog_Data value
     * @return \StructType\Supplier_Catalog_DataType[]|null
     */
    public function getSupplier_Catalog_Data()
    {
        return $this->Supplier_Catalog_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Catalog_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Catalog_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Catalog_DataForArrayConstraintsFromSetSupplier_Catalog_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_CatalogTypeSupplier_Catalog_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_CatalogTypeSupplier_Catalog_DataItem instanceof \StructType\Supplier_Catalog_DataType) {
                $invalidValues[] = is_object($supplier_CatalogTypeSupplier_Catalog_DataItem) ? get_class($supplier_CatalogTypeSupplier_Catalog_DataItem) : sprintf('%s(%s)', gettype($supplier_CatalogTypeSupplier_Catalog_DataItem), var_export($supplier_CatalogTypeSupplier_Catalog_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Catalog_Data property can only contain items of type \StructType\Supplier_Catalog_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Catalog_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Catalog_DataType[] $supplier_Catalog_Data
     * @return \StructType\Supplier_CatalogType
     */
    public function setSupplier_Catalog_Data(array $supplier_Catalog_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Catalog_DataArrayErrorMessage = self::validateSupplier_Catalog_DataForArrayConstraintsFromSetSupplier_Catalog_Data($supplier_Catalog_Data))) {
            throw new \InvalidArgumentException($supplier_Catalog_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Catalog_Data = $supplier_Catalog_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Catalog_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Catalog_DataType $item
     * @return \StructType\Supplier_CatalogType
     */
    public function addToSupplier_Catalog_Data(\StructType\Supplier_Catalog_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Catalog_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Catalog_Data property can only contain items of type \StructType\Supplier_Catalog_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Catalog_Data[] = $item;
        return $this;
    }
    /**
     * Get Catalog_Item_Data value
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType[]|null
     */
    public function getCatalog_Item_Data()
    {
        return $this->Catalog_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_CatalogTypeCatalog_Item_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_CatalogTypeCatalog_Item_DataItem instanceof \StructType\Catalog_Item_for_Supplier_Contract_DataType) {
                $invalidValues[] = is_object($supplier_CatalogTypeCatalog_Item_DataItem) ? get_class($supplier_CatalogTypeCatalog_Item_DataItem) : sprintf('%s(%s)', gettype($supplier_CatalogTypeCatalog_Item_DataItem), var_export($supplier_CatalogTypeCatalog_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_for_Supplier_Contract_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_for_Supplier_Contract_DataType[] $catalog_Item_Data
     * @return \StructType\Supplier_CatalogType
     */
    public function setCatalog_Item_Data(array $catalog_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Item_DataArrayErrorMessage = self::validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data($catalog_Item_Data))) {
            throw new \InvalidArgumentException($catalog_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Item_Data = $catalog_Item_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_for_Supplier_Contract_DataType $item
     * @return \StructType\Supplier_CatalogType
     */
    public function addToCatalog_Item_Data(\StructType\Catalog_Item_for_Supplier_Contract_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_for_Supplier_Contract_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_for_Supplier_Contract_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Item_Data[] = $item;
        return $this;
    }
}
