<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Line_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures RFQ Award Line Information - includes splits, worktags and attachments.
 * @subpackage Structs
 */
class Request_for_Quote_Award_Line_Data_InboundType extends AbstractStructBase
{
    /**
     * The RFQ_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ Line that will be awarded.
     * @var \StructType\Request_for_Quote_LineObjectType
     */
    public $RFQ_Line_Reference;
    /**
     * The Award_Line_Description
     * Meta information extracted from the WSDL
     * - documentation: Award Line Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Award_Line_Description;
    /**
     * The Award_Quantity
     * Meta information extracted from the WSDL
     * - documentation: RFQ Award Line Quantity | Award Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Award_Quantity;
    /**
     * The Award_Amount
     * Meta information extracted from the WSDL
     * - documentation: Extended Amount on RFQ Award Line | Award Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Award_Amount;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter a Requested Delivery Date that is on or after the RFQ Document Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Award Line Start Date. This is applicable only to Service Lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Award Line End Date. This is applicable only to Service Lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Ship-To Address associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Ship-To Contact associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Deliver-To Location associated with the RFQ Award Line.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Award Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Business_Document_Line_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Line_Attachment_Data;
    /**
     * The Request_for_Quote_Award_Line_Splits_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType[]
     */
    public $Request_for_Quote_Award_Line_Splits_Data;
    /**
     * Constructor method for Request_for_Quote_Award_Line_Data_InboundType
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setRFQ_Line_Reference()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setAward_Line_Description()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setAward_Quantity()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setAward_Amount()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setRequested_Delivery_Date()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setStart_Date()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setEnd_Date()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setShip_To_Address_Reference()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setShip_To_Contact_Reference()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setDeliver_To_Location_Reference()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setWorktags_Reference()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setMemo()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setBusiness_Document_Line_Attachment_Data()
     * @uses Request_for_Quote_Award_Line_Data_InboundType::setRequest_for_Quote_Award_Line_Splits_Data()
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @param string $award_Line_Description
     * @param float $award_Quantity
     * @param float $award_Amount
     * @param string $requested_Delivery_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $memo
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     * @param \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType[] $request_for_Quote_Award_Line_Splits_Data
     */
    public function __construct(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null, $award_Line_Description = null, $award_Quantity = null, $award_Amount = null, $requested_Delivery_Date = null, $start_Date = null, $end_Date = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, array $worktags_Reference = array(), $memo = null, array $business_Document_Line_Attachment_Data = array(), array $request_for_Quote_Award_Line_Splits_Data = array())
    {
        $this
            ->setRFQ_Line_Reference($rFQ_Line_Reference)
            ->setAward_Line_Description($award_Line_Description)
            ->setAward_Quantity($award_Quantity)
            ->setAward_Amount($award_Amount)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setMemo($memo)
            ->setBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data)
            ->setRequest_for_Quote_Award_Line_Splits_Data($request_for_Quote_Award_Line_Splits_Data);
    }
    /**
     * Get RFQ_Line_Reference value
     * @return \StructType\Request_for_Quote_LineObjectType|null
     */
    public function getRFQ_Line_Reference()
    {
        return $this->RFQ_Line_Reference;
    }
    /**
     * Set RFQ_Line_Reference value
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setRFQ_Line_Reference(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null)
    {
        $this->RFQ_Line_Reference = $rFQ_Line_Reference;
        return $this;
    }
    /**
     * Get Award_Line_Description value
     * @return string|null
     */
    public function getAward_Line_Description()
    {
        return $this->Award_Line_Description;
    }
    /**
     * Set Award_Line_Description value
     * @param string $award_Line_Description
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setAward_Line_Description($award_Line_Description = null)
    {
        // validation for constraint: string
        if (!is_null($award_Line_Description) && !is_string($award_Line_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($award_Line_Description, true), gettype($award_Line_Description)), __LINE__);
        }
        $this->Award_Line_Description = $award_Line_Description;
        return $this;
    }
    /**
     * Get Award_Quantity value
     * @return float|null
     */
    public function getAward_Quantity()
    {
        return $this->Award_Quantity;
    }
    /**
     * Set Award_Quantity value
     * @param float $award_Quantity
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setAward_Quantity($award_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($award_Quantity) && !(is_float($award_Quantity) || is_numeric($award_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($award_Quantity, true), gettype($award_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($award_Quantity) && mb_strlen(mb_substr($award_Quantity, false !== mb_strpos($award_Quantity, '.') ? mb_strpos($award_Quantity, '.') + 1 : mb_strlen($award_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($award_Quantity, true), mb_strlen(mb_substr($award_Quantity, mb_strpos($award_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($award_Quantity) && $award_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($award_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($award_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $award_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($award_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $award_Quantity))), __LINE__);
        }
        $this->Award_Quantity = $award_Quantity;
        return $this;
    }
    /**
     * Get Award_Amount value
     * @return float|null
     */
    public function getAward_Amount()
    {
        return $this->Award_Amount;
    }
    /**
     * Set Award_Amount value
     * @param float $award_Amount
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setAward_Amount($award_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($award_Amount) && !(is_float($award_Amount) || is_numeric($award_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($award_Amount, true), gettype($award_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($award_Amount) && mb_strlen(mb_substr($award_Amount, false !== mb_strpos($award_Amount, '.') ? mb_strpos($award_Amount, '.') + 1 : mb_strlen($award_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($award_Amount, true), mb_strlen(mb_substr($award_Amount, mb_strpos($award_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($award_Amount) && mb_strlen(preg_replace('/(\D)/', '', $award_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($award_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $award_Amount))), __LINE__);
        }
        $this->Award_Amount = $award_Amount;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem) ? get_class($request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem), var_export($request_for_Quote_Award_Line_Data_InboundTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Business_Document_Line_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Line_Attachment_Data()
    {
        return $this->Business_Document_Line_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Line_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Line_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem) ? get_class($request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem), var_export($request_for_Quote_Award_Line_Data_InboundTypeBusiness_Document_Line_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Line_Attachment_Data
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setBusiness_Document_Line_Attachment_Data(array $business_Document_Line_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Line_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Line_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Line_Attachment_Data($business_Document_Line_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Line_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data = $business_Document_Line_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Line_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function addToBusiness_Document_Line_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Line_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Line_Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Award_Line_Splits_Data value
     * @return \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType[]|null
     */
    public function getRequest_for_Quote_Award_Line_Splits_Data()
    {
        return $this->Request_for_Quote_Award_Line_Splits_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award_Line_Splits_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award_Line_Splits_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Award_Line_Splits_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Splits_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem instanceof \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem) ? get_class($request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem), var_export($request_for_Quote_Award_Line_Data_InboundTypeRequest_for_Quote_Award_Line_Splits_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award_Line_Splits_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType[] $request_for_Quote_Award_Line_Splits_Data
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function setRequest_for_Quote_Award_Line_Splits_Data(array $request_for_Quote_Award_Line_Splits_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Award_Line_Splits_DataArrayErrorMessage = self::validateRequest_for_Quote_Award_Line_Splits_DataForArrayConstraintsFromSetRequest_for_Quote_Award_Line_Splits_Data($request_for_Quote_Award_Line_Splits_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Award_Line_Splits_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Splits_Data = $request_for_Quote_Award_Line_Splits_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType $item
     * @return \StructType\Request_for_Quote_Award_Line_Data_InboundType
     */
    public function addToRequest_for_Quote_Award_Line_Splits_Data(\StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award_Line_Splits_Data property can only contain items of type \StructType\Request_for_Quote_Award_Line_Splits_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award_Line_Splits_Data[] = $item;
        return $this;
    }
}
