<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Procurement_Conditional_Rule_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Add Only is set to true although the conditional rule already exists. Set Add Only as false or add a new Condition Rule. | Element containing Procurement Condition Rule for update.
 * @subpackage Structs
 */
class Put_Procurement_Conditional_Rule_RequestType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: A boolean flag indicating if the request is an add only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Procurement_Condition_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: The procurement condition rule
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Procurement_Condition_Rule_Reference;
    /**
     * The Procurement_Condition_Rule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Procurement_Condition_Rule_DataType[]
     */
    public $Procurement_Condition_Rule_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Procurement_Conditional_Rule_RequestType
     * @uses Put_Procurement_Conditional_Rule_RequestType::setAdd_Only()
     * @uses Put_Procurement_Conditional_Rule_RequestType::setProcurement_Condition_Rule_Reference()
     * @uses Put_Procurement_Conditional_Rule_RequestType::setProcurement_Condition_Rule_Data()
     * @uses Put_Procurement_Conditional_Rule_RequestType::setVersion()
     * @param bool $add_Only
     * @param \StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference
     * @param \StructType\Procurement_Condition_Rule_DataType[] $procurement_Condition_Rule_Data
     * @param string $version
     */
    public function __construct($add_Only = null, \StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference = null, array $procurement_Condition_Rule_Data = array(), $version = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setProcurement_Condition_Rule_Reference($procurement_Condition_Rule_Reference)
            ->setProcurement_Condition_Rule_Data($procurement_Condition_Rule_Data)
            ->setVersion($version);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Procurement_Conditional_Rule_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Procurement_Condition_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getProcurement_Condition_Rule_Reference()
    {
        return $this->Procurement_Condition_Rule_Reference;
    }
    /**
     * Set Procurement_Condition_Rule_Reference value
     * @param \StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference
     * @return \StructType\Put_Procurement_Conditional_Rule_RequestType
     */
    public function setProcurement_Condition_Rule_Reference(\StructType\Condition_RuleObjectType $procurement_Condition_Rule_Reference = null)
    {
        $this->Procurement_Condition_Rule_Reference = $procurement_Condition_Rule_Reference;
        return $this;
    }
    /**
     * Get Procurement_Condition_Rule_Data value
     * @return \StructType\Procurement_Condition_Rule_DataType[]|null
     */
    public function getProcurement_Condition_Rule_Data()
    {
        return $this->Procurement_Condition_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Condition_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Condition_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Condition_Rule_DataForArrayConstraintsFromSetProcurement_Condition_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem instanceof \StructType\Procurement_Condition_Rule_DataType) {
                $invalidValues[] = is_object($put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem) ? get_class($put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem) : sprintf('%s(%s)', gettype($put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem), var_export($put_Procurement_Conditional_Rule_RequestTypeProcurement_Condition_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Condition_Rule_Data property can only contain items of type \StructType\Procurement_Condition_Rule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_Rule_DataType[] $procurement_Condition_Rule_Data
     * @return \StructType\Put_Procurement_Conditional_Rule_RequestType
     */
    public function setProcurement_Condition_Rule_Data(array $procurement_Condition_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Condition_Rule_DataArrayErrorMessage = self::validateProcurement_Condition_Rule_DataForArrayConstraintsFromSetProcurement_Condition_Rule_Data($procurement_Condition_Rule_Data))) {
            throw new \InvalidArgumentException($procurement_Condition_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Condition_Rule_Data = $procurement_Condition_Rule_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Condition_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_Rule_DataType $item
     * @return \StructType\Put_Procurement_Conditional_Rule_RequestType
     */
    public function addToProcurement_Condition_Rule_Data(\StructType\Procurement_Condition_Rule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Condition_Rule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Condition_Rule_Data property can only contain items of type \StructType\Procurement_Condition_Rule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Condition_Rule_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Procurement_Conditional_Rule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
