<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Type_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Purchase Item Request Type response data
 * @subpackage Structs
 */
class Purchase_Item_Request_Type_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Type
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Type for Web Service
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Type_WWSType[]
     */
    public $Purchase_Item_Request_Type;
    /**
     * Constructor method for Purchase_Item_Request_Type_Response_DataType
     * @uses Purchase_Item_Request_Type_Response_DataType::setPurchase_Item_Request_Type()
     * @param \StructType\Purchase_Item_Request_Type_WWSType[] $purchase_Item_Request_Type
     */
    public function __construct(array $purchase_Item_Request_Type = array())
    {
        $this
            ->setPurchase_Item_Request_Type($purchase_Item_Request_Type);
    }
    /**
     * Get Purchase_Item_Request_Type value
     * @return \StructType\Purchase_Item_Request_Type_WWSType[]|null
     */
    public function getPurchase_Item_Request_Type()
    {
        return $this->Purchase_Item_Request_Type;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Type method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Type method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_TypeForArrayConstraintsFromSetPurchase_Item_Request_Type(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem instanceof \StructType\Purchase_Item_Request_Type_WWSType) {
                $invalidValues[] = is_object($purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem) ? get_class($purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem), var_export($purchase_Item_Request_Type_Response_DataTypePurchase_Item_Request_TypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Type property can only contain items of type \StructType\Purchase_Item_Request_Type_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Type_WWSType[] $purchase_Item_Request_Type
     * @return \StructType\Purchase_Item_Request_Type_Response_DataType
     */
    public function setPurchase_Item_Request_Type(array $purchase_Item_Request_Type = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_TypeArrayErrorMessage = self::validatePurchase_Item_Request_TypeForArrayConstraintsFromSetPurchase_Item_Request_Type($purchase_Item_Request_Type))) {
            throw new \InvalidArgumentException($purchase_Item_Request_TypeArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Type = $purchase_Item_Request_Type;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Type_WWSType $item
     * @return \StructType\Purchase_Item_Request_Type_Response_DataType
     */
    public function addToPurchase_Item_Request_Type(\StructType\Purchase_Item_Request_Type_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Type_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Type property can only contain items of type \StructType\Purchase_Item_Request_Type_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Type[] = $item;
        return $this;
    }
}
