<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate_Credit_Card_Account_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element can be used to retrieve information about specific Corporate Credit Card Accounts.
 * @subpackage Structs
 */
class Corporate_Credit_Card_Account_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Corporate_Credit_Card_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing Corporate Credit Card Accounts to retrieve.
     * - maxOccurs: unbounded
     * @var \StructType\Corporate_Credit_Card_AccountObjectType[]
     */
    public $Corporate_Credit_Card_Account_Reference;
    /**
     * Constructor method for Corporate_Credit_Card_Account_Request_ReferencesType
     * @uses Corporate_Credit_Card_Account_Request_ReferencesType::setCorporate_Credit_Card_Account_Reference()
     * @param \StructType\Corporate_Credit_Card_AccountObjectType[] $corporate_Credit_Card_Account_Reference
     */
    public function __construct(array $corporate_Credit_Card_Account_Reference = array())
    {
        $this
            ->setCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference);
    }
    /**
     * Get Corporate_Credit_Card_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType[]|null
     */
    public function getCorporate_Credit_Card_Account_Reference()
    {
        return $this->Corporate_Credit_Card_Account_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCorporate_Credit_Card_Account_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCorporate_Credit_Card_Account_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCorporate_Credit_Card_Account_ReferenceForArrayConstraintsFromSetCorporate_Credit_Card_Account_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem instanceof \StructType\Corporate_Credit_Card_AccountObjectType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem) ? get_class($corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem), var_export($corporate_Credit_Card_Account_Request_ReferencesTypeCorporate_Credit_Card_Account_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Corporate_Credit_Card_Account_Reference property can only contain items of type \StructType\Corporate_Credit_Card_AccountObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Corporate_Credit_Card_Account_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountObjectType[] $corporate_Credit_Card_Account_Reference
     * @return \StructType\Corporate_Credit_Card_Account_Request_ReferencesType
     */
    public function setCorporate_Credit_Card_Account_Reference(array $corporate_Credit_Card_Account_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($corporate_Credit_Card_Account_ReferenceArrayErrorMessage = self::validateCorporate_Credit_Card_Account_ReferenceForArrayConstraintsFromSetCorporate_Credit_Card_Account_Reference($corporate_Credit_Card_Account_Reference))) {
            throw new \InvalidArgumentException($corporate_Credit_Card_Account_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Corporate_Credit_Card_Account_Reference = $corporate_Credit_Card_Account_Reference;
        return $this;
    }
    /**
     * Add item to Corporate_Credit_Card_Account_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $item
     * @return \StructType\Corporate_Credit_Card_Account_Request_ReferencesType
     */
    public function addToCorporate_Credit_Card_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Corporate_Credit_Card_AccountObjectType) {
            throw new \InvalidArgumentException(sprintf('The Corporate_Credit_Card_Account_Reference property can only contain items of type \StructType\Corporate_Credit_Card_AccountObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Corporate_Credit_Card_Account_Reference[] = $item;
        return $this;
    }
}
