<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_for_Depreciation_Schedule_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about the asset to which asset depreciation schedule belongs
 * @subpackage Structs
 */
class Asset_for_Depreciation_Schedule_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Company this asset belongs to.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Spend Category this asset belongs to.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Class for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Type for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the current location of the asset
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Acquisition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Acquisition Method this asset was acquired with.
     * - minOccurs: 0
     * @var \StructType\Acquisition_MethodObjectType
     */
    public $Acquisition_Method_Reference;
    /**
     * The Date_Acquired
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was acquired, or the transaction effective date of the acquisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Acquired;
    /**
     * The First_Issue_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was first issued to a worker
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Issue_Date;
    /**
     * Constructor method for Asset_for_Depreciation_Schedule_DataType
     * @uses Asset_for_Depreciation_Schedule_DataType::setCompany_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setAsset_Name()
     * @uses Asset_for_Depreciation_Schedule_DataType::setSpend_Category_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setAsset_Class_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setAsset_Type_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setLocation_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setAcquisition_Method_Reference()
     * @uses Asset_for_Depreciation_Schedule_DataType::setDate_Acquired()
     * @uses Asset_for_Depreciation_Schedule_DataType::setFirst_Issue_Date()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $asset_Name
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @param string $date_Acquired
     * @param string $first_Issue_Date
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, $asset_Name = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, \StructType\LocationObjectType $location_Reference = null, \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null, $date_Acquired = null, $first_Issue_Date = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setAsset_Name($asset_Name)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setLocation_Reference($location_Reference)
            ->setAcquisition_Method_Reference($acquisition_Method_Reference)
            ->setDate_Acquired($date_Acquired)
            ->setFirst_Issue_Date($first_Issue_Date);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Acquisition_Method_Reference value
     * @return \StructType\Acquisition_MethodObjectType|null
     */
    public function getAcquisition_Method_Reference()
    {
        return $this->Acquisition_Method_Reference;
    }
    /**
     * Set Acquisition_Method_Reference value
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setAcquisition_Method_Reference(\StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null)
    {
        $this->Acquisition_Method_Reference = $acquisition_Method_Reference;
        return $this;
    }
    /**
     * Get Date_Acquired value
     * @return string|null
     */
    public function getDate_Acquired()
    {
        return $this->Date_Acquired;
    }
    /**
     * Set Date_Acquired value
     * @param string $date_Acquired
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setDate_Acquired($date_Acquired = null)
    {
        // validation for constraint: string
        if (!is_null($date_Acquired) && !is_string($date_Acquired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Acquired, true), gettype($date_Acquired)), __LINE__);
        }
        $this->Date_Acquired = $date_Acquired;
        return $this;
    }
    /**
     * Get First_Issue_Date value
     * @return string|null
     */
    public function getFirst_Issue_Date()
    {
        return $this->First_Issue_Date;
    }
    /**
     * Set First_Issue_Date value
     * @param string $first_Issue_Date
     * @return \StructType\Asset_for_Depreciation_Schedule_DataType
     */
    public function setFirst_Issue_Date($first_Issue_Date = null)
    {
        // validation for constraint: string
        if (!is_null($first_Issue_Date) && !is_string($first_Issue_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Issue_Date, true), gettype($first_Issue_Date)), __LINE__);
        }
        $this->First_Issue_Date = $first_Issue_Date;
        return $this;
    }
}
