<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Rule_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request criteria for the asset book rules operation
 * @subpackage Structs
 */
class Asset_Book_Rule_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Asset_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing asset book to which the asset book rule data applies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Asset_Books_Reference;
    /**
     * Constructor method for Asset_Book_Rule_Request_CriteriaType
     * @uses Asset_Book_Rule_Request_CriteriaType::setAsset_Books_Reference()
     * @param \StructType\Asset_BookObjectType[] $asset_Books_Reference
     */
    public function __construct(array $asset_Books_Reference = array())
    {
        $this
            ->setAsset_Books_Reference($asset_Books_Reference);
    }
    /**
     * Get Asset_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getAsset_Books_Reference()
    {
        return $this->Asset_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Books_ReferenceForArrayConstraintsFromSetAsset_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem) ? get_class($asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem), var_export($asset_Book_Rule_Request_CriteriaTypeAsset_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $asset_Books_Reference
     * @return \StructType\Asset_Book_Rule_Request_CriteriaType
     */
    public function setAsset_Books_Reference(array $asset_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Books_ReferenceArrayErrorMessage = self::validateAsset_Books_ReferenceForArrayConstraintsFromSetAsset_Books_Reference($asset_Books_Reference))) {
            throw new \InvalidArgumentException($asset_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Books_Reference = $asset_Books_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Asset_Book_Rule_Request_CriteriaType
     */
    public function addToAsset_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Books_Reference[] = $item;
        return $this;
    }
}
