<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Sharing_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Worktag Split Template Sharing Data
 * @subpackage Structs
 */
class Worktag_Split_Template_Sharing_DataType extends AbstractStructBase
{
    /**
     * The Not_Shared
     * Meta information extracted from the WSDL
     * - documentation: Is Worktag Split Template not shared
     * - choice: Not_Shared | Shared | Share_with_Users_and_Groups
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Not_Shared;
    /**
     * The Shared
     * Meta information extracted from the WSDL
     * - documentation: Is Worktag Split Template shared
     * - choice: Not_Shared | Shared | Share_with_Users_and_Groups
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Shared;
    /**
     * The Share_with_Users_and_Groups
     * Meta information extracted from the WSDL
     * - documentation: Share Worktag Split Template with Users and Groups
     * - choice: Not_Shared | Shared | Share_with_Users_and_Groups
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Share_with_Users_and_Groups;
    /**
     * The Specific_Users_for_Worktag_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specific Users for Worktag Split Template
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\System_UserObjectType[]
     */
    public $Specific_Users_for_Worktag_Template_Reference;
    /**
     * The Security_Groups_for_Worktag_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Security Groups for Worktag Split Template
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tenanted_Security_GroupObjectType[]
     */
    public $Security_Groups_for_Worktag_Template_Reference;
    /**
     * The Owning_System_User_Reference
     * Meta information extracted from the WSDL
     * - documentation: Owning System User for Worktag Split Template
     * - minOccurs: 0
     * @var \StructType\System_UserObjectType
     */
    public $Owning_System_User_Reference;
    /**
     * Constructor method for Worktag_Split_Template_Sharing_DataType
     * @uses Worktag_Split_Template_Sharing_DataType::setNot_Shared()
     * @uses Worktag_Split_Template_Sharing_DataType::setShared()
     * @uses Worktag_Split_Template_Sharing_DataType::setShare_with_Users_and_Groups()
     * @uses Worktag_Split_Template_Sharing_DataType::setSpecific_Users_for_Worktag_Template_Reference()
     * @uses Worktag_Split_Template_Sharing_DataType::setSecurity_Groups_for_Worktag_Template_Reference()
     * @uses Worktag_Split_Template_Sharing_DataType::setOwning_System_User_Reference()
     * @param bool $not_Shared
     * @param bool $shared
     * @param bool $share_with_Users_and_Groups
     * @param \StructType\System_UserObjectType[] $specific_Users_for_Worktag_Template_Reference
     * @param \StructType\Tenanted_Security_GroupObjectType[] $security_Groups_for_Worktag_Template_Reference
     * @param \StructType\System_UserObjectType $owning_System_User_Reference
     */
    public function __construct($not_Shared = null, $shared = null, $share_with_Users_and_Groups = null, array $specific_Users_for_Worktag_Template_Reference = array(), array $security_Groups_for_Worktag_Template_Reference = array(), \StructType\System_UserObjectType $owning_System_User_Reference = null)
    {
        $this
            ->setNot_Shared($not_Shared)
            ->setShared($shared)
            ->setShare_with_Users_and_Groups($share_with_Users_and_Groups)
            ->setSpecific_Users_for_Worktag_Template_Reference($specific_Users_for_Worktag_Template_Reference)
            ->setSecurity_Groups_for_Worktag_Template_Reference($security_Groups_for_Worktag_Template_Reference)
            ->setOwning_System_User_Reference($owning_System_User_Reference);
    }
    /**
     * Get Not_Shared value
     * @return bool|null
     */
    public function getNot_Shared()
    {
        return isset($this->Not_Shared) ? $this->Not_Shared : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNot_Shared method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNot_Shared method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNot_SharedForChoiceConstraintsFromSetNot_Shared($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Shared',
            'Share_with_Users_and_Groups',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Not_Shared can\'t be set as the property %s is already set. Only one property must be set among these properties: Not_Shared, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Not_Shared value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $not_Shared
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setNot_Shared($not_Shared = null)
    {
        // validation for constraint: boolean
        if (!is_null($not_Shared) && !is_bool($not_Shared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($not_Shared, true), gettype($not_Shared)), __LINE__);
        }
        // validation for constraint: choice(Not_Shared, Shared, Share_with_Users_and_Groups)
        if ('' !== ($not_SharedChoiceErrorMessage = self::validateNot_SharedForChoiceConstraintsFromSetNot_Shared($not_Shared))) {
            throw new \InvalidArgumentException($not_SharedChoiceErrorMessage, __LINE__);
        }
        if (is_null($not_Shared) || (is_array($not_Shared) && empty($not_Shared))) {
            unset($this->Not_Shared);
        } else {
            $this->Not_Shared = $not_Shared;
        }
        return $this;
    }
    /**
     * Get Shared value
     * @return bool|null
     */
    public function getShared()
    {
        return isset($this->Shared) ? $this->Shared : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShared method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShared method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSharedForChoiceConstraintsFromSetShared($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Not_Shared',
            'Share_with_Users_and_Groups',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Shared can\'t be set as the property %s is already set. Only one property must be set among these properties: Shared, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Shared value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $shared
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setShared($shared = null)
    {
        // validation for constraint: boolean
        if (!is_null($shared) && !is_bool($shared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shared, true), gettype($shared)), __LINE__);
        }
        // validation for constraint: choice(Not_Shared, Shared, Share_with_Users_and_Groups)
        if ('' !== ($sharedChoiceErrorMessage = self::validateSharedForChoiceConstraintsFromSetShared($shared))) {
            throw new \InvalidArgumentException($sharedChoiceErrorMessage, __LINE__);
        }
        if (is_null($shared) || (is_array($shared) && empty($shared))) {
            unset($this->Shared);
        } else {
            $this->Shared = $shared;
        }
        return $this;
    }
    /**
     * Get Share_with_Users_and_Groups value
     * @return bool|null
     */
    public function getShare_with_Users_and_Groups()
    {
        return isset($this->Share_with_Users_and_Groups) ? $this->Share_with_Users_and_Groups : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShare_with_Users_and_Groups method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShare_with_Users_and_Groups method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShare_with_Users_and_GroupsForChoiceConstraintsFromSetShare_with_Users_and_Groups($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Not_Shared',
            'Shared',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Share_with_Users_and_Groups can\'t be set as the property %s is already set. Only one property must be set among these properties: Share_with_Users_and_Groups, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Share_with_Users_and_Groups value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $share_with_Users_and_Groups
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setShare_with_Users_and_Groups($share_with_Users_and_Groups = null)
    {
        // validation for constraint: boolean
        if (!is_null($share_with_Users_and_Groups) && !is_bool($share_with_Users_and_Groups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($share_with_Users_and_Groups, true), gettype($share_with_Users_and_Groups)), __LINE__);
        }
        // validation for constraint: choice(Not_Shared, Shared, Share_with_Users_and_Groups)
        if ('' !== ($share_with_Users_and_GroupsChoiceErrorMessage = self::validateShare_with_Users_and_GroupsForChoiceConstraintsFromSetShare_with_Users_and_Groups($share_with_Users_and_Groups))) {
            throw new \InvalidArgumentException($share_with_Users_and_GroupsChoiceErrorMessage, __LINE__);
        }
        if (is_null($share_with_Users_and_Groups) || (is_array($share_with_Users_and_Groups) && empty($share_with_Users_and_Groups))) {
            unset($this->Share_with_Users_and_Groups);
        } else {
            $this->Share_with_Users_and_Groups = $share_with_Users_and_Groups;
        }
        return $this;
    }
    /**
     * Get Specific_Users_for_Worktag_Template_Reference value
     * @return \StructType\System_UserObjectType[]|null
     */
    public function getSpecific_Users_for_Worktag_Template_Reference()
    {
        return $this->Specific_Users_for_Worktag_Template_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecific_Users_for_Worktag_Template_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecific_Users_for_Worktag_Template_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecific_Users_for_Worktag_Template_ReferenceForArrayConstraintsFromSetSpecific_Users_for_Worktag_Template_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem instanceof \StructType\System_UserObjectType) {
                $invalidValues[] = is_object($worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem) ? get_class($worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem), var_export($worktag_Split_Template_Sharing_DataTypeSpecific_Users_for_Worktag_Template_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Specific_Users_for_Worktag_Template_Reference property can only contain items of type \StructType\System_UserObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Specific_Users_for_Worktag_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\System_UserObjectType[] $specific_Users_for_Worktag_Template_Reference
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setSpecific_Users_for_Worktag_Template_Reference(array $specific_Users_for_Worktag_Template_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($specific_Users_for_Worktag_Template_ReferenceArrayErrorMessage = self::validateSpecific_Users_for_Worktag_Template_ReferenceForArrayConstraintsFromSetSpecific_Users_for_Worktag_Template_Reference($specific_Users_for_Worktag_Template_Reference))) {
            throw new \InvalidArgumentException($specific_Users_for_Worktag_Template_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Specific_Users_for_Worktag_Template_Reference = $specific_Users_for_Worktag_Template_Reference;
        return $this;
    }
    /**
     * Add item to Specific_Users_for_Worktag_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\System_UserObjectType $item
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function addToSpecific_Users_for_Worktag_Template_Reference(\StructType\System_UserObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\System_UserObjectType) {
            throw new \InvalidArgumentException(sprintf('The Specific_Users_for_Worktag_Template_Reference property can only contain items of type \StructType\System_UserObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Specific_Users_for_Worktag_Template_Reference[] = $item;
        return $this;
    }
    /**
     * Get Security_Groups_for_Worktag_Template_Reference value
     * @return \StructType\Tenanted_Security_GroupObjectType[]|null
     */
    public function getSecurity_Groups_for_Worktag_Template_Reference()
    {
        return $this->Security_Groups_for_Worktag_Template_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSecurity_Groups_for_Worktag_Template_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurity_Groups_for_Worktag_Template_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSecurity_Groups_for_Worktag_Template_ReferenceForArrayConstraintsFromSetSecurity_Groups_for_Worktag_Template_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem instanceof \StructType\Tenanted_Security_GroupObjectType) {
                $invalidValues[] = is_object($worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem) ? get_class($worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem), var_export($worktag_Split_Template_Sharing_DataTypeSecurity_Groups_for_Worktag_Template_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Security_Groups_for_Worktag_Template_Reference property can only contain items of type \StructType\Tenanted_Security_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Security_Groups_for_Worktag_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Security_GroupObjectType[] $security_Groups_for_Worktag_Template_Reference
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setSecurity_Groups_for_Worktag_Template_Reference(array $security_Groups_for_Worktag_Template_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($security_Groups_for_Worktag_Template_ReferenceArrayErrorMessage = self::validateSecurity_Groups_for_Worktag_Template_ReferenceForArrayConstraintsFromSetSecurity_Groups_for_Worktag_Template_Reference($security_Groups_for_Worktag_Template_Reference))) {
            throw new \InvalidArgumentException($security_Groups_for_Worktag_Template_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Security_Groups_for_Worktag_Template_Reference = $security_Groups_for_Worktag_Template_Reference;
        return $this;
    }
    /**
     * Add item to Security_Groups_for_Worktag_Template_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tenanted_Security_GroupObjectType $item
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function addToSecurity_Groups_for_Worktag_Template_Reference(\StructType\Tenanted_Security_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tenanted_Security_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Security_Groups_for_Worktag_Template_Reference property can only contain items of type \StructType\Tenanted_Security_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Security_Groups_for_Worktag_Template_Reference[] = $item;
        return $this;
    }
    /**
     * Get Owning_System_User_Reference value
     * @return \StructType\System_UserObjectType|null
     */
    public function getOwning_System_User_Reference()
    {
        return $this->Owning_System_User_Reference;
    }
    /**
     * Set Owning_System_User_Reference value
     * @param \StructType\System_UserObjectType $owning_System_User_Reference
     * @return \StructType\Worktag_Split_Template_Sharing_DataType
     */
    public function setOwning_System_User_Reference(\StructType\System_UserObjectType $owning_System_User_Reference = null)
    {
        $this->Owning_System_User_Reference = $owning_System_User_Reference;
        return $this;
    }
}
