<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requesting_Entity_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Requesting Entity data
 * @subpackage Structs
 */
class Requesting_Entity_DataType extends AbstractStructBase
{
    /**
     * The Requesting_Entity_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique Identifier for the Requesting Entity.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requesting_Entity_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Requesting Entity Name.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate that the Requesting Entity is Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company default for the Requesting Entity.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Type default for the Requesting Entity.
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType
     */
    public $Requisition_Type_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship-To address default for the Requesting Entity.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Override_Ship_To
     * Meta information extracted from the WSDL
     * - documentation: Workday automatically populates ship-to values based on the selected Company and Deliver-to Location. Select this flag to select a different ship-to value and override default ship-to values.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Override_Ship_To;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Deliver-To Location default for the Requesting Entity.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Purchase_Item_List_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restricted Purchase Item Lists that are restricted by this Requesting Entity.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_ListObjectType[]
     */
    public $Purchase_Item_List_Reference;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Items that are restricted by this Requesting Entity.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Purchase_Item_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Requesting_Entity_DataType
     * @uses Requesting_Entity_DataType::setRequesting_Entity_ID()
     * @uses Requesting_Entity_DataType::setName()
     * @uses Requesting_Entity_DataType::setInactive()
     * @uses Requesting_Entity_DataType::setCompany_Reference()
     * @uses Requesting_Entity_DataType::setRequisition_Type_Reference()
     * @uses Requesting_Entity_DataType::setShip_To_Address_Reference()
     * @uses Requesting_Entity_DataType::setOverride_Ship_To()
     * @uses Requesting_Entity_DataType::setDeliver_To_Location_Reference()
     * @uses Requesting_Entity_DataType::setPurchase_Item_List_Reference()
     * @uses Requesting_Entity_DataType::setPurchase_Item_Reference()
     * @uses Requesting_Entity_DataType::setWorktags_Reference()
     * @param string $requesting_Entity_ID
     * @param string $name
     * @param bool $inactive
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Requisition_TypeObjectType $requisition_Type_Reference
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param bool $override_Ship_To
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct($requesting_Entity_ID = null, $name = null, $inactive = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Requisition_TypeObjectType $requisition_Type_Reference = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, $override_Ship_To = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, array $purchase_Item_List_Reference = array(), array $purchase_Item_Reference = array(), array $worktags_Reference = array())
    {
        $this
            ->setRequesting_Entity_ID($requesting_Entity_ID)
            ->setName($name)
            ->setInactive($inactive)
            ->setCompany_Reference($company_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setOverride_Ship_To($override_Ship_To)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setPurchase_Item_List_Reference($purchase_Item_List_Reference)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Requesting_Entity_ID value
     * @return string|null
     */
    public function getRequesting_Entity_ID()
    {
        return $this->Requesting_Entity_ID;
    }
    /**
     * Set Requesting_Entity_ID value
     * @param string $requesting_Entity_ID
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setRequesting_Entity_ID($requesting_Entity_ID = null)
    {
        // validation for constraint: string
        if (!is_null($requesting_Entity_ID) && !is_string($requesting_Entity_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesting_Entity_ID, true), gettype($requesting_Entity_ID)), __LINE__);
        }
        $this->Requesting_Entity_ID = $requesting_Entity_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * Set Requisition_Type_Reference value
     * @param \StructType\Requisition_TypeObjectType $requisition_Type_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $requisition_Type_Reference = null)
    {
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Override_Ship_To value
     * @return bool|null
     */
    public function getOverride_Ship_To()
    {
        return $this->{'Override_Ship-To'};
    }
    /**
     * Set Override_Ship_To value
     * @param bool $override_Ship_To
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setOverride_Ship_To($override_Ship_To = null)
    {
        // validation for constraint: boolean
        if (!is_null($override_Ship_To) && !is_bool($override_Ship_To)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override_Ship_To, true), gettype($override_Ship_To)), __LINE__);
        }
        $this->Override_Ship_To = $this->{'Override_Ship-To'} = $override_Ship_To;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_List_Reference value
     * @return \StructType\Restricted_Purchase_Item_ListObjectType[]|null
     */
    public function getPurchase_Item_List_Reference()
    {
        return $this->Purchase_Item_List_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_List_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_List_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requesting_Entity_DataTypePurchase_Item_List_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requesting_Entity_DataTypePurchase_Item_List_ReferenceItem instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
                $invalidValues[] = is_object($requesting_Entity_DataTypePurchase_Item_List_ReferenceItem) ? get_class($requesting_Entity_DataTypePurchase_Item_List_ReferenceItem) : sprintf('%s(%s)', gettype($requesting_Entity_DataTypePurchase_Item_List_ReferenceItem), var_export($requesting_Entity_DataTypePurchase_Item_List_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setPurchase_Item_List_Reference(array $purchase_Item_List_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_List_ReferenceArrayErrorMessage = self::validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference($purchase_Item_List_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_List_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_List_Reference = $purchase_Item_List_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType $item
     * @return \StructType\Requesting_Entity_DataType
     */
    public function addToPurchase_Item_List_Reference(\StructType\Restricted_Purchase_Item_ListObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_List_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requesting_Entity_DataTypePurchase_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requesting_Entity_DataTypePurchase_Item_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($requesting_Entity_DataTypePurchase_Item_ReferenceItem) ? get_class($requesting_Entity_DataTypePurchase_Item_ReferenceItem) : sprintf('%s(%s)', gettype($requesting_Entity_DataTypePurchase_Item_ReferenceItem), var_export($requesting_Entity_DataTypePurchase_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Item_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setPurchase_Item_Reference(array $purchase_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ReferenceArrayErrorMessage = self::validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference($purchase_Item_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Requesting_Entity_DataType
     */
    public function addToPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requesting_Entity_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requesting_Entity_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($requesting_Entity_DataTypeWorktags_ReferenceItem) ? get_class($requesting_Entity_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($requesting_Entity_DataTypeWorktags_ReferenceItem), var_export($requesting_Entity_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Requesting_Entity_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Requesting_Entity_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
