<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Group Instance and Data
 * @subpackage Structs
 */
class Supplier_GroupType extends AbstractStructBase
{
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Group
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupObjectType
     */
    public $Supplier_Group_Reference;
    /**
     * The Supplier_Group_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Group_DataType[]
     */
    public $Supplier_Group_Data;
    /**
     * Constructor method for Supplier_GroupType
     * @uses Supplier_GroupType::setSupplier_Group_Reference()
     * @uses Supplier_GroupType::setSupplier_Group_Data()
     * @param \StructType\Supplier_GroupObjectType $supplier_Group_Reference
     * @param \StructType\Supplier_Group_DataType[] $supplier_Group_Data
     */
    public function __construct(\StructType\Supplier_GroupObjectType $supplier_Group_Reference = null, array $supplier_Group_Data = array())
    {
        $this
            ->setSupplier_Group_Reference($supplier_Group_Reference)
            ->setSupplier_Group_Data($supplier_Group_Data);
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * Set Supplier_Group_Reference value
     * @param \StructType\Supplier_GroupObjectType $supplier_Group_Reference
     * @return \StructType\Supplier_GroupType
     */
    public function setSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $supplier_Group_Reference = null)
    {
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Get Supplier_Group_Data value
     * @return \StructType\Supplier_Group_DataType[]|null
     */
    public function getSupplier_Group_Data()
    {
        return $this->Supplier_Group_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Group_DataForArrayConstraintsFromSetSupplier_Group_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_GroupTypeSupplier_Group_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_GroupTypeSupplier_Group_DataItem instanceof \StructType\Supplier_Group_DataType) {
                $invalidValues[] = is_object($supplier_GroupTypeSupplier_Group_DataItem) ? get_class($supplier_GroupTypeSupplier_Group_DataItem) : sprintf('%s(%s)', gettype($supplier_GroupTypeSupplier_Group_DataItem), var_export($supplier_GroupTypeSupplier_Group_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group_Data property can only contain items of type \StructType\Supplier_Group_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Group_DataType[] $supplier_Group_Data
     * @return \StructType\Supplier_GroupType
     */
    public function setSupplier_Group_Data(array $supplier_Group_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Group_DataArrayErrorMessage = self::validateSupplier_Group_DataForArrayConstraintsFromSetSupplier_Group_Data($supplier_Group_Data))) {
            throw new \InvalidArgumentException($supplier_Group_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group_Data = $supplier_Group_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Group_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Group_DataType $item
     * @return \StructType\Supplier_GroupType
     */
    public function addToSupplier_Group_Data(\StructType\Supplier_Group_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Group_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group_Data property can only contain items of type \StructType\Supplier_Group_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group_Data[] = $item;
        return $this;
    }
}
