<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Purchase_Order_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | The Purchase Order cannot be updated via this web service if any of the following are true: 1) it contains contingent worker lines, 2) it is not in draft status
 * 3) the Supplier referenced is not Active or on Hold, or 4) the Supplier Contract (if any) does not allow Manual Purchase Orders. | Element containing Purchase Order reference for update and all Purchase Order data items
 * @subpackage Structs
 */
class Submit_Purchase_Order_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Purchase_Order_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Purchase Order Data and all Goods,Service and Project-Based Purchase Order Lines.
     * @var \StructType\Purchase_Order_WWS_DataType
     */
    public $Purchase_Order_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Purchase_Order_RequestType
     * @uses Submit_Purchase_Order_RequestType::setPurchase_Order_Reference()
     * @uses Submit_Purchase_Order_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Purchase_Order_RequestType::setPurchase_Order_Data()
     * @uses Submit_Purchase_Order_RequestType::setAdd_Only()
     * @uses Submit_Purchase_Order_RequestType::setVersion()
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Purchase_Order_WWS_DataType $purchase_Order_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Purchase_Order_WWS_DataType $purchase_Order_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPurchase_Order_Data($purchase_Order_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Submit_Purchase_Order_RequestType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Purchase_Order_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Purchase_Order_Data value
     * @return \StructType\Purchase_Order_WWS_DataType|null
     */
    public function getPurchase_Order_Data()
    {
        return $this->Purchase_Order_Data;
    }
    /**
     * Set Purchase_Order_Data value
     * @param \StructType\Purchase_Order_WWS_DataType $purchase_Order_Data
     * @return \StructType\Submit_Purchase_Order_RequestType
     */
    public function setPurchase_Order_Data(\StructType\Purchase_Order_WWS_DataType $purchase_Order_Data = null)
    {
        $this->Purchase_Order_Data = $purchase_Order_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Purchase_Order_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Purchase_Order_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
