<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Register_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Business Asset reference for update and all Business Asset data items.
 * @subpackage Structs
 */
class Register_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Asset for update only purposes
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Asset Data
     * @var \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public $Business_Asset_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * Constructor method for Register_Asset_RequestType
     * @uses Register_Asset_RequestType::setBusiness_Asset_Reference()
     * @uses Register_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Register_Asset_RequestType::setBusiness_Asset_Data()
     * @uses Register_Asset_RequestType::setAdd_Only()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_Asset_for_Register_WWS_DataType $business_Asset_Data
     * @param bool $add_Only
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_Asset_for_Register_WWS_DataType $business_Asset_Data = null, $add_Only = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_Data($business_Asset_Data)
            ->setAdd_Only($add_Only);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Register_Asset_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Register_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_Data value
     * @return \StructType\Business_Asset_for_Register_WWS_DataType|null
     */
    public function getBusiness_Asset_Data()
    {
        return $this->Business_Asset_Data;
    }
    /**
     * Set Business_Asset_Data value
     * @param \StructType\Business_Asset_for_Register_WWS_DataType $business_Asset_Data
     * @return \StructType\Register_Asset_RequestType
     */
    public function setBusiness_Asset_Data(\StructType\Business_Asset_for_Register_WWS_DataType $business_Asset_Data = null)
    {
        $this->Business_Asset_Data = $business_Asset_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Register_Asset_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
}
