<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Patient_Charge_Information_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Put Patient Charge Information Request
 * @subpackage Structs
 */
class Put_Patient_Charge_Information_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Patient_Charge_Information_Data
     * @var \StructType\Patient_Charge_Information_DataType
     */
    public $Patient_Charge_Information_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Patient_Charge_Information_RequestType
     * @uses Put_Patient_Charge_Information_RequestType::setPurchase_Item_Reference()
     * @uses Put_Patient_Charge_Information_RequestType::setPatient_Charge_Information_Data()
     * @uses Put_Patient_Charge_Information_RequestType::setVersion()
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Patient_Charge_Information_DataType $patient_Charge_Information_Data
     * @param string $version
     */
    public function __construct(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, \StructType\Patient_Charge_Information_DataType $patient_Charge_Information_Data = null, $version = null)
    {
        $this
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setPatient_Charge_Information_Data($patient_Charge_Information_Data)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Put_Patient_Charge_Information_RequestType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Patient_Charge_Information_Data value
     * @return \StructType\Patient_Charge_Information_DataType|null
     */
    public function getPatient_Charge_Information_Data()
    {
        return $this->Patient_Charge_Information_Data;
    }
    /**
     * Set Patient_Charge_Information_Data value
     * @param \StructType\Patient_Charge_Information_DataType $patient_Charge_Information_Data
     * @return \StructType\Put_Patient_Charge_Information_RequestType
     */
    public function setPatient_Charge_Information_Data(\StructType\Patient_Charge_Information_DataType $patient_Charge_Information_Data = null)
    {
        $this->Patient_Charge_Information_Data = $patient_Charge_Information_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Patient_Charge_Information_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
