<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Asset_for_Register_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Quantity for a Composite Asset must be 1 | Existing assets cannot have component data updated. | Composite assets may not reference a Purchase Order, Contract, Receipt, Invoice or Project. | When a Project Number is entered, the PO,
 * supplier invoice, receipt, supplier contract number, and contract dates become not enterable. | Contract Start and End Date becomes not enterable if a PO or Project Number is entered. | PO Number, Contract Number, and Project Number are mutually
 * exclusive and can only be entered one at a time. | Contract End Date cannot be before the Contract Start Date. | Contract End Date cannot be before the date an asset is acquired. | Contract start date must have same value as Date Acquired |
 * Depreciation information cannot be provided for an expensed asset. | When depreciation is based on the number of days per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation
 * amount for each period correctly. In order to complete the depreciation setup for this asset and create the depreciation schedule, you will need to create additional fiscal years / periods for fiscal schedule linked to the company asset book(s). |
 * When depreciation is based on the number of days per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the
 * accounting setup for this asset, you will first need to create additional fiscal years / periods for the fiscal schedule of this asset's company. | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. |
 * Only one worktag for each type is allowed for each document line. | Cannot have an Employee Worktag along with a Contingent Worker Worktag for the same line. | Element containing Business Asset data to register an asset
 * @subpackage Structs
 */
class Business_Asset_for_Register_WWS_DataType extends AbstractStructBase
{
    /**
     * The Business_Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: Business Asset ID is an optional unique web service identifier of the Business Asset. If not entered, it will be automatically generated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Asset_ID;
    /**
     * The Business_Asset_Number
     * Meta information extracted from the WSDL
     * - documentation: The business asset number is generated from the tenant ID Generator for Business Assets.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Asset_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company which holds the asset
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Business_Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text for a meaningful Business Asset Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Asset_Name;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a purchase item for the asset.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Business_Asset_Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text to add additional descriptive information about the Business Asset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Asset_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the spend category. A spend category is a classification of items and services that drive the accounting. All expense items are associated with a Spend Category and sales items are associated with a
     * Revenue Category.If a value is provided for sales item, revenue category will default so it is recommended to provide a value for either sales item or revenue category but not both. It is required if sales item is blank.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value to an existing accounting treatment. Workday supplies the accounting treatments Expense, Depreciable Capital and Non-Depreciable Capital. If you don't enter a value, Workday will default accounting
     * treatment from the Business Asset Accounting Rules based on the values from Company, Spend Category and Cost of asset.
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Acquisition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: If one or more components are present, the acquisition method must be COMPOSED and if acquisition method is COMPOSED, there must be components present. | Acquisition method is invalid. You cannot assign Intercompany Transfer to
     * Acquisition Method. | Reference to an existing Acquisition Method. Workday supplies the acquisition methods including CONSTRUCTED, EXCHANGED, LEASED, OTHER and PURCHASED.
     * @var \StructType\Acquisition_MethodObjectType
     */
    public $Acquisition_Method_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the business asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Acquisition_Cost
     * Meta information extracted from the WSDL
     * - documentation: The unit acquisition cost of the business asset | The acquisition cost entered has too many digits beyond the decimal point | The initial cost when the asset was acquired.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Acquisition_Cost;
    /**
     * The Residual_Value
     * Meta information extracted from the WSDL
     * - documentation: Residual or salvage value | Residual value cannot be greater than acquisition (unit) cost. | The residual value entered has too many digits beyond the decimal point | The current residual value of this asset. | Residual or salvage
     * value for the specified Book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Residual_Value;
    /**
     * The Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: Fair Market Value | The fair market value entered has too many digits beyond the decimal point | Fair Market Value for the specified book
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Fair_Market_Value;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Quantity;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only one worktag for each type is allowed for each document line. | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one
     * value for each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Date_Acquired
     * Meta information extracted from the WSDL
     * - documentation: Ledger Period must exist for the Date Acquired. | Date field indicating when the Business Asset was acquired
     * - maxOccurs: 1
     * @var string
     */
    public $Date_Acquired;
    /**
     * The Date_Placed_in_Service
     * Meta information extracted from the WSDL
     * - documentation: Submit a Place in Service Date on or between the asset's Acquisition Date and today | Date Placed in Service must equal the Date Acquired if depreciation starts based on acquisition. If you leave this date blank, Workday will default
     * it for you. | Ledger Period must exist for the Date Placed in Service. | Date Placed in Service is required when Depreciation Start Date is entered | Date field indicating date the Business Asset was placed in service
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Placed_in_Service;
    /**
     * The Last_Issue_Date
     * Meta information extracted from the WSDL
     * - documentation: Ledger Period must exist for the Last Issued Date. | Last Issued Date cannot be less than Date Acquired | Either both Last Issued Date and a Worker must be populated or both must be blank. | The transaction effective date of the last
     * asset issue or transfer to a worker.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Issue_Date;
    /**
     * The Issued_to_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing worker or custodian of the business asset
     * - minOccurs: 0
     * @var \StructType\Worker_iData_ReferenceType
     */
    public $Issued_to_Worker_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: When registering, issuing or transferring assets with a location, the location usage must include 'Business Asset'. | Reference to the location of the business asset
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for an identifier such as asset Tag Number or Serial Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Serial_Number
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for an identifier such as asset Tag Number or Serial Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Number;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: The manufacturer for the Asset, as a text value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Class for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Asset Type for this asset.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Business_Use_Percentage
     * Meta information extracted from the WSDL
     * - documentation: The Business Use % for the asset. If left empty, will default to 100. | Business Use Percentage | The Business Use Percentage for this asset, as a number from 1 to 100.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Business_Use_Percentage;
    /**
     * The Coordinating_Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: If the cost center is restricted to a company, then the company on the asset must match the company on the cost center. | In the worktag configuration for Business Asset, if inactive values are disallowed for cost centers, then the
     * coordinating cost center must be active. | References the coordinating cost center for reporting only.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Coordinating_Cost_Center_Reference;
    /**
     * The Asset_Coordinator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a valid worker who hasn't been terminated. | References the asset coordinator for reporting only.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Asset_Coordinator_Reference;
    /**
     * The Related_Assets_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to other assets to which this asset is related. Related assets must be within the same company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Related_Assets_Reference;
    /**
     * The PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Number from which the business asset was ordered
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Number;
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: Receipt number on which the asset was received
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The Supplier_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier invoice number for the asset
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Number;
    /**
     * The Project_Number
     * Meta information extracted from the WSDL
     * - documentation: Project number for the business asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Number;
    /**
     * The External_Contract_Number
     * Meta information extracted from the WSDL
     * - documentation: External Contract Number for the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Number;
    /**
     * The External_Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Workday uses these dates to update External Contract Start and End date if you manually register the asset but updates the In service Start and End date for all other sources.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Start_Date;
    /**
     * The External_Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Workday uses these dates to update External Contract Start and End date if you manually register the asset but updates the In service Start and End date for all other sources.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_End_Date;
    /**
     * The Depreciation_Schedule_Data
     * Meta information extracted from the WSDL
     * - documentation: Depreciation schedule information to use to generate depreciation lines for an asset
     * - minOccurs: 0
     * @var \StructType\Asset_Book_Configuration_WWS_DataType
     */
    public $Depreciation_Schedule_Data;
    /**
     * The Component_Lifecycles_are_Discrete
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to identify the type of Composite Asset. When it is checked, life cycle events happen for each Component independently. When it is unchecked, life cycle events happen on the Composite asset only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Component_Lifecycles_are_Discrete;
    /**
     * The Component_Asset_Data
     * Meta information extracted from the WSDL
     * - documentation: Represents a component (asset and quantity) to be used in composing the asset being registered. Components selected must have a quantity available, must not be Expense and for Discrete Composite Lifecycles must be non-Depreciable.
     * Components must have accounting assigned and must not be a part of another composite asset that has a pending registration event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Component_Asset_WWS_DataType[]
     */
    public $Component_Asset_Data;
    /**
     * Constructor method for Business_Asset_for_Register_WWS_DataType
     * @uses Business_Asset_for_Register_WWS_DataType::setBusiness_Asset_ID()
     * @uses Business_Asset_for_Register_WWS_DataType::setBusiness_Asset_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setCompany_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setBusiness_Asset_Name()
     * @uses Business_Asset_for_Register_WWS_DataType::setItem_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setBusiness_Asset_Description()
     * @uses Business_Asset_for_Register_WWS_DataType::setSpend_Category_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setAccounting_Treatment_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setAcquisition_Method_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setMemo()
     * @uses Business_Asset_for_Register_WWS_DataType::setAcquisition_Cost()
     * @uses Business_Asset_for_Register_WWS_DataType::setResidual_Value()
     * @uses Business_Asset_for_Register_WWS_DataType::setFair_Market_Value()
     * @uses Business_Asset_for_Register_WWS_DataType::setQuantity()
     * @uses Business_Asset_for_Register_WWS_DataType::setWorktags_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setDate_Acquired()
     * @uses Business_Asset_for_Register_WWS_DataType::setDate_Placed_in_Service()
     * @uses Business_Asset_for_Register_WWS_DataType::setLast_Issue_Date()
     * @uses Business_Asset_for_Register_WWS_DataType::setIssued_to_Worker_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setLocation_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setAsset_Identifier()
     * @uses Business_Asset_for_Register_WWS_DataType::setSerial_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setManufacturer()
     * @uses Business_Asset_for_Register_WWS_DataType::setAsset_Class_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setAsset_Type_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setBusiness_Use_Percentage()
     * @uses Business_Asset_for_Register_WWS_DataType::setCoordinating_Cost_Center_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setAsset_Coordinator_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setRelated_Assets_Reference()
     * @uses Business_Asset_for_Register_WWS_DataType::setPO_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setReceipt_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setSupplier_Invoice_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setProject_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setExternal_Contract_Number()
     * @uses Business_Asset_for_Register_WWS_DataType::setExternal_Contract_Start_Date()
     * @uses Business_Asset_for_Register_WWS_DataType::setExternal_Contract_End_Date()
     * @uses Business_Asset_for_Register_WWS_DataType::setDepreciation_Schedule_Data()
     * @uses Business_Asset_for_Register_WWS_DataType::setComponent_Lifecycles_are_Discrete()
     * @uses Business_Asset_for_Register_WWS_DataType::setComponent_Asset_Data()
     * @param string $business_Asset_ID
     * @param string $business_Asset_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $business_Asset_Name
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $business_Asset_Description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @param string $memo
     * @param float $acquisition_Cost
     * @param float $residual_Value
     * @param float $fair_Market_Value
     * @param float $quantity
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $date_Acquired
     * @param string $date_Placed_in_Service
     * @param string $last_Issue_Date
     * @param \StructType\Worker_iData_ReferenceType $issued_to_Worker_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param string $asset_Identifier
     * @param string $serial_Number
     * @param string $manufacturer
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param float $business_Use_Percentage
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @param \StructType\Business_AssetObjectType[] $related_Assets_Reference
     * @param string $pO_Number
     * @param string $receipt_Number
     * @param string $supplier_Invoice_Number
     * @param string $project_Number
     * @param string $external_Contract_Number
     * @param string $external_Contract_Start_Date
     * @param string $external_Contract_End_Date
     * @param \StructType\Asset_Book_Configuration_WWS_DataType $depreciation_Schedule_Data
     * @param bool $component_Lifecycles_are_Discrete
     * @param \StructType\Component_Asset_WWS_DataType[] $component_Asset_Data
     */
    public function __construct($business_Asset_ID = null, $business_Asset_Number = null, \StructType\CompanyObjectType $company_Reference = null, $business_Asset_Name = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $business_Asset_Description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null, \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null, $memo = null, $acquisition_Cost = null, $residual_Value = null, $fair_Market_Value = null, $quantity = null, array $worktags_Reference = array(), $date_Acquired = null, $date_Placed_in_Service = null, $last_Issue_Date = null, \StructType\Worker_iData_ReferenceType $issued_to_Worker_Reference = null, \StructType\LocationObjectType $location_Reference = null, $asset_Identifier = null, $serial_Number = null, $manufacturer = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, $business_Use_Percentage = null, \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null, \StructType\WorkerObjectType $asset_Coordinator_Reference = null, array $related_Assets_Reference = array(), $pO_Number = null, $receipt_Number = null, $supplier_Invoice_Number = null, $project_Number = null, $external_Contract_Number = null, $external_Contract_Start_Date = null, $external_Contract_End_Date = null, \StructType\Asset_Book_Configuration_WWS_DataType $depreciation_Schedule_Data = null, $component_Lifecycles_are_Discrete = null, array $component_Asset_Data = array())
    {
        $this
            ->setBusiness_Asset_ID($business_Asset_ID)
            ->setBusiness_Asset_Number($business_Asset_Number)
            ->setCompany_Reference($company_Reference)
            ->setBusiness_Asset_Name($business_Asset_Name)
            ->setItem_Reference($item_Reference)
            ->setBusiness_Asset_Description($business_Asset_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setAcquisition_Method_Reference($acquisition_Method_Reference)
            ->setMemo($memo)
            ->setAcquisition_Cost($acquisition_Cost)
            ->setResidual_Value($residual_Value)
            ->setFair_Market_Value($fair_Market_Value)
            ->setQuantity($quantity)
            ->setWorktags_Reference($worktags_Reference)
            ->setDate_Acquired($date_Acquired)
            ->setDate_Placed_in_Service($date_Placed_in_Service)
            ->setLast_Issue_Date($last_Issue_Date)
            ->setIssued_to_Worker_Reference($issued_to_Worker_Reference)
            ->setLocation_Reference($location_Reference)
            ->setAsset_Identifier($asset_Identifier)
            ->setSerial_Number($serial_Number)
            ->setManufacturer($manufacturer)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setBusiness_Use_Percentage($business_Use_Percentage)
            ->setCoordinating_Cost_Center_Reference($coordinating_Cost_Center_Reference)
            ->setAsset_Coordinator_Reference($asset_Coordinator_Reference)
            ->setRelated_Assets_Reference($related_Assets_Reference)
            ->setPO_Number($pO_Number)
            ->setReceipt_Number($receipt_Number)
            ->setSupplier_Invoice_Number($supplier_Invoice_Number)
            ->setProject_Number($project_Number)
            ->setExternal_Contract_Number($external_Contract_Number)
            ->setExternal_Contract_Start_Date($external_Contract_Start_Date)
            ->setExternal_Contract_End_Date($external_Contract_End_Date)
            ->setDepreciation_Schedule_Data($depreciation_Schedule_Data)
            ->setComponent_Lifecycles_are_Discrete($component_Lifecycles_are_Discrete)
            ->setComponent_Asset_Data($component_Asset_Data);
    }
    /**
     * Get Business_Asset_ID value
     * @return string|null
     */
    public function getBusiness_Asset_ID()
    {
        return $this->Business_Asset_ID;
    }
    /**
     * Set Business_Asset_ID value
     * @param string $business_Asset_ID
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setBusiness_Asset_ID($business_Asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($business_Asset_ID) && !is_string($business_Asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Asset_ID, true), gettype($business_Asset_ID)), __LINE__);
        }
        $this->Business_Asset_ID = $business_Asset_ID;
        return $this;
    }
    /**
     * Get Business_Asset_Number value
     * @return string|null
     */
    public function getBusiness_Asset_Number()
    {
        return $this->Business_Asset_Number;
    }
    /**
     * Set Business_Asset_Number value
     * @param string $business_Asset_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setBusiness_Asset_Number($business_Asset_Number = null)
    {
        // validation for constraint: string
        if (!is_null($business_Asset_Number) && !is_string($business_Asset_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Asset_Number, true), gettype($business_Asset_Number)), __LINE__);
        }
        $this->Business_Asset_Number = $business_Asset_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Business_Asset_Name value
     * @return string|null
     */
    public function getBusiness_Asset_Name()
    {
        return $this->Business_Asset_Name;
    }
    /**
     * Set Business_Asset_Name value
     * @param string $business_Asset_Name
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setBusiness_Asset_Name($business_Asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($business_Asset_Name) && !is_string($business_Asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Asset_Name, true), gettype($business_Asset_Name)), __LINE__);
        }
        $this->Business_Asset_Name = $business_Asset_Name;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Business_Asset_Description value
     * @return string|null
     */
    public function getBusiness_Asset_Description()
    {
        return $this->Business_Asset_Description;
    }
    /**
     * Set Business_Asset_Description value
     * @param string $business_Asset_Description
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setBusiness_Asset_Description($business_Asset_Description = null)
    {
        // validation for constraint: string
        if (!is_null($business_Asset_Description) && !is_string($business_Asset_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Asset_Description, true), gettype($business_Asset_Description)), __LINE__);
        }
        $this->Business_Asset_Description = $business_Asset_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @param \StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $accounting_Treatment_Reference = null)
    {
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Get Acquisition_Method_Reference value
     * @return \StructType\Acquisition_MethodObjectType|null
     */
    public function getAcquisition_Method_Reference()
    {
        return $this->Acquisition_Method_Reference;
    }
    /**
     * Set Acquisition_Method_Reference value
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAcquisition_Method_Reference(\StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null)
    {
        $this->Acquisition_Method_Reference = $acquisition_Method_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Acquisition_Cost value
     * @return float|null
     */
    public function getAcquisition_Cost()
    {
        return $this->Acquisition_Cost;
    }
    /**
     * Set Acquisition_Cost value
     * @param float $acquisition_Cost
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAcquisition_Cost($acquisition_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($acquisition_Cost) && !(is_float($acquisition_Cost) || is_numeric($acquisition_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($acquisition_Cost, true), gettype($acquisition_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($acquisition_Cost) && mb_strlen(mb_substr($acquisition_Cost, false !== mb_strpos($acquisition_Cost, '.') ? mb_strpos($acquisition_Cost, '.') + 1 : mb_strlen($acquisition_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($acquisition_Cost, true), mb_strlen(mb_substr($acquisition_Cost, mb_strpos($acquisition_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($acquisition_Cost) && mb_strlen(preg_replace('/(\D)/', '', $acquisition_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($acquisition_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $acquisition_Cost))), __LINE__);
        }
        $this->Acquisition_Cost = $acquisition_Cost;
        return $this;
    }
    /**
     * Get Residual_Value value
     * @return float|null
     */
    public function getResidual_Value()
    {
        return $this->Residual_Value;
    }
    /**
     * Set Residual_Value value
     * @param float $residual_Value
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setResidual_Value($residual_Value = null)
    {
        // validation for constraint: float
        if (!is_null($residual_Value) && !(is_float($residual_Value) || is_numeric($residual_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($residual_Value, true), gettype($residual_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($residual_Value) && mb_strlen(mb_substr($residual_Value, false !== mb_strpos($residual_Value, '.') ? mb_strpos($residual_Value, '.') + 1 : mb_strlen($residual_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($residual_Value, true), mb_strlen(mb_substr($residual_Value, mb_strpos($residual_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($residual_Value) && mb_strlen(preg_replace('/(\D)/', '', $residual_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($residual_Value, true), mb_strlen(preg_replace('/(\D)/', '', $residual_Value))), __LINE__);
        }
        $this->Residual_Value = $residual_Value;
        return $this;
    }
    /**
     * Get Fair_Market_Value value
     * @return float|null
     */
    public function getFair_Market_Value()
    {
        return $this->Fair_Market_Value;
    }
    /**
     * Set Fair_Market_Value value
     * @param float $fair_Market_Value
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setFair_Market_Value($fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($fair_Market_Value) && !(is_float($fair_Market_Value) || is_numeric($fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fair_Market_Value, true), gettype($fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($fair_Market_Value) && mb_strlen(mb_substr($fair_Market_Value, false !== mb_strpos($fair_Market_Value, '.') ? mb_strpos($fair_Market_Value, '.') + 1 : mb_strlen($fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($fair_Market_Value, true), mb_strlen(mb_substr($fair_Market_Value, mb_strpos($fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $fair_Market_Value))), __LINE__);
        }
        $this->Fair_Market_Value = $fair_Market_Value;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($quantity) && $quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem) ? get_class($business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem), var_export($business_Asset_for_Register_WWS_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Date_Acquired value
     * @return string|null
     */
    public function getDate_Acquired()
    {
        return $this->Date_Acquired;
    }
    /**
     * Set Date_Acquired value
     * @param string $date_Acquired
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setDate_Acquired($date_Acquired = null)
    {
        // validation for constraint: string
        if (!is_null($date_Acquired) && !is_string($date_Acquired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Acquired, true), gettype($date_Acquired)), __LINE__);
        }
        $this->Date_Acquired = $date_Acquired;
        return $this;
    }
    /**
     * Get Date_Placed_in_Service value
     * @return string|null
     */
    public function getDate_Placed_in_Service()
    {
        return $this->Date_Placed_in_Service;
    }
    /**
     * Set Date_Placed_in_Service value
     * @param string $date_Placed_in_Service
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setDate_Placed_in_Service($date_Placed_in_Service = null)
    {
        // validation for constraint: string
        if (!is_null($date_Placed_in_Service) && !is_string($date_Placed_in_Service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Placed_in_Service, true), gettype($date_Placed_in_Service)), __LINE__);
        }
        $this->Date_Placed_in_Service = $date_Placed_in_Service;
        return $this;
    }
    /**
     * Get Last_Issue_Date value
     * @return string|null
     */
    public function getLast_Issue_Date()
    {
        return $this->Last_Issue_Date;
    }
    /**
     * Set Last_Issue_Date value
     * @param string $last_Issue_Date
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setLast_Issue_Date($last_Issue_Date = null)
    {
        // validation for constraint: string
        if (!is_null($last_Issue_Date) && !is_string($last_Issue_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Issue_Date, true), gettype($last_Issue_Date)), __LINE__);
        }
        $this->Last_Issue_Date = $last_Issue_Date;
        return $this;
    }
    /**
     * Get Issued_to_Worker_Reference value
     * @return \StructType\Worker_iData_ReferenceType|null
     */
    public function getIssued_to_Worker_Reference()
    {
        return $this->Issued_to_Worker_Reference;
    }
    /**
     * Set Issued_to_Worker_Reference value
     * @param \StructType\Worker_iData_ReferenceType $issued_to_Worker_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setIssued_to_Worker_Reference(\StructType\Worker_iData_ReferenceType $issued_to_Worker_Reference = null)
    {
        $this->Issued_to_Worker_Reference = $issued_to_Worker_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Serial_Number value
     * @return string|null
     */
    public function getSerial_Number()
    {
        return $this->Serial_Number;
    }
    /**
     * Set Serial_Number value
     * @param string $serial_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setSerial_Number($serial_Number = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Number) && !is_string($serial_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Number, true), gettype($serial_Number)), __LINE__);
        }
        $this->Serial_Number = $serial_Number;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Business_Use_Percentage value
     * @return float|null
     */
    public function getBusiness_Use_Percentage()
    {
        return $this->Business_Use_Percentage;
    }
    /**
     * Set Business_Use_Percentage value
     * @param float $business_Use_Percentage
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setBusiness_Use_Percentage($business_Use_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($business_Use_Percentage) && !(is_float($business_Use_Percentage) || is_numeric($business_Use_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($business_Use_Percentage, true), gettype($business_Use_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($business_Use_Percentage) && mb_strlen(mb_substr($business_Use_Percentage, false !== mb_strpos($business_Use_Percentage, '.') ? mb_strpos($business_Use_Percentage, '.') + 1 : mb_strlen($business_Use_Percentage))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($business_Use_Percentage, true), mb_strlen(mb_substr($business_Use_Percentage, mb_strpos($business_Use_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($business_Use_Percentage) && $business_Use_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($business_Use_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($business_Use_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($business_Use_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage))), __LINE__);
        }
        $this->Business_Use_Percentage = $business_Use_Percentage;
        return $this;
    }
    /**
     * Get Coordinating_Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCoordinating_Cost_Center_Reference()
    {
        return $this->Coordinating_Cost_Center_Reference;
    }
    /**
     * Set Coordinating_Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setCoordinating_Cost_Center_Reference(\StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null)
    {
        $this->Coordinating_Cost_Center_Reference = $coordinating_Cost_Center_Reference;
        return $this;
    }
    /**
     * Get Asset_Coordinator_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAsset_Coordinator_Reference()
    {
        return $this->Asset_Coordinator_Reference;
    }
    /**
     * Set Asset_Coordinator_Reference value
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setAsset_Coordinator_Reference(\StructType\WorkerObjectType $asset_Coordinator_Reference = null)
    {
        $this->Asset_Coordinator_Reference = $asset_Coordinator_Reference;
        return $this;
    }
    /**
     * Get Related_Assets_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getRelated_Assets_Reference()
    {
        return $this->Related_Assets_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Assets_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Assets_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Assets_ReferenceForArrayConstraintsFromSetRelated_Assets_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem) {
            // validation for constraint: itemType
            if (!$business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem) ? get_class($business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem) : sprintf('%s(%s)', gettype($business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem), var_export($business_Asset_for_Register_WWS_DataTypeRelated_Assets_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Assets_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Assets_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $related_Assets_Reference
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setRelated_Assets_Reference(array $related_Assets_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Assets_ReferenceArrayErrorMessage = self::validateRelated_Assets_ReferenceForArrayConstraintsFromSetRelated_Assets_Reference($related_Assets_Reference))) {
            throw new \InvalidArgumentException($related_Assets_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Related_Assets_Reference = $related_Assets_Reference;
        return $this;
    }
    /**
     * Add item to Related_Assets_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function addToRelated_Assets_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Related_Assets_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Assets_Reference[] = $item;
        return $this;
    }
    /**
     * Get PO_Number value
     * @return string|null
     */
    public function getPO_Number()
    {
        return $this->PO_Number;
    }
    /**
     * Set PO_Number value
     * @param string $pO_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setPO_Number($pO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Number) && !is_string($pO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Number, true), gettype($pO_Number)), __LINE__);
        }
        $this->PO_Number = $pO_Number;
        return $this;
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Number()
    {
        return $this->Supplier_Invoice_Number;
    }
    /**
     * Set Supplier_Invoice_Number value
     * @param string $supplier_Invoice_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setSupplier_Invoice_Number($supplier_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Number) && !is_string($supplier_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Number, true), gettype($supplier_Invoice_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Number = $supplier_Invoice_Number;
        return $this;
    }
    /**
     * Get Project_Number value
     * @return string|null
     */
    public function getProject_Number()
    {
        return $this->Project_Number;
    }
    /**
     * Set Project_Number value
     * @param string $project_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setProject_Number($project_Number = null)
    {
        // validation for constraint: string
        if (!is_null($project_Number) && !is_string($project_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Number, true), gettype($project_Number)), __LINE__);
        }
        $this->Project_Number = $project_Number;
        return $this;
    }
    /**
     * Get External_Contract_Number value
     * @return string|null
     */
    public function getExternal_Contract_Number()
    {
        return $this->External_Contract_Number;
    }
    /**
     * Set External_Contract_Number value
     * @param string $external_Contract_Number
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setExternal_Contract_Number($external_Contract_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Number) && !is_string($external_Contract_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Number, true), gettype($external_Contract_Number)), __LINE__);
        }
        $this->External_Contract_Number = $external_Contract_Number;
        return $this;
    }
    /**
     * Get External_Contract_Start_Date value
     * @return string|null
     */
    public function getExternal_Contract_Start_Date()
    {
        return $this->External_Contract_Start_Date;
    }
    /**
     * Set External_Contract_Start_Date value
     * @param string $external_Contract_Start_Date
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setExternal_Contract_Start_Date($external_Contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Start_Date) && !is_string($external_Contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Start_Date, true), gettype($external_Contract_Start_Date)), __LINE__);
        }
        $this->External_Contract_Start_Date = $external_Contract_Start_Date;
        return $this;
    }
    /**
     * Get External_Contract_End_Date value
     * @return string|null
     */
    public function getExternal_Contract_End_Date()
    {
        return $this->External_Contract_End_Date;
    }
    /**
     * Set External_Contract_End_Date value
     * @param string $external_Contract_End_Date
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setExternal_Contract_End_Date($external_Contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_End_Date) && !is_string($external_Contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_End_Date, true), gettype($external_Contract_End_Date)), __LINE__);
        }
        $this->External_Contract_End_Date = $external_Contract_End_Date;
        return $this;
    }
    /**
     * Get Depreciation_Schedule_Data value
     * @return \StructType\Asset_Book_Configuration_WWS_DataType|null
     */
    public function getDepreciation_Schedule_Data()
    {
        return $this->Depreciation_Schedule_Data;
    }
    /**
     * Set Depreciation_Schedule_Data value
     * @param \StructType\Asset_Book_Configuration_WWS_DataType $depreciation_Schedule_Data
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setDepreciation_Schedule_Data(\StructType\Asset_Book_Configuration_WWS_DataType $depreciation_Schedule_Data = null)
    {
        $this->Depreciation_Schedule_Data = $depreciation_Schedule_Data;
        return $this;
    }
    /**
     * Get Component_Lifecycles_are_Discrete value
     * @return bool|null
     */
    public function getComponent_Lifecycles_are_Discrete()
    {
        return $this->Component_Lifecycles_are_Discrete;
    }
    /**
     * Set Component_Lifecycles_are_Discrete value
     * @param bool $component_Lifecycles_are_Discrete
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setComponent_Lifecycles_are_Discrete($component_Lifecycles_are_Discrete = null)
    {
        // validation for constraint: boolean
        if (!is_null($component_Lifecycles_are_Discrete) && !is_bool($component_Lifecycles_are_Discrete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($component_Lifecycles_are_Discrete, true), gettype($component_Lifecycles_are_Discrete)), __LINE__);
        }
        $this->Component_Lifecycles_are_Discrete = $component_Lifecycles_are_Discrete;
        return $this;
    }
    /**
     * Get Component_Asset_Data value
     * @return \StructType\Component_Asset_WWS_DataType[]|null
     */
    public function getComponent_Asset_Data()
    {
        return $this->Component_Asset_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setComponent_Asset_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComponent_Asset_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComponent_Asset_DataForArrayConstraintsFromSetComponent_Asset_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem) {
            // validation for constraint: itemType
            if (!$business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem instanceof \StructType\Component_Asset_WWS_DataType) {
                $invalidValues[] = is_object($business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem) ? get_class($business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem) : sprintf('%s(%s)', gettype($business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem), var_export($business_Asset_for_Register_WWS_DataTypeComponent_Asset_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Component_Asset_Data property can only contain items of type \StructType\Component_Asset_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Component_Asset_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Component_Asset_WWS_DataType[] $component_Asset_Data
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function setComponent_Asset_Data(array $component_Asset_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($component_Asset_DataArrayErrorMessage = self::validateComponent_Asset_DataForArrayConstraintsFromSetComponent_Asset_Data($component_Asset_Data))) {
            throw new \InvalidArgumentException($component_Asset_DataArrayErrorMessage, __LINE__);
        }
        $this->Component_Asset_Data = $component_Asset_Data;
        return $this;
    }
    /**
     * Add item to Component_Asset_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Component_Asset_WWS_DataType $item
     * @return \StructType\Business_Asset_for_Register_WWS_DataType
     */
    public function addToComponent_Asset_Data(\StructType\Component_Asset_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Component_Asset_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Component_Asset_Data property can only contain items of type \StructType\Component_Asset_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Component_Asset_Data[] = $item;
        return $this;
    }
}
