<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bulk_Import_Update_Asset_Book_Configuration_RequestType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for processing many instances of Asset Book Configuration.
 * @subpackage Structs
 */
class Bulk_Import_Update_Asset_Book_Configuration_RequestType extends AbstractStructBase
{
    /**
     * The Update_Asset_Book_Configuration_Request
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Update_Asset_Book_Configuration_RequestType[]
     */
    public $Update_Asset_Book_Configuration_Request;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Bulk_Import_Update_Asset_Book_Configuration_RequestType
     * @uses Bulk_Import_Update_Asset_Book_Configuration_RequestType::setUpdate_Asset_Book_Configuration_Request()
     * @uses Bulk_Import_Update_Asset_Book_Configuration_RequestType::setVersion()
     * @param \StructType\Update_Asset_Book_Configuration_RequestType[] $update_Asset_Book_Configuration_Request
     * @param string $version
     */
    public function __construct(array $update_Asset_Book_Configuration_Request = array(), $version = null)
    {
        $this
            ->setUpdate_Asset_Book_Configuration_Request($update_Asset_Book_Configuration_Request)
            ->setVersion($version);
    }
    /**
     * Get Update_Asset_Book_Configuration_Request value
     * @return \StructType\Update_Asset_Book_Configuration_RequestType[]|null
     */
    public function getUpdate_Asset_Book_Configuration_Request()
    {
        return $this->Update_Asset_Book_Configuration_Request;
    }
    /**
     * This method is responsible for validating the values passed to the setUpdate_Asset_Book_Configuration_Request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdate_Asset_Book_Configuration_Request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUpdate_Asset_Book_Configuration_RequestForArrayConstraintsFromSetUpdate_Asset_Book_Configuration_Request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem) {
            // validation for constraint: itemType
            if (!$bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem instanceof \StructType\Update_Asset_Book_Configuration_RequestType) {
                $invalidValues[] = is_object($bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem) ? get_class($bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem) : sprintf('%s(%s)', gettype($bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem), var_export($bulk_Import_Update_Asset_Book_Configuration_RequestTypeUpdate_Asset_Book_Configuration_RequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Update_Asset_Book_Configuration_Request property can only contain items of type \StructType\Update_Asset_Book_Configuration_RequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Update_Asset_Book_Configuration_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Update_Asset_Book_Configuration_RequestType[] $update_Asset_Book_Configuration_Request
     * @return \StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType
     */
    public function setUpdate_Asset_Book_Configuration_Request(array $update_Asset_Book_Configuration_Request = array())
    {
        // validation for constraint: array
        if ('' !== ($update_Asset_Book_Configuration_RequestArrayErrorMessage = self::validateUpdate_Asset_Book_Configuration_RequestForArrayConstraintsFromSetUpdate_Asset_Book_Configuration_Request($update_Asset_Book_Configuration_Request))) {
            throw new \InvalidArgumentException($update_Asset_Book_Configuration_RequestArrayErrorMessage, __LINE__);
        }
        $this->Update_Asset_Book_Configuration_Request = $update_Asset_Book_Configuration_Request;
        return $this;
    }
    /**
     * Add item to Update_Asset_Book_Configuration_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Update_Asset_Book_Configuration_RequestType $item
     * @return \StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType
     */
    public function addToUpdate_Asset_Book_Configuration_Request(\StructType\Update_Asset_Book_Configuration_RequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Update_Asset_Book_Configuration_RequestType) {
            throw new \InvalidArgumentException(sprintf('The Update_Asset_Book_Configuration_Request property can only contain items of type \StructType\Update_Asset_Book_Configuration_RequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Update_Asset_Book_Configuration_Request[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Bulk_Import_Update_Asset_Book_Configuration_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
