<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Utilization_Target_Rule_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Container for Worker Utilization Target Rule Data
 * @subpackage Structs
 */
class Worker_Utilization_Target_Rule_Details_DataType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Worker_Utilization_Target_Rule_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Rule Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Utilization_Target_Rule_Reference_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Order
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The Project_Rate_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Rate Rule
     * @var \StructType\Project_Cost_Rate_RuleObjectType
     */
    public $Project_Rate_Rule_Reference;
    /**
     * The Utilization_Target_Percent
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Percent
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 5
     * @var float
     */
    public $Utilization_Target_Percent;
    /**
     * Constructor method for Worker_Utilization_Target_Rule_Details_DataType
     * @uses Worker_Utilization_Target_Rule_Details_DataType::setDelete()
     * @uses Worker_Utilization_Target_Rule_Details_DataType::setWorker_Utilization_Target_Rule_Reference_ID()
     * @uses Worker_Utilization_Target_Rule_Details_DataType::setOrder()
     * @uses Worker_Utilization_Target_Rule_Details_DataType::setProject_Rate_Rule_Reference()
     * @uses Worker_Utilization_Target_Rule_Details_DataType::setUtilization_Target_Percent()
     * @param bool $delete
     * @param string $worker_Utilization_Target_Rule_Reference_ID
     * @param string $order
     * @param \StructType\Project_Cost_Rate_RuleObjectType $project_Rate_Rule_Reference
     * @param float $utilization_Target_Percent
     */
    public function __construct($delete = null, $worker_Utilization_Target_Rule_Reference_ID = null, $order = null, \StructType\Project_Cost_Rate_RuleObjectType $project_Rate_Rule_Reference = null, $utilization_Target_Percent = null)
    {
        $this
            ->setDelete($delete)
            ->setWorker_Utilization_Target_Rule_Reference_ID($worker_Utilization_Target_Rule_Reference_ID)
            ->setOrder($order)
            ->setProject_Rate_Rule_Reference($project_Rate_Rule_Reference)
            ->setUtilization_Target_Percent($utilization_Target_Percent);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Worker_Utilization_Target_Rule_Reference_ID value
     * @return string|null
     */
    public function getWorker_Utilization_Target_Rule_Reference_ID()
    {
        return $this->Worker_Utilization_Target_Rule_Reference_ID;
    }
    /**
     * Set Worker_Utilization_Target_Rule_Reference_ID value
     * @param string $worker_Utilization_Target_Rule_Reference_ID
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType
     */
    public function setWorker_Utilization_Target_Rule_Reference_ID($worker_Utilization_Target_Rule_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Utilization_Target_Rule_Reference_ID) && !is_string($worker_Utilization_Target_Rule_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Utilization_Target_Rule_Reference_ID, true), gettype($worker_Utilization_Target_Rule_Reference_ID)), __LINE__);
        }
        $this->Worker_Utilization_Target_Rule_Reference_ID = $worker_Utilization_Target_Rule_Reference_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Project_Rate_Rule_Reference value
     * @return \StructType\Project_Cost_Rate_RuleObjectType|null
     */
    public function getProject_Rate_Rule_Reference()
    {
        return $this->Project_Rate_Rule_Reference;
    }
    /**
     * Set Project_Rate_Rule_Reference value
     * @param \StructType\Project_Cost_Rate_RuleObjectType $project_Rate_Rule_Reference
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType
     */
    public function setProject_Rate_Rule_Reference(\StructType\Project_Cost_Rate_RuleObjectType $project_Rate_Rule_Reference = null)
    {
        $this->Project_Rate_Rule_Reference = $project_Rate_Rule_Reference;
        return $this;
    }
    /**
     * Get Utilization_Target_Percent value
     * @return float|null
     */
    public function getUtilization_Target_Percent()
    {
        return $this->Utilization_Target_Percent;
    }
    /**
     * Set Utilization_Target_Percent value
     * @param float $utilization_Target_Percent
     * @return \StructType\Worker_Utilization_Target_Rule_Details_DataType
     */
    public function setUtilization_Target_Percent($utilization_Target_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($utilization_Target_Percent) && !(is_float($utilization_Target_Percent) || is_numeric($utilization_Target_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($utilization_Target_Percent, true), gettype($utilization_Target_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($utilization_Target_Percent) && mb_strlen(mb_substr($utilization_Target_Percent, false !== mb_strpos($utilization_Target_Percent, '.') ? mb_strpos($utilization_Target_Percent, '.') + 1 : mb_strlen($utilization_Target_Percent))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($utilization_Target_Percent, true), mb_strlen(mb_substr($utilization_Target_Percent, mb_strpos($utilization_Target_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($utilization_Target_Percent) && $utilization_Target_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($utilization_Target_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($utilization_Target_Percent) && mb_strlen(preg_replace('/(\D)/', '', $utilization_Target_Percent)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($utilization_Target_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $utilization_Target_Percent))), __LINE__);
        }
        $this->Utilization_Target_Percent = $utilization_Target_Percent;
        return $this;
    }
}
