<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timesheet_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the request criteria for retrieving Timesheets.
 * @subpackage Structs
 */
class Timesheet_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supervisory_Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * @var \StructType\Supervisory_OrganizationObjectType
     */
    public $Supervisory_Organization_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Worker_Reference;
    /**
     * The Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_After;
    /**
     * The Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_On_or_Before;
    /**
     * The Last_Updated_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated_On_or_After;
    /**
     * The Last_Updated_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated_On_or_Before;
    /**
     * The Payroll_Timesheets_Only
     * Meta information extracted from the WSDL
     * - documentation: Will return all types of Payroll timesheets (including Time In Time Out).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Payroll_Timesheets_Only;
    /**
     * The Project_Timesheets_Only
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Project_Timesheets_Only;
    /**
     * The Time_In_Time_Out_Timesheets_Only
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Time_In_Time_Out_Timesheets_Only;
    /**
     * The Multi_Worker_Timesheets_Only
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Multi_Worker_Timesheets_Only;
    /**
     * The Worker_Time_Card_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: One criteria for the Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Time_Card_Reference_ID;
    /**
     * Constructor method for Timesheet_Request_CriteriaType
     * @uses Timesheet_Request_CriteriaType::setSupervisory_Organization_Reference()
     * @uses Timesheet_Request_CriteriaType::setWorker_Reference()
     * @uses Timesheet_Request_CriteriaType::setStart_Date_On_or_After()
     * @uses Timesheet_Request_CriteriaType::setStart_Date_On_or_Before()
     * @uses Timesheet_Request_CriteriaType::setLast_Updated_On_or_After()
     * @uses Timesheet_Request_CriteriaType::setLast_Updated_On_or_Before()
     * @uses Timesheet_Request_CriteriaType::setPayroll_Timesheets_Only()
     * @uses Timesheet_Request_CriteriaType::setProject_Timesheets_Only()
     * @uses Timesheet_Request_CriteriaType::setTime_In_Time_Out_Timesheets_Only()
     * @uses Timesheet_Request_CriteriaType::setMulti_Worker_Timesheets_Only()
     * @uses Timesheet_Request_CriteriaType::setWorker_Time_Card_Reference_ID()
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @param string $start_Date_On_or_After
     * @param string $start_Date_On_or_Before
     * @param string $last_Updated_On_or_After
     * @param string $last_Updated_On_or_Before
     * @param bool $payroll_Timesheets_Only
     * @param bool $project_Timesheets_Only
     * @param bool $time_In_Time_Out_Timesheets_Only
     * @param bool $multi_Worker_Timesheets_Only
     * @param string $worker_Time_Card_Reference_ID
     */
    public function __construct(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null, array $worker_Reference = array(), $start_Date_On_or_After = null, $start_Date_On_or_Before = null, $last_Updated_On_or_After = null, $last_Updated_On_or_Before = null, $payroll_Timesheets_Only = null, $project_Timesheets_Only = null, $time_In_Time_Out_Timesheets_Only = null, $multi_Worker_Timesheets_Only = null, $worker_Time_Card_Reference_ID = null)
    {
        $this
            ->setSupervisory_Organization_Reference($supervisory_Organization_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setStart_Date_On_or_After($start_Date_On_or_After)
            ->setStart_Date_On_or_Before($start_Date_On_or_Before)
            ->setLast_Updated_On_or_After($last_Updated_On_or_After)
            ->setLast_Updated_On_or_Before($last_Updated_On_or_Before)
            ->setPayroll_Timesheets_Only($payroll_Timesheets_Only)
            ->setProject_Timesheets_Only($project_Timesheets_Only)
            ->setTime_In_Time_Out_Timesheets_Only($time_In_Time_Out_Timesheets_Only)
            ->setMulti_Worker_Timesheets_Only($multi_Worker_Timesheets_Only)
            ->setWorker_Time_Card_Reference_ID($worker_Time_Card_Reference_ID);
    }
    /**
     * Get Supervisory_Organization_Reference value
     * @return \StructType\Supervisory_OrganizationObjectType|null
     */
    public function getSupervisory_Organization_Reference()
    {
        return $this->Supervisory_Organization_Reference;
    }
    /**
     * Set Supervisory_Organization_Reference value
     * @param \StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setSupervisory_Organization_Reference(\StructType\Supervisory_OrganizationObjectType $supervisory_Organization_Reference = null)
    {
        $this->Supervisory_Organization_Reference = $supervisory_Organization_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Request_CriteriaTypeWorker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$timesheet_Request_CriteriaTypeWorker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($timesheet_Request_CriteriaTypeWorker_ReferenceItem) ? get_class($timesheet_Request_CriteriaTypeWorker_ReferenceItem) : sprintf('%s(%s)', gettype($timesheet_Request_CriteriaTypeWorker_ReferenceItem), var_export($timesheet_Request_CriteriaTypeWorker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setWorker_Reference(array $worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_ReferenceArrayErrorMessage = self::validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function addToWorker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Start_Date_On_or_After value
     * @return string|null
     */
    public function getStart_Date_On_or_After()
    {
        return $this->Start_Date_On_or_After;
    }
    /**
     * Set Start_Date_On_or_After value
     * @param string $start_Date_On_or_After
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setStart_Date_On_or_After($start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_After) && !is_string($start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_After, true), gettype($start_Date_On_or_After)), __LINE__);
        }
        $this->Start_Date_On_or_After = $start_Date_On_or_After;
        return $this;
    }
    /**
     * Get Start_Date_On_or_Before value
     * @return string|null
     */
    public function getStart_Date_On_or_Before()
    {
        return $this->Start_Date_On_or_Before;
    }
    /**
     * Set Start_Date_On_or_Before value
     * @param string $start_Date_On_or_Before
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setStart_Date_On_or_Before($start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_On_or_Before) && !is_string($start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_On_or_Before, true), gettype($start_Date_On_or_Before)), __LINE__);
        }
        $this->Start_Date_On_or_Before = $start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Last_Updated_On_or_After value
     * @return string|null
     */
    public function getLast_Updated_On_or_After()
    {
        return $this->Last_Updated_On_or_After;
    }
    /**
     * Set Last_Updated_On_or_After value
     * @param string $last_Updated_On_or_After
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setLast_Updated_On_or_After($last_Updated_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated_On_or_After) && !is_string($last_Updated_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated_On_or_After, true), gettype($last_Updated_On_or_After)), __LINE__);
        }
        $this->Last_Updated_On_or_After = $last_Updated_On_or_After;
        return $this;
    }
    /**
     * Get Last_Updated_On_or_Before value
     * @return string|null
     */
    public function getLast_Updated_On_or_Before()
    {
        return $this->Last_Updated_On_or_Before;
    }
    /**
     * Set Last_Updated_On_or_Before value
     * @param string $last_Updated_On_or_Before
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setLast_Updated_On_or_Before($last_Updated_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated_On_or_Before) && !is_string($last_Updated_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated_On_or_Before, true), gettype($last_Updated_On_or_Before)), __LINE__);
        }
        $this->Last_Updated_On_or_Before = $last_Updated_On_or_Before;
        return $this;
    }
    /**
     * Get Payroll_Timesheets_Only value
     * @return bool|null
     */
    public function getPayroll_Timesheets_Only()
    {
        return $this->Payroll_Timesheets_Only;
    }
    /**
     * Set Payroll_Timesheets_Only value
     * @param bool $payroll_Timesheets_Only
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setPayroll_Timesheets_Only($payroll_Timesheets_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($payroll_Timesheets_Only) && !is_bool($payroll_Timesheets_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payroll_Timesheets_Only, true), gettype($payroll_Timesheets_Only)), __LINE__);
        }
        $this->Payroll_Timesheets_Only = $payroll_Timesheets_Only;
        return $this;
    }
    /**
     * Get Project_Timesheets_Only value
     * @return bool|null
     */
    public function getProject_Timesheets_Only()
    {
        return $this->Project_Timesheets_Only;
    }
    /**
     * Set Project_Timesheets_Only value
     * @param bool $project_Timesheets_Only
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setProject_Timesheets_Only($project_Timesheets_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($project_Timesheets_Only) && !is_bool($project_Timesheets_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($project_Timesheets_Only, true), gettype($project_Timesheets_Only)), __LINE__);
        }
        $this->Project_Timesheets_Only = $project_Timesheets_Only;
        return $this;
    }
    /**
     * Get Time_In_Time_Out_Timesheets_Only value
     * @return bool|null
     */
    public function getTime_In_Time_Out_Timesheets_Only()
    {
        return $this->Time_In_Time_Out_Timesheets_Only;
    }
    /**
     * Set Time_In_Time_Out_Timesheets_Only value
     * @param bool $time_In_Time_Out_Timesheets_Only
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setTime_In_Time_Out_Timesheets_Only($time_In_Time_Out_Timesheets_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($time_In_Time_Out_Timesheets_Only) && !is_bool($time_In_Time_Out_Timesheets_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($time_In_Time_Out_Timesheets_Only, true), gettype($time_In_Time_Out_Timesheets_Only)), __LINE__);
        }
        $this->Time_In_Time_Out_Timesheets_Only = $time_In_Time_Out_Timesheets_Only;
        return $this;
    }
    /**
     * Get Multi_Worker_Timesheets_Only value
     * @return bool|null
     */
    public function getMulti_Worker_Timesheets_Only()
    {
        return $this->{'Multi-Worker_Timesheets_Only'};
    }
    /**
     * Set Multi_Worker_Timesheets_Only value
     * @param bool $multi_Worker_Timesheets_Only
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setMulti_Worker_Timesheets_Only($multi_Worker_Timesheets_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($multi_Worker_Timesheets_Only) && !is_bool($multi_Worker_Timesheets_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multi_Worker_Timesheets_Only, true), gettype($multi_Worker_Timesheets_Only)), __LINE__);
        }
        $this->Multi_Worker_Timesheets_Only = $this->{'Multi-Worker_Timesheets_Only'} = $multi_Worker_Timesheets_Only;
        return $this;
    }
    /**
     * Get Worker_Time_Card_Reference_ID value
     * @return string|null
     */
    public function getWorker_Time_Card_Reference_ID()
    {
        return $this->Worker_Time_Card_Reference_ID;
    }
    /**
     * Set Worker_Time_Card_Reference_ID value
     * @param string $worker_Time_Card_Reference_ID
     * @return \StructType\Timesheet_Request_CriteriaType
     */
    public function setWorker_Time_Card_Reference_ID($worker_Time_Card_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Time_Card_Reference_ID) && !is_string($worker_Time_Card_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Time_Card_Reference_ID, true), gettype($worker_Time_Card_Reference_ID)), __LINE__);
        }
        $this->Worker_Time_Card_Reference_ID = $worker_Time_Card_Reference_ID;
        return $this;
    }
}
