<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Refund_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The alternate ledger currency override you entered must be unique. Enter a unique override currency. | Supplier Refund Data
 * @subpackage Structs
 */
class Supplier_Refund_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Refund_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Refund_Number
     * Meta information extracted from the WSDL
     * - documentation: Refund Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Number;
    /**
     * The Refund_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Status for this refund. This field is read-only and the Submit Supplier Refund web service ignores it.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Refund_Status_Reference;
    /**
     * The Refund_Application_Status
     * Meta information extracted from the WSDL
     * - documentation: Application Status for Supplier Refund. This field is read-only, and will be ignored on a Put or Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Application_Status;
    /**
     * The Cancel_Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: The accounting date when the supplier refund was canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cancel_Accounting_Date;
    /**
     * The Supplier_Refund_Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: The accounting date for the supplier refund.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Refund_Accounting_Date;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Application_Date
     * Meta information extracted from the WSDL
     * - documentation: Application Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Application_Date;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Type
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Refund_Amount
     * Meta information extracted from the WSDL
     * - documentation: Refund Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Refund_Amount;
    /**
     * The Refund_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refund Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Reference;
    /**
     * The Deposit_Reference
     * Meta information extracted from the WSDL
     * - documentation: Deposit Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deposit_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Currency_Rate_Data
     * Meta information extracted from the WSDL
     * - documentation: Currency conversion rate data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_DataType[]
     */
    public $Currency_Rate_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Refund_Application_Data
     * Meta information extracted from the WSDL
     * - documentation: Refund Application Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Refund_Application_DataType[]
     */
    public $Refund_Application_Data;
    /**
     * Constructor method for Supplier_Refund_DataType
     * @uses Supplier_Refund_DataType::setSupplier_Refund_ID()
     * @uses Supplier_Refund_DataType::setSubmit()
     * @uses Supplier_Refund_DataType::setRefund_Number()
     * @uses Supplier_Refund_DataType::setRefund_Status_Reference()
     * @uses Supplier_Refund_DataType::setRefund_Application_Status()
     * @uses Supplier_Refund_DataType::setCancel_Accounting_Date()
     * @uses Supplier_Refund_DataType::setSupplier_Refund_Accounting_Date()
     * @uses Supplier_Refund_DataType::setCompany_Reference()
     * @uses Supplier_Refund_DataType::setSupplier_Reference()
     * @uses Supplier_Refund_DataType::setCurrency_Reference()
     * @uses Supplier_Refund_DataType::setApplication_Date()
     * @uses Supplier_Refund_DataType::setPayment_Type_Reference()
     * @uses Supplier_Refund_DataType::setRefund_Amount()
     * @uses Supplier_Refund_DataType::setRefund_Reference()
     * @uses Supplier_Refund_DataType::setDeposit_Reference()
     * @uses Supplier_Refund_DataType::setMemo()
     * @uses Supplier_Refund_DataType::setCurrency_Rate_Data()
     * @uses Supplier_Refund_DataType::setAttachment_Data()
     * @uses Supplier_Refund_DataType::setRefund_Application_Data()
     * @param string $supplier_Refund_ID
     * @param bool $submit
     * @param string $refund_Number
     * @param \StructType\Document_StatusObjectType $refund_Status_Reference
     * @param string $refund_Application_Status
     * @param string $cancel_Accounting_Date
     * @param string $supplier_Refund_Accounting_Date
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $application_Date
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param float $refund_Amount
     * @param string $refund_Reference
     * @param string $deposit_Reference
     * @param string $memo
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Supplier_Refund_Application_DataType[] $refund_Application_Data
     */
    public function __construct($supplier_Refund_ID = null, $submit = null, $refund_Number = null, \StructType\Document_StatusObjectType $refund_Status_Reference = null, $refund_Application_Status = null, $cancel_Accounting_Date = null, $supplier_Refund_Accounting_Date = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $application_Date = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $refund_Amount = null, $refund_Reference = null, $deposit_Reference = null, $memo = null, array $currency_Rate_Data = array(), array $attachment_Data = array(), array $refund_Application_Data = array())
    {
        $this
            ->setSupplier_Refund_ID($supplier_Refund_ID)
            ->setSubmit($submit)
            ->setRefund_Number($refund_Number)
            ->setRefund_Status_Reference($refund_Status_Reference)
            ->setRefund_Application_Status($refund_Application_Status)
            ->setCancel_Accounting_Date($cancel_Accounting_Date)
            ->setSupplier_Refund_Accounting_Date($supplier_Refund_Accounting_Date)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setApplication_Date($application_Date)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setRefund_Amount($refund_Amount)
            ->setRefund_Reference($refund_Reference)
            ->setDeposit_Reference($deposit_Reference)
            ->setMemo($memo)
            ->setCurrency_Rate_Data($currency_Rate_Data)
            ->setAttachment_Data($attachment_Data)
            ->setRefund_Application_Data($refund_Application_Data);
    }
    /**
     * Get Supplier_Refund_ID value
     * @return string|null
     */
    public function getSupplier_Refund_ID()
    {
        return $this->Supplier_Refund_ID;
    }
    /**
     * Set Supplier_Refund_ID value
     * @param string $supplier_Refund_ID
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setSupplier_Refund_ID($supplier_Refund_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Refund_ID) && !is_string($supplier_Refund_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Refund_ID, true), gettype($supplier_Refund_ID)), __LINE__);
        }
        $this->Supplier_Refund_ID = $supplier_Refund_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Refund_Number value
     * @return string|null
     */
    public function getRefund_Number()
    {
        return $this->Refund_Number;
    }
    /**
     * Set Refund_Number value
     * @param string $refund_Number
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Number($refund_Number = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Number) && !is_string($refund_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Number, true), gettype($refund_Number)), __LINE__);
        }
        $this->Refund_Number = $refund_Number;
        return $this;
    }
    /**
     * Get Refund_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRefund_Status_Reference()
    {
        return $this->Refund_Status_Reference;
    }
    /**
     * Set Refund_Status_Reference value
     * @param \StructType\Document_StatusObjectType $refund_Status_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Status_Reference(\StructType\Document_StatusObjectType $refund_Status_Reference = null)
    {
        $this->Refund_Status_Reference = $refund_Status_Reference;
        return $this;
    }
    /**
     * Get Refund_Application_Status value
     * @return string|null
     */
    public function getRefund_Application_Status()
    {
        return $this->Refund_Application_Status;
    }
    /**
     * Set Refund_Application_Status value
     * @param string $refund_Application_Status
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Application_Status($refund_Application_Status = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Application_Status) && !is_string($refund_Application_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Application_Status, true), gettype($refund_Application_Status)), __LINE__);
        }
        $this->Refund_Application_Status = $refund_Application_Status;
        return $this;
    }
    /**
     * Get Cancel_Accounting_Date value
     * @return string|null
     */
    public function getCancel_Accounting_Date()
    {
        return $this->Cancel_Accounting_Date;
    }
    /**
     * Set Cancel_Accounting_Date value
     * @param string $cancel_Accounting_Date
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setCancel_Accounting_Date($cancel_Accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($cancel_Accounting_Date) && !is_string($cancel_Accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancel_Accounting_Date, true), gettype($cancel_Accounting_Date)), __LINE__);
        }
        $this->Cancel_Accounting_Date = $cancel_Accounting_Date;
        return $this;
    }
    /**
     * Get Supplier_Refund_Accounting_Date value
     * @return string|null
     */
    public function getSupplier_Refund_Accounting_Date()
    {
        return $this->Supplier_Refund_Accounting_Date;
    }
    /**
     * Set Supplier_Refund_Accounting_Date value
     * @param string $supplier_Refund_Accounting_Date
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setSupplier_Refund_Accounting_Date($supplier_Refund_Accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Refund_Accounting_Date) && !is_string($supplier_Refund_Accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Refund_Accounting_Date, true), gettype($supplier_Refund_Accounting_Date)), __LINE__);
        }
        $this->Supplier_Refund_Accounting_Date = $supplier_Refund_Accounting_Date;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Application_Date value
     * @return string|null
     */
    public function getApplication_Date()
    {
        return $this->Application_Date;
    }
    /**
     * Set Application_Date value
     * @param string $application_Date
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setApplication_Date($application_Date = null)
    {
        // validation for constraint: string
        if (!is_null($application_Date) && !is_string($application_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application_Date, true), gettype($application_Date)), __LINE__);
        }
        $this->Application_Date = $application_Date;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Refund_Amount value
     * @return float|null
     */
    public function getRefund_Amount()
    {
        return $this->Refund_Amount;
    }
    /**
     * Set Refund_Amount value
     * @param float $refund_Amount
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Amount($refund_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($refund_Amount) && !(is_float($refund_Amount) || is_numeric($refund_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refund_Amount, true), gettype($refund_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($refund_Amount) && mb_strlen(mb_substr($refund_Amount, false !== mb_strpos($refund_Amount, '.') ? mb_strpos($refund_Amount, '.') + 1 : mb_strlen($refund_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($refund_Amount, true), mb_strlen(mb_substr($refund_Amount, mb_strpos($refund_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($refund_Amount) && mb_strlen(preg_replace('/(\D)/', '', $refund_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($refund_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $refund_Amount))), __LINE__);
        }
        $this->Refund_Amount = $refund_Amount;
        return $this;
    }
    /**
     * Get Refund_Reference value
     * @return string|null
     */
    public function getRefund_Reference()
    {
        return $this->Refund_Reference;
    }
    /**
     * Set Refund_Reference value
     * @param string $refund_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Reference($refund_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Reference) && !is_string($refund_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Reference, true), gettype($refund_Reference)), __LINE__);
        }
        $this->Refund_Reference = $refund_Reference;
        return $this;
    }
    /**
     * Get Deposit_Reference value
     * @return string|null
     */
    public function getDeposit_Reference()
    {
        return $this->Deposit_Reference;
    }
    /**
     * Set Deposit_Reference value
     * @param string $deposit_Reference
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setDeposit_Reference($deposit_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($deposit_Reference) && !is_string($deposit_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deposit_Reference, true), gettype($deposit_Reference)), __LINE__);
        }
        $this->Deposit_Reference = $deposit_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Currency_Rate_Data value
     * @return \StructType\Currency_Rate_DataType[]|null
     */
    public function getCurrency_Rate_Data()
    {
        return $this->Currency_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_DataTypeCurrency_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_DataTypeCurrency_Rate_DataItem instanceof \StructType\Currency_Rate_DataType) {
                $invalidValues[] = is_object($supplier_Refund_DataTypeCurrency_Rate_DataItem) ? get_class($supplier_Refund_DataTypeCurrency_Rate_DataItem) : sprintf('%s(%s)', gettype($supplier_Refund_DataTypeCurrency_Rate_DataItem), var_export($supplier_Refund_DataTypeCurrency_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setCurrency_Rate_Data(array $currency_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_Rate_DataArrayErrorMessage = self::validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data($currency_Rate_Data))) {
            throw new \InvalidArgumentException($currency_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Currency_Rate_Data = $currency_Rate_Data;
        return $this;
    }
    /**
     * Add item to Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType $item
     * @return \StructType\Supplier_Refund_DataType
     */
    public function addToCurrency_Rate_Data(\StructType\Currency_Rate_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency_Rate_DataType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Rate_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Refund_DataTypeAttachment_DataItem) ? get_class($supplier_Refund_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Refund_DataTypeAttachment_DataItem), var_export($supplier_Refund_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Refund_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Refund_Application_Data value
     * @return \StructType\Supplier_Refund_Application_DataType[]|null
     */
    public function getRefund_Application_Data()
    {
        return $this->Refund_Application_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRefund_Application_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefund_Application_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefund_Application_DataForArrayConstraintsFromSetRefund_Application_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_DataTypeRefund_Application_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_DataTypeRefund_Application_DataItem instanceof \StructType\Supplier_Refund_Application_DataType) {
                $invalidValues[] = is_object($supplier_Refund_DataTypeRefund_Application_DataItem) ? get_class($supplier_Refund_DataTypeRefund_Application_DataItem) : sprintf('%s(%s)', gettype($supplier_Refund_DataTypeRefund_Application_DataItem), var_export($supplier_Refund_DataTypeRefund_Application_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Refund_Application_Data property can only contain items of type \StructType\Supplier_Refund_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Refund_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Refund_Application_DataType[] $refund_Application_Data
     * @return \StructType\Supplier_Refund_DataType
     */
    public function setRefund_Application_Data(array $refund_Application_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($refund_Application_DataArrayErrorMessage = self::validateRefund_Application_DataForArrayConstraintsFromSetRefund_Application_Data($refund_Application_Data))) {
            throw new \InvalidArgumentException($refund_Application_DataArrayErrorMessage, __LINE__);
        }
        $this->Refund_Application_Data = $refund_Application_Data;
        return $this;
    }
    /**
     * Add item to Refund_Application_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Refund_Application_DataType $item
     * @return \StructType\Supplier_Refund_DataType
     */
    public function addToRefund_Application_Data(\StructType\Supplier_Refund_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Refund_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Refund_Application_Data property can only contain items of type \StructType\Supplier_Refund_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Refund_Application_Data[] = $item;
        return $this;
    }
}
