<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains criteria to find Supplier Contracts.
 * @subpackage Structs
 */
class Supplier_Contract_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Contract Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Name;
    /**
     * The Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_TypeObjectType[]
     */
    public $Contract_Type_Reference;
    /**
     * The Contract_Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Start_Date_On_or_After;
    /**
     * The Contract_Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Start_Date_On_or_Before;
    /**
     * The Contract_End_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date_On_or_After;
    /**
     * The Contract_End_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date_On_or_Before;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The Created_By_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Created by Worker
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Created_By_Worker_Reference;
    /**
     * The Contract_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Contract On Hold Flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Contract_On_Hold;
    /**
     * The External_System_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference identifier of the external system that stores the supplier contract.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType[]
     */
    public $External_System_ID_Reference;
    /**
     * The External_Contract_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference Identifier of the Supplier Contract in the external system. This should always co-exist with External System ID Reference.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Reference_ID;
    /**
     * Constructor method for Supplier_Contract_Request_CriteriaType
     * @uses Supplier_Contract_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Contract_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_Name()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_Type_Reference()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_Start_Date_On_or_After()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_Start_Date_On_or_Before()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_End_Date_On_or_After()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_End_Date_On_or_Before()
     * @uses Supplier_Contract_Request_CriteriaType::setSupplier_Reference_Number()
     * @uses Supplier_Contract_Request_CriteriaType::setCreated_By_Worker_Reference()
     * @uses Supplier_Contract_Request_CriteriaType::setContract_On_Hold()
     * @uses Supplier_Contract_Request_CriteriaType::setExternal_System_ID_Reference()
     * @uses Supplier_Contract_Request_CriteriaType::setExternal_Contract_Reference_ID()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param string $contract_Name
     * @param \StructType\Supplier_Contract_TypeObjectType[] $contract_Type_Reference
     * @param string $contract_Start_Date_On_or_After
     * @param string $contract_Start_Date_On_or_Before
     * @param string $contract_End_Date_On_or_After
     * @param string $contract_End_Date_On_or_Before
     * @param string $supplier_Reference_Number
     * @param \StructType\WorkerObjectType[] $created_By_Worker_Reference
     * @param bool $contract_On_Hold
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_System_ID_Reference
     * @param string $external_Contract_Reference_ID
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), $contract_Name = null, array $contract_Type_Reference = array(), $contract_Start_Date_On_or_After = null, $contract_Start_Date_On_or_Before = null, $contract_End_Date_On_or_After = null, $contract_End_Date_On_or_Before = null, $supplier_Reference_Number = null, array $created_By_Worker_Reference = array(), $contract_On_Hold = null, array $external_System_ID_Reference = array(), $external_Contract_Reference_ID = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setContract_Name($contract_Name)
            ->setContract_Type_Reference($contract_Type_Reference)
            ->setContract_Start_Date_On_or_After($contract_Start_Date_On_or_After)
            ->setContract_Start_Date_On_or_Before($contract_Start_Date_On_or_Before)
            ->setContract_End_Date_On_or_After($contract_End_Date_On_or_After)
            ->setContract_End_Date_On_or_Before($contract_End_Date_On_or_Before)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setCreated_By_Worker_Reference($created_By_Worker_Reference)
            ->setContract_On_Hold($contract_On_Hold)
            ->setExternal_System_ID_Reference($external_System_ID_Reference)
            ->setExternal_Contract_Reference_ID($external_Contract_Reference_ID);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Contract_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Contract_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Contract_Type_Reference value
     * @return \StructType\Supplier_Contract_TypeObjectType[]|null
     */
    public function getContract_Type_Reference()
    {
        return $this->Contract_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setContract_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContract_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContract_Type_ReferenceForArrayConstraintsFromSetContract_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem instanceof \StructType\Supplier_Contract_TypeObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem) ? get_class($supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem), var_export($supplier_Contract_Request_CriteriaTypeContract_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contract_Type_Reference property can only contain items of type \StructType\Supplier_Contract_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contract_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_TypeObjectType[] $contract_Type_Reference
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_Type_Reference(array $contract_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($contract_Type_ReferenceArrayErrorMessage = self::validateContract_Type_ReferenceForArrayConstraintsFromSetContract_Type_Reference($contract_Type_Reference))) {
            throw new \InvalidArgumentException($contract_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Contract_Type_Reference = $contract_Type_Reference;
        return $this;
    }
    /**
     * Add item to Contract_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_TypeObjectType $item
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function addToContract_Type_Reference(\StructType\Supplier_Contract_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Contract_Type_Reference property can only contain items of type \StructType\Supplier_Contract_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contract_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_Start_Date_On_or_After value
     * @return string|null
     */
    public function getContract_Start_Date_On_or_After()
    {
        return $this->Contract_Start_Date_On_or_After;
    }
    /**
     * Set Contract_Start_Date_On_or_After value
     * @param string $contract_Start_Date_On_or_After
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_Start_Date_On_or_After($contract_Start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date_On_or_After) && !is_string($contract_Start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date_On_or_After, true), gettype($contract_Start_Date_On_or_After)), __LINE__);
        }
        $this->Contract_Start_Date_On_or_After = $contract_Start_Date_On_or_After;
        return $this;
    }
    /**
     * Get Contract_Start_Date_On_or_Before value
     * @return string|null
     */
    public function getContract_Start_Date_On_or_Before()
    {
        return $this->Contract_Start_Date_On_or_Before;
    }
    /**
     * Set Contract_Start_Date_On_or_Before value
     * @param string $contract_Start_Date_On_or_Before
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_Start_Date_On_or_Before($contract_Start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date_On_or_Before) && !is_string($contract_Start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date_On_or_Before, true), gettype($contract_Start_Date_On_or_Before)), __LINE__);
        }
        $this->Contract_Start_Date_On_or_Before = $contract_Start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Contract_End_Date_On_or_After value
     * @return string|null
     */
    public function getContract_End_Date_On_or_After()
    {
        return $this->Contract_End_Date_On_or_After;
    }
    /**
     * Set Contract_End_Date_On_or_After value
     * @param string $contract_End_Date_On_or_After
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_End_Date_On_or_After($contract_End_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date_On_or_After) && !is_string($contract_End_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date_On_or_After, true), gettype($contract_End_Date_On_or_After)), __LINE__);
        }
        $this->Contract_End_Date_On_or_After = $contract_End_Date_On_or_After;
        return $this;
    }
    /**
     * Get Contract_End_Date_On_or_Before value
     * @return string|null
     */
    public function getContract_End_Date_On_or_Before()
    {
        return $this->Contract_End_Date_On_or_Before;
    }
    /**
     * Set Contract_End_Date_On_or_Before value
     * @param string $contract_End_Date_On_or_Before
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_End_Date_On_or_Before($contract_End_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date_On_or_Before) && !is_string($contract_End_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date_On_or_Before, true), gettype($contract_End_Date_On_or_Before)), __LINE__);
        }
        $this->Contract_End_Date_On_or_Before = $contract_End_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get Created_By_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreated_By_Worker_Reference()
    {
        return $this->Created_By_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_By_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_By_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_By_Worker_ReferenceForArrayConstraintsFromSetCreated_By_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) ? get_class($supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem), var_export($supplier_Contract_Request_CriteriaTypeCreated_By_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_By_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_By_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $created_By_Worker_Reference
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setCreated_By_Worker_Reference(array $created_By_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_By_Worker_ReferenceArrayErrorMessage = self::validateCreated_By_Worker_ReferenceForArrayConstraintsFromSetCreated_By_Worker_Reference($created_By_Worker_Reference))) {
            throw new \InvalidArgumentException($created_By_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_By_Worker_Reference = $created_By_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Created_By_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function addToCreated_By_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_By_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_By_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_On_Hold value
     * @return bool|null
     */
    public function getContract_On_Hold()
    {
        return $this->Contract_On_Hold;
    }
    /**
     * Set Contract_On_Hold value
     * @param bool $contract_On_Hold
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setContract_On_Hold($contract_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($contract_On_Hold) && !is_bool($contract_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contract_On_Hold, true), gettype($contract_On_Hold)), __LINE__);
        }
        $this->Contract_On_Hold = $contract_On_Hold;
        return $this;
    }
    /**
     * Get External_System_ID_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType[]|null
     */
    public function getExternal_System_ID_Reference()
    {
        return $this->External_System_ID_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_System_ID_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_System_ID_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_System_ID_ReferenceForArrayConstraintsFromSetExternal_System_ID_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem instanceof \StructType\External_Transaction_Source__All_ObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem) ? get_class($supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem), var_export($supplier_Contract_Request_CriteriaTypeExternal_System_ID_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_System_ID_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_System_ID_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType[] $external_System_ID_Reference
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setExternal_System_ID_Reference(array $external_System_ID_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($external_System_ID_ReferenceArrayErrorMessage = self::validateExternal_System_ID_ReferenceForArrayConstraintsFromSetExternal_System_ID_Reference($external_System_ID_Reference))) {
            throw new \InvalidArgumentException($external_System_ID_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->External_System_ID_Reference = $external_System_ID_Reference;
        return $this;
    }
    /**
     * Add item to External_System_ID_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Transaction_Source__All_ObjectType $item
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function addToExternal_System_ID_Reference(\StructType\External_Transaction_Source__All_ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Transaction_Source__All_ObjectType) {
            throw new \InvalidArgumentException(sprintf('The External_System_ID_Reference property can only contain items of type \StructType\External_Transaction_Source__All_ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_System_ID_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_Contract_Reference_ID value
     * @return string|null
     */
    public function getExternal_Contract_Reference_ID()
    {
        return $this->External_Contract_Reference_ID;
    }
    /**
     * Set External_Contract_Reference_ID value
     * @param string $external_Contract_Reference_ID
     * @return \StructType\Supplier_Contract_Request_CriteriaType
     */
    public function setExternal_Contract_Reference_ID($external_Contract_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Reference_ID) && !is_string($external_Contract_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Reference_ID, true), gettype($external_Contract_Reference_ID)), __LINE__);
        }
        $this->External_Contract_Reference_ID = $external_Contract_Reference_ID;
        return $this;
    }
}
