<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Purchase Item
 * @subpackage Structs
 */
class Purchase_Item_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item
     * - maxOccurs: unbounded
     * @var \StructType\Procurement_ItemObjectType[]
     */
    public $Purchase_Item_Reference;
    /**
     * Constructor method for Purchase_Item_Request_ReferencesType
     * @uses Purchase_Item_Request_ReferencesType::setPurchase_Item_Reference()
     * @param \StructType\Procurement_ItemObjectType[] $purchase_Item_Reference
     */
    public function __construct(array $purchase_Item_Reference = array())
    {
        $this
            ->setPurchase_Item_Reference($purchase_Item_Reference);
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Procurement_ItemObjectType[]|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem instanceof \StructType\Procurement_ItemObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem) ? get_class($purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem), var_export($purchase_Item_Request_ReferencesTypePurchase_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType[] $purchase_Item_Reference
     * @return \StructType\Purchase_Item_Request_ReferencesType
     */
    public function setPurchase_Item_Reference(array $purchase_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_ReferenceArrayErrorMessage = self::validatePurchase_Item_ReferenceForArrayConstraintsFromSetPurchase_Item_Reference($purchase_Item_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType $item
     * @return \StructType\Purchase_Item_Request_ReferencesType
     */
    public function addToPurchase_Item_Reference(\StructType\Procurement_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Reference[] = $item;
        return $this;
    }
}
