<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_PortfolioType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Portfolio Element
 * @subpackage Structs
 */
class Project_PortfolioType extends AbstractStructBase
{
    /**
     * The Project_Portfolio_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Portfolio
     * - minOccurs: 0
     * @var \StructType\Project_PortfolioObjectType
     */
    public $Project_Portfolio_Reference;
    /**
     * The Project_Portfolio_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Portfolio_WWS_DataType[]
     */
    public $Project_Portfolio_Data;
    /**
     * Constructor method for Project_PortfolioType
     * @uses Project_PortfolioType::setProject_Portfolio_Reference()
     * @uses Project_PortfolioType::setProject_Portfolio_Data()
     * @param \StructType\Project_PortfolioObjectType $project_Portfolio_Reference
     * @param \StructType\Project_Portfolio_WWS_DataType[] $project_Portfolio_Data
     */
    public function __construct(\StructType\Project_PortfolioObjectType $project_Portfolio_Reference = null, array $project_Portfolio_Data = array())
    {
        $this
            ->setProject_Portfolio_Reference($project_Portfolio_Reference)
            ->setProject_Portfolio_Data($project_Portfolio_Data);
    }
    /**
     * Get Project_Portfolio_Reference value
     * @return \StructType\Project_PortfolioObjectType|null
     */
    public function getProject_Portfolio_Reference()
    {
        return $this->Project_Portfolio_Reference;
    }
    /**
     * Set Project_Portfolio_Reference value
     * @param \StructType\Project_PortfolioObjectType $project_Portfolio_Reference
     * @return \StructType\Project_PortfolioType
     */
    public function setProject_Portfolio_Reference(\StructType\Project_PortfolioObjectType $project_Portfolio_Reference = null)
    {
        $this->Project_Portfolio_Reference = $project_Portfolio_Reference;
        return $this;
    }
    /**
     * Get Project_Portfolio_Data value
     * @return \StructType\Project_Portfolio_WWS_DataType[]|null
     */
    public function getProject_Portfolio_Data()
    {
        return $this->Project_Portfolio_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Portfolio_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Portfolio_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Portfolio_DataForArrayConstraintsFromSetProject_Portfolio_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_PortfolioTypeProject_Portfolio_DataItem) {
            // validation for constraint: itemType
            if (!$project_PortfolioTypeProject_Portfolio_DataItem instanceof \StructType\Project_Portfolio_WWS_DataType) {
                $invalidValues[] = is_object($project_PortfolioTypeProject_Portfolio_DataItem) ? get_class($project_PortfolioTypeProject_Portfolio_DataItem) : sprintf('%s(%s)', gettype($project_PortfolioTypeProject_Portfolio_DataItem), var_export($project_PortfolioTypeProject_Portfolio_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Portfolio_Data property can only contain items of type \StructType\Project_Portfolio_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Portfolio_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Portfolio_WWS_DataType[] $project_Portfolio_Data
     * @return \StructType\Project_PortfolioType
     */
    public function setProject_Portfolio_Data(array $project_Portfolio_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Portfolio_DataArrayErrorMessage = self::validateProject_Portfolio_DataForArrayConstraintsFromSetProject_Portfolio_Data($project_Portfolio_Data))) {
            throw new \InvalidArgumentException($project_Portfolio_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Portfolio_Data = $project_Portfolio_Data;
        return $this;
    }
    /**
     * Add item to Project_Portfolio_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Portfolio_WWS_DataType $item
     * @return \StructType\Project_PortfolioType
     */
    public function addToProject_Portfolio_Data(\StructType\Project_Portfolio_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Portfolio_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Portfolio_Data property can only contain items of type \StructType\Project_Portfolio_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Portfolio_Data[] = $item;
        return $this;
    }
}
