<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Supplier_Invoice_Adjustment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't cancel the supplier invoice adjustment because lines or line splits are in progress on a project transaction adjustment event. | You cannot modify or cancel your supplier invoice adjustment or lines with an intercompany
 * status of Billed. Cancel any billed intercompany invoices to update the supplier invoice adjustment. | You can't resubmit or cancel the supplier invoice adjustment because 1 or more supplier invoice lines are associated with a capital project and
 * have been capitalized or reclassified to expense | You can't modify or cancel the supplier invoice adjustment because 1 or more projects have billable line status of ready to bill, billed, or revenue recognized.Cancel customer invoices with any
 * billed or revenue recognized lines, or clear the ready to bill option for the billable lines. | Element containing Supplier Invoice Adjustment reference for canceling
 * @subpackage Structs
 */
class Cancel_Supplier_Invoice_Adjustment_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Adjustment
     * @var \StructType\Supplier_Invoice_AdjustmentObjectType
     */
    public $Supplier_Invoice_Adjustment_Reference;
    /**
     * The Invoice_Adjustment_Cancel_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Invoice Cancel Reason. This field is read-only, and will be ignored on a Put or Submit.
     * - minOccurs: 0
     * @var \StructType\Invoice_Cancel_Reason__All_ObjectType
     */
    public $Invoice_Adjustment_Cancel_Reason_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Supplier_Invoice_Adjustment_RequestType
     * @uses Cancel_Supplier_Invoice_Adjustment_RequestType::setSupplier_Invoice_Adjustment_Reference()
     * @uses Cancel_Supplier_Invoice_Adjustment_RequestType::setInvoice_Adjustment_Cancel_Reason_Reference()
     * @uses Cancel_Supplier_Invoice_Adjustment_RequestType::setVersion()
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference
     * @param \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Adjustment_Cancel_Reason_Reference
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference = null, \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Adjustment_Cancel_Reason_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Adjustment_Reference($supplier_Invoice_Adjustment_Reference)
            ->setInvoice_Adjustment_Cancel_Reason_Reference($invoice_Adjustment_Cancel_Reason_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Adjustment_Reference value
     * @return \StructType\Supplier_Invoice_AdjustmentObjectType|null
     */
    public function getSupplier_Invoice_Adjustment_Reference()
    {
        return $this->Supplier_Invoice_Adjustment_Reference;
    }
    /**
     * Set Supplier_Invoice_Adjustment_Reference value
     * @param \StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference
     * @return \StructType\Cancel_Supplier_Invoice_Adjustment_RequestType
     */
    public function setSupplier_Invoice_Adjustment_Reference(\StructType\Supplier_Invoice_AdjustmentObjectType $supplier_Invoice_Adjustment_Reference = null)
    {
        $this->Supplier_Invoice_Adjustment_Reference = $supplier_Invoice_Adjustment_Reference;
        return $this;
    }
    /**
     * Get Invoice_Adjustment_Cancel_Reason_Reference value
     * @return \StructType\Invoice_Cancel_Reason__All_ObjectType|null
     */
    public function getInvoice_Adjustment_Cancel_Reason_Reference()
    {
        return $this->Invoice_Adjustment_Cancel_Reason_Reference;
    }
    /**
     * Set Invoice_Adjustment_Cancel_Reason_Reference value
     * @param \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Adjustment_Cancel_Reason_Reference
     * @return \StructType\Cancel_Supplier_Invoice_Adjustment_RequestType
     */
    public function setInvoice_Adjustment_Cancel_Reason_Reference(\StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Adjustment_Cancel_Reason_Reference = null)
    {
        $this->Invoice_Adjustment_Cancel_Reason_Reference = $invoice_Adjustment_Cancel_Reason_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Supplier_Invoice_Adjustment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
