<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Validation_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Validation Status element related to the Tax ID Data element.
 * @subpackage Structs
 */
class Validation_Status_DataType extends AbstractStructBase
{
    /**
     * The Identification_Number
     * Meta information extracted from the WSDL
     * - documentation: The identification number for the tax ID validation result instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Identification_Number;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the Validation Status Name for the tax ID validation result instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status_Reference;
    /**
     * The Data_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the Validation Service for the tax ID validation result instance.
     * - minOccurs: 0
     * @var \StructType\Tax_ID_Validation_ServiceObjectType
     */
    public $Data_Provider_Reference;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: The date for the tax ID Validation result instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Company_Name
     * Meta information extracted from the WSDL
     * - documentation: The company name for the tax ID validation result instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company_Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: The address for the tax ID validation result instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Additional_Information
     * Meta information extracted from the WSDL
     * - documentation: The legal disclaimer for verification information received from the external validation service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Information;
    /**
     * Constructor method for Validation_Status_DataType
     * @uses Validation_Status_DataType::setIdentification_Number()
     * @uses Validation_Status_DataType::setStatus_Reference()
     * @uses Validation_Status_DataType::setData_Provider_Reference()
     * @uses Validation_Status_DataType::setDate()
     * @uses Validation_Status_DataType::setCompany_Name()
     * @uses Validation_Status_DataType::setAddress()
     * @uses Validation_Status_DataType::setAdditional_Information()
     * @param string $identification_Number
     * @param string $status_Reference
     * @param \StructType\Tax_ID_Validation_ServiceObjectType $data_Provider_Reference
     * @param string $date
     * @param string $company_Name
     * @param string $address
     * @param string $additional_Information
     */
    public function __construct($identification_Number = null, $status_Reference = null, \StructType\Tax_ID_Validation_ServiceObjectType $data_Provider_Reference = null, $date = null, $company_Name = null, $address = null, $additional_Information = null)
    {
        $this
            ->setIdentification_Number($identification_Number)
            ->setStatus_Reference($status_Reference)
            ->setData_Provider_Reference($data_Provider_Reference)
            ->setDate($date)
            ->setCompany_Name($company_Name)
            ->setAddress($address)
            ->setAdditional_Information($additional_Information);
    }
    /**
     * Get Identification_Number value
     * @return string|null
     */
    public function getIdentification_Number()
    {
        return $this->Identification_Number;
    }
    /**
     * Set Identification_Number value
     * @param string $identification_Number
     * @return \StructType\Validation_Status_DataType
     */
    public function setIdentification_Number($identification_Number = null)
    {
        // validation for constraint: string
        if (!is_null($identification_Number) && !is_string($identification_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identification_Number, true), gettype($identification_Number)), __LINE__);
        }
        $this->Identification_Number = $identification_Number;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return string|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param string $status_Reference
     * @return \StructType\Validation_Status_DataType
     */
    public function setStatus_Reference($status_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($status_Reference) && !is_string($status_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status_Reference, true), gettype($status_Reference)), __LINE__);
        }
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Get Data_Provider_Reference value
     * @return \StructType\Tax_ID_Validation_ServiceObjectType|null
     */
    public function getData_Provider_Reference()
    {
        return $this->Data_Provider_Reference;
    }
    /**
     * Set Data_Provider_Reference value
     * @param \StructType\Tax_ID_Validation_ServiceObjectType $data_Provider_Reference
     * @return \StructType\Validation_Status_DataType
     */
    public function setData_Provider_Reference(\StructType\Tax_ID_Validation_ServiceObjectType $data_Provider_Reference = null)
    {
        $this->Data_Provider_Reference = $data_Provider_Reference;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Validation_Status_DataType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Company_Name value
     * @return string|null
     */
    public function getCompany_Name()
    {
        return $this->Company_Name;
    }
    /**
     * Set Company_Name value
     * @param string $company_Name
     * @return \StructType\Validation_Status_DataType
     */
    public function setCompany_Name($company_Name = null)
    {
        // validation for constraint: string
        if (!is_null($company_Name) && !is_string($company_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company_Name, true), gettype($company_Name)), __LINE__);
        }
        $this->Company_Name = $company_Name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\Validation_Status_DataType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Additional_Information value
     * @return string|null
     */
    public function getAdditional_Information()
    {
        return $this->Additional_Information;
    }
    /**
     * Set Additional_Information value
     * @param string $additional_Information
     * @return \StructType\Validation_Status_DataType
     */
    public function setAdditional_Information($additional_Information = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Information) && !is_string($additional_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Information, true), gettype($additional_Information)), __LINE__);
        }
        $this->Additional_Information = $additional_Information;
        return $this;
    }
}
