<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't change the expense payee on existing spend authorizations. | You can't change the spend authorization. | The Total Cash Advance Requested Amount must be greater than 0. | The Total Spend Authorization Amount with or without
 * Spend Lines must be greater than zero. | Spend Authorization contains different instances of optional balancing worktags. If you enable cash advances and balancing worktags, all lines of the spend authorization must match. | Cash Advance has been
 * paid and cannot be updated. | The Reimbursement Payment Type Reference is required and must have a value. | Spend authorization contains more than one instance of the balancing worktag. If you enable cash advances and balancing worktags, all lines of
 * the spend authorization must match. | Enter a Start Date that is before the End Date. OR Enter an End Date that is after the Start Date. | The field End Date is required and must have a value. | The Spend Authorization Estimated Amount is required if
 * no Spend Authorization Lines have been entered. | Expense Report Data contains all of the information about a Spend Authorization.
 * @subpackage Structs
 */
class Spend_Authorization_DataType extends AbstractStructBase
{
    /**
     * The Spend_Authorization_ID
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization ID. This is the Spend Authorization unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Authorization_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for a Worker on the Spend Authorization
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Spend_Authorization_Committee_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Committee for the Expense Payee of the Spend Authorization.
     * - minOccurs: 0
     * @var \StructType\CommitteeObjectType
     */
    public $Spend_Authorization_Committee_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the Spend Authorization inside the Workday application. A Spend Authorization will only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Spend_Authorization_Number
     * Meta information extracted from the WSDL
     * - documentation: The document number that will be assigned to the Spend Authorization. Leave it blank to have the number auto-assigned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Authorization_Number;
    /**
     * The Budget_Check_Status
     * Meta information extracted from the WSDL
     * - documentation: Budget Check Status
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Check_Status;
    /**
     * The Reimbursement_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing reimbursement payment type for the payee.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Reimbursement_Payment_Type_Reference;
    /**
     * The Spend_Authorization_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Date
     * - maxOccurs: 1
     * @var string
     */
    public $Spend_Authorization_Date;
    /**
     * The Spend_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_End_Date;
    /**
     * The Business_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the business purpose for the spend authorization.
     * - minOccurs: 0
     * @var \StructType\Business_PurposeObjectType
     */
    public $Business_Purpose_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Description
     * - maxOccurs: 1
     * @var string
     */
    public $Description;
    /**
     * The Remaining_Balance
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Remaining Balance Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Remaining_Balance;
    /**
     * The Estimated_Amount
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Estimated Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Estimated_Amount;
    /**
     * The Cash_Advance_Requested_Amount
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Cash Advance Requested Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Cash_Advance_Requested_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field should be left blank since the defaulted currency of the company specified will be used as the currency of the Spend Authorization. This field is READ ONLY.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Justification
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Justification
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Justification;
    /**
     * The Spend_Authorization_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Authorization_Line_DataType[]
     */
    public $Spend_Authorization_Line_Replacement_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Spend_Authorization_DataType
     * @uses Spend_Authorization_DataType::setSpend_Authorization_ID()
     * @uses Spend_Authorization_DataType::setSubmit()
     * @uses Spend_Authorization_DataType::setExpense_Payee_Reference()
     * @uses Spend_Authorization_DataType::setSpend_Authorization_Committee_Reference()
     * @uses Spend_Authorization_DataType::setCompany_Reference()
     * @uses Spend_Authorization_DataType::setLocked_in_Workday()
     * @uses Spend_Authorization_DataType::setSpend_Authorization_Number()
     * @uses Spend_Authorization_DataType::setBudget_Check_Status()
     * @uses Spend_Authorization_DataType::setReimbursement_Payment_Type_Reference()
     * @uses Spend_Authorization_DataType::setSpend_Authorization_Date()
     * @uses Spend_Authorization_DataType::setSpend_End_Date()
     * @uses Spend_Authorization_DataType::setBusiness_Purpose_Reference()
     * @uses Spend_Authorization_DataType::setDescription()
     * @uses Spend_Authorization_DataType::setRemaining_Balance()
     * @uses Spend_Authorization_DataType::setEstimated_Amount()
     * @uses Spend_Authorization_DataType::setCash_Advance_Requested_Amount()
     * @uses Spend_Authorization_DataType::setCurrency_Reference()
     * @uses Spend_Authorization_DataType::setJustification()
     * @uses Spend_Authorization_DataType::setSpend_Authorization_Line_Replacement_Data()
     * @uses Spend_Authorization_DataType::setAttachment_Data()
     * @param string $spend_Authorization_ID
     * @param bool $submit
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\CommitteeObjectType $spend_Authorization_Committee_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $locked_in_Workday
     * @param string $spend_Authorization_Number
     * @param string $budget_Check_Status
     * @param \StructType\Payment_TypeObjectType $reimbursement_Payment_Type_Reference
     * @param string $spend_Authorization_Date
     * @param string $spend_End_Date
     * @param \StructType\Business_PurposeObjectType $business_Purpose_Reference
     * @param string $description
     * @param float $remaining_Balance
     * @param float $estimated_Amount
     * @param float $cash_Advance_Requested_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $justification
     * @param \StructType\Spend_Authorization_Line_DataType[] $spend_Authorization_Line_Replacement_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct($spend_Authorization_ID = null, $submit = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, \StructType\CommitteeObjectType $spend_Authorization_Committee_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $locked_in_Workday = null, $spend_Authorization_Number = null, $budget_Check_Status = null, \StructType\Payment_TypeObjectType $reimbursement_Payment_Type_Reference = null, $spend_Authorization_Date = null, $spend_End_Date = null, \StructType\Business_PurposeObjectType $business_Purpose_Reference = null, $description = null, $remaining_Balance = null, $estimated_Amount = null, $cash_Advance_Requested_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $justification = null, array $spend_Authorization_Line_Replacement_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setSpend_Authorization_ID($spend_Authorization_ID)
            ->setSubmit($submit)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setSpend_Authorization_Committee_Reference($spend_Authorization_Committee_Reference)
            ->setCompany_Reference($company_Reference)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setSpend_Authorization_Number($spend_Authorization_Number)
            ->setBudget_Check_Status($budget_Check_Status)
            ->setReimbursement_Payment_Type_Reference($reimbursement_Payment_Type_Reference)
            ->setSpend_Authorization_Date($spend_Authorization_Date)
            ->setSpend_End_Date($spend_End_Date)
            ->setBusiness_Purpose_Reference($business_Purpose_Reference)
            ->setDescription($description)
            ->setRemaining_Balance($remaining_Balance)
            ->setEstimated_Amount($estimated_Amount)
            ->setCash_Advance_Requested_Amount($cash_Advance_Requested_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setJustification($justification)
            ->setSpend_Authorization_Line_Replacement_Data($spend_Authorization_Line_Replacement_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Spend_Authorization_ID value
     * @return string|null
     */
    public function getSpend_Authorization_ID()
    {
        return $this->Spend_Authorization_ID;
    }
    /**
     * Set Spend_Authorization_ID value
     * @param string $spend_Authorization_ID
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_Authorization_ID($spend_Authorization_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Authorization_ID) && !is_string($spend_Authorization_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Authorization_ID, true), gettype($spend_Authorization_ID)), __LINE__);
        }
        $this->Spend_Authorization_ID = $spend_Authorization_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Spend_Authorization_Committee_Reference value
     * @return \StructType\CommitteeObjectType|null
     */
    public function getSpend_Authorization_Committee_Reference()
    {
        return $this->Spend_Authorization_Committee_Reference;
    }
    /**
     * Set Spend_Authorization_Committee_Reference value
     * @param \StructType\CommitteeObjectType $spend_Authorization_Committee_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_Authorization_Committee_Reference(\StructType\CommitteeObjectType $spend_Authorization_Committee_Reference = null)
    {
        $this->Spend_Authorization_Committee_Reference = $spend_Authorization_Committee_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Spend_Authorization_Number value
     * @return string|null
     */
    public function getSpend_Authorization_Number()
    {
        return $this->Spend_Authorization_Number;
    }
    /**
     * Set Spend_Authorization_Number value
     * @param string $spend_Authorization_Number
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_Authorization_Number($spend_Authorization_Number = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Authorization_Number) && !is_string($spend_Authorization_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Authorization_Number, true), gettype($spend_Authorization_Number)), __LINE__);
        }
        $this->Spend_Authorization_Number = $spend_Authorization_Number;
        return $this;
    }
    /**
     * Get Budget_Check_Status value
     * @return string|null
     */
    public function getBudget_Check_Status()
    {
        return $this->Budget_Check_Status;
    }
    /**
     * Set Budget_Check_Status value
     * @param string $budget_Check_Status
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setBudget_Check_Status($budget_Check_Status = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Check_Status) && !is_string($budget_Check_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Check_Status, true), gettype($budget_Check_Status)), __LINE__);
        }
        $this->Budget_Check_Status = $budget_Check_Status;
        return $this;
    }
    /**
     * Get Reimbursement_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getReimbursement_Payment_Type_Reference()
    {
        return $this->Reimbursement_Payment_Type_Reference;
    }
    /**
     * Set Reimbursement_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $reimbursement_Payment_Type_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setReimbursement_Payment_Type_Reference(\StructType\Payment_TypeObjectType $reimbursement_Payment_Type_Reference = null)
    {
        $this->Reimbursement_Payment_Type_Reference = $reimbursement_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Spend_Authorization_Date value
     * @return string|null
     */
    public function getSpend_Authorization_Date()
    {
        return $this->Spend_Authorization_Date;
    }
    /**
     * Set Spend_Authorization_Date value
     * @param string $spend_Authorization_Date
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_Authorization_Date($spend_Authorization_Date = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Authorization_Date) && !is_string($spend_Authorization_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Authorization_Date, true), gettype($spend_Authorization_Date)), __LINE__);
        }
        $this->Spend_Authorization_Date = $spend_Authorization_Date;
        return $this;
    }
    /**
     * Get Spend_End_Date value
     * @return string|null
     */
    public function getSpend_End_Date()
    {
        return $this->Spend_End_Date;
    }
    /**
     * Set Spend_End_Date value
     * @param string $spend_End_Date
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_End_Date($spend_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($spend_End_Date) && !is_string($spend_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_End_Date, true), gettype($spend_End_Date)), __LINE__);
        }
        $this->Spend_End_Date = $spend_End_Date;
        return $this;
    }
    /**
     * Get Business_Purpose_Reference value
     * @return \StructType\Business_PurposeObjectType|null
     */
    public function getBusiness_Purpose_Reference()
    {
        return $this->Business_Purpose_Reference;
    }
    /**
     * Set Business_Purpose_Reference value
     * @param \StructType\Business_PurposeObjectType $business_Purpose_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setBusiness_Purpose_Reference(\StructType\Business_PurposeObjectType $business_Purpose_Reference = null)
    {
        $this->Business_Purpose_Reference = $business_Purpose_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Remaining_Balance value
     * @return float|null
     */
    public function getRemaining_Balance()
    {
        return $this->Remaining_Balance;
    }
    /**
     * Set Remaining_Balance value
     * @param float $remaining_Balance
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setRemaining_Balance($remaining_Balance = null)
    {
        // validation for constraint: float
        if (!is_null($remaining_Balance) && !(is_float($remaining_Balance) || is_numeric($remaining_Balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining_Balance, true), gettype($remaining_Balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($remaining_Balance) && mb_strlen(mb_substr($remaining_Balance, false !== mb_strpos($remaining_Balance, '.') ? mb_strpos($remaining_Balance, '.') + 1 : mb_strlen($remaining_Balance))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($remaining_Balance, true), mb_strlen(mb_substr($remaining_Balance, mb_strpos($remaining_Balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($remaining_Balance) && mb_strlen(preg_replace('/(\D)/', '', $remaining_Balance)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($remaining_Balance, true), mb_strlen(preg_replace('/(\D)/', '', $remaining_Balance))), __LINE__);
        }
        $this->Remaining_Balance = $remaining_Balance;
        return $this;
    }
    /**
     * Get Estimated_Amount value
     * @return float|null
     */
    public function getEstimated_Amount()
    {
        return $this->Estimated_Amount;
    }
    /**
     * Set Estimated_Amount value
     * @param float $estimated_Amount
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setEstimated_Amount($estimated_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Amount) && !(is_float($estimated_Amount) || is_numeric($estimated_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Amount, true), gettype($estimated_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($estimated_Amount) && mb_strlen(mb_substr($estimated_Amount, false !== mb_strpos($estimated_Amount, '.') ? mb_strpos($estimated_Amount, '.') + 1 : mb_strlen($estimated_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($estimated_Amount, true), mb_strlen(mb_substr($estimated_Amount, mb_strpos($estimated_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($estimated_Amount) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($estimated_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Amount))), __LINE__);
        }
        $this->Estimated_Amount = $estimated_Amount;
        return $this;
    }
    /**
     * Get Cash_Advance_Requested_Amount value
     * @return float|null
     */
    public function getCash_Advance_Requested_Amount()
    {
        return $this->Cash_Advance_Requested_Amount;
    }
    /**
     * Set Cash_Advance_Requested_Amount value
     * @param float $cash_Advance_Requested_Amount
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setCash_Advance_Requested_Amount($cash_Advance_Requested_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($cash_Advance_Requested_Amount) && !(is_float($cash_Advance_Requested_Amount) || is_numeric($cash_Advance_Requested_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_Advance_Requested_Amount, true), gettype($cash_Advance_Requested_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cash_Advance_Requested_Amount) && mb_strlen(mb_substr($cash_Advance_Requested_Amount, false !== mb_strpos($cash_Advance_Requested_Amount, '.') ? mb_strpos($cash_Advance_Requested_Amount, '.') + 1 : mb_strlen($cash_Advance_Requested_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cash_Advance_Requested_Amount, true), mb_strlen(mb_substr($cash_Advance_Requested_Amount, mb_strpos($cash_Advance_Requested_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($cash_Advance_Requested_Amount) && mb_strlen(preg_replace('/(\D)/', '', $cash_Advance_Requested_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($cash_Advance_Requested_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $cash_Advance_Requested_Amount))), __LINE__);
        }
        $this->Cash_Advance_Requested_Amount = $cash_Advance_Requested_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Justification value
     * @return string|null
     */
    public function getJustification()
    {
        return $this->Justification;
    }
    /**
     * Set Justification value
     * @param string $justification
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setJustification($justification = null)
    {
        // validation for constraint: string
        if (!is_null($justification) && !is_string($justification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($justification, true), gettype($justification)), __LINE__);
        }
        $this->Justification = $justification;
        return $this;
    }
    /**
     * Get Spend_Authorization_Line_Replacement_Data value
     * @return \StructType\Spend_Authorization_Line_DataType[]|null
     */
    public function getSpend_Authorization_Line_Replacement_Data()
    {
        return $this->Spend_Authorization_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Authorization_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Authorization_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Authorization_Line_Replacement_DataForArrayConstraintsFromSetSpend_Authorization_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem instanceof \StructType\Spend_Authorization_Line_DataType) {
                $invalidValues[] = is_object($spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem) ? get_class($spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem), var_export($spend_Authorization_DataTypeSpend_Authorization_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Authorization_Line_Replacement_Data property can only contain items of type \StructType\Spend_Authorization_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Authorization_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Authorization_Line_DataType[] $spend_Authorization_Line_Replacement_Data
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setSpend_Authorization_Line_Replacement_Data(array $spend_Authorization_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Authorization_Line_Replacement_DataArrayErrorMessage = self::validateSpend_Authorization_Line_Replacement_DataForArrayConstraintsFromSetSpend_Authorization_Line_Replacement_Data($spend_Authorization_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($spend_Authorization_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Spend_Authorization_Line_Replacement_Data = $spend_Authorization_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Spend_Authorization_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Authorization_Line_DataType $item
     * @return \StructType\Spend_Authorization_DataType
     */
    public function addToSpend_Authorization_Line_Replacement_Data(\StructType\Spend_Authorization_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Authorization_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Authorization_Line_Replacement_Data property can only contain items of type \StructType\Spend_Authorization_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Authorization_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($spend_Authorization_DataTypeAttachment_DataItem) ? get_class($spend_Authorization_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($spend_Authorization_DataTypeAttachment_DataItem), var_export($spend_Authorization_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Spend_Authorization_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Spend_Authorization_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
