<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Requisition_Template_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This response includes the Workday ID and Reference ID of the Template Requisition.
 * @subpackage Structs
 */
class Put_Requisition_Template_ResponseType extends AbstractStructBase
{
    /**
     * The Requisition_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Shared Requisition Template
     * - minOccurs: 0
     * @var \StructType\Requisition_TemplateObjectType
     */
    public $Requisition_Template_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Requisition_Template_ResponseType
     * @uses Put_Requisition_Template_ResponseType::setRequisition_Template_Reference()
     * @uses Put_Requisition_Template_ResponseType::setVersion()
     * @param \StructType\Requisition_TemplateObjectType $requisition_Template_Reference
     * @param string $version
     */
    public function __construct(\StructType\Requisition_TemplateObjectType $requisition_Template_Reference = null, $version = null)
    {
        $this
            ->setRequisition_Template_Reference($requisition_Template_Reference)
            ->setVersion($version);
    }
    /**
     * Get Requisition_Template_Reference value
     * @return \StructType\Requisition_TemplateObjectType|null
     */
    public function getRequisition_Template_Reference()
    {
        return $this->Requisition_Template_Reference;
    }
    /**
     * Set Requisition_Template_Reference value
     * @param \StructType\Requisition_TemplateObjectType $requisition_Template_Reference
     * @return \StructType\Put_Requisition_Template_ResponseType
     */
    public function setRequisition_Template_Reference(\StructType\Requisition_TemplateObjectType $requisition_Template_Reference = null)
    {
        $this->Requisition_Template_Reference = $requisition_Template_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Requisition_Template_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
