<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Prepaid_Amortization_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains reference to prepaid amortization type and expected amortization date
 * @subpackage Structs
 */
class Change_Prepaid_Amortization_Type_DataType extends AbstractStructBase
{
    /**
     * The Prepaid_Amortization_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Prepaid Amortization Type
     * @var \StructType\Prepaid_Amortization_TypeObjectType
     */
    public $Prepaid_Amortization_Type_Reference;
    /**
     * The Expected_Amortization_Date
     * Meta information extracted from the WSDL
     * - documentation: Expected Amortization Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expected_Amortization_Date;
    /**
     * Constructor method for Change_Prepaid_Amortization_Type_DataType
     * @uses Change_Prepaid_Amortization_Type_DataType::setPrepaid_Amortization_Type_Reference()
     * @uses Change_Prepaid_Amortization_Type_DataType::setExpected_Amortization_Date()
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepaid_Amortization_Type_Reference
     * @param string $expected_Amortization_Date
     */
    public function __construct(\StructType\Prepaid_Amortization_TypeObjectType $prepaid_Amortization_Type_Reference = null, $expected_Amortization_Date = null)
    {
        $this
            ->setPrepaid_Amortization_Type_Reference($prepaid_Amortization_Type_Reference)
            ->setExpected_Amortization_Date($expected_Amortization_Date);
    }
    /**
     * Get Prepaid_Amortization_Type_Reference value
     * @return \StructType\Prepaid_Amortization_TypeObjectType|null
     */
    public function getPrepaid_Amortization_Type_Reference()
    {
        return $this->Prepaid_Amortization_Type_Reference;
    }
    /**
     * Set Prepaid_Amortization_Type_Reference value
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepaid_Amortization_Type_Reference
     * @return \StructType\Change_Prepaid_Amortization_Type_DataType
     */
    public function setPrepaid_Amortization_Type_Reference(\StructType\Prepaid_Amortization_TypeObjectType $prepaid_Amortization_Type_Reference = null)
    {
        $this->Prepaid_Amortization_Type_Reference = $prepaid_Amortization_Type_Reference;
        return $this;
    }
    /**
     * Get Expected_Amortization_Date value
     * @return string|null
     */
    public function getExpected_Amortization_Date()
    {
        return $this->Expected_Amortization_Date;
    }
    /**
     * Set Expected_Amortization_Date value
     * @param string $expected_Amortization_Date
     * @return \StructType\Change_Prepaid_Amortization_Type_DataType
     */
    public function setExpected_Amortization_Date($expected_Amortization_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expected_Amortization_Date) && !is_string($expected_Amortization_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expected_Amortization_Date, true), gettype($expected_Amortization_Date)), __LINE__);
        }
        $this->Expected_Amortization_Date = $expected_Amortization_Date;
        return $this;
    }
}
