<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_SharesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing a reference to an existing business asset and all its asset share data
 * @subpackage Structs
 */
class Asset_SharesType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing business asset for which the asset share data applies
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Asset_Share_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Share_Response_DataType[]
     */
    public $Asset_Share_Response_Data;
    /**
     * Constructor method for Asset_SharesType
     * @uses Asset_SharesType::setBusiness_Asset_Reference()
     * @uses Asset_SharesType::setAsset_Share_Response_Data()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Asset_Share_Response_DataType[] $asset_Share_Response_Data
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, array $asset_Share_Response_Data = array())
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setAsset_Share_Response_Data($asset_Share_Response_Data);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Asset_SharesType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Share_Response_Data value
     * @return \StructType\Asset_Share_Response_DataType[]|null
     */
    public function getAsset_Share_Response_Data()
    {
        return $this->Asset_Share_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Share_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Share_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Share_Response_DataForArrayConstraintsFromSetAsset_Share_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_SharesTypeAsset_Share_Response_DataItem) {
            // validation for constraint: itemType
            if (!$asset_SharesTypeAsset_Share_Response_DataItem instanceof \StructType\Asset_Share_Response_DataType) {
                $invalidValues[] = is_object($asset_SharesTypeAsset_Share_Response_DataItem) ? get_class($asset_SharesTypeAsset_Share_Response_DataItem) : sprintf('%s(%s)', gettype($asset_SharesTypeAsset_Share_Response_DataItem), var_export($asset_SharesTypeAsset_Share_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Share_Response_Data property can only contain items of type \StructType\Asset_Share_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Share_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Response_DataType[] $asset_Share_Response_Data
     * @return \StructType\Asset_SharesType
     */
    public function setAsset_Share_Response_Data(array $asset_Share_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Share_Response_DataArrayErrorMessage = self::validateAsset_Share_Response_DataForArrayConstraintsFromSetAsset_Share_Response_Data($asset_Share_Response_Data))) {
            throw new \InvalidArgumentException($asset_Share_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Share_Response_Data = $asset_Share_Response_Data;
        return $this;
    }
    /**
     * Add item to Asset_Share_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Response_DataType $item
     * @return \StructType\Asset_SharesType
     */
    public function addToAsset_Share_Response_Data(\StructType\Asset_Share_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Share_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Share_Response_Data property can only contain items of type \StructType\Asset_Share_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Share_Response_Data[] = $item;
        return $this;
    }
}
