<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Line_Renewal_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Renewal Data for Contract Line. Only used on Contracts supporting Renewals and Contracts and has Contract Line End Date.
 * @subpackage Structs
 */
class Supplier_Contract_Line_Renewal_DataType extends AbstractStructBase
{
    /**
     * The Do_Not_Auto_Renew
     * Meta information extracted from the WSDL
     * - documentation: Do Not Auto-Renew this line. Only applies to Contracts that support Renewal Terms and Schedules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Do_Not_Auto_Renew;
    /**
     * The Renewal_Amount
     * Meta information extracted from the WSDL
     * - documentation: Renewal Amount. Only applies to Contracts that support Renewal Terms and Schedules and has a Contract Line End Date.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Renewal_Amount;
    /**
     * The Renewal_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Renewal Quantity. Only applies to Contracts that support Renewal Terms and Schedules.and has a Contract Line End Date.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Renewal_Quantity;
    /**
     * The Renews_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Contract Line Number that this Contract Line renews. Only applies to Contracts that support Renewal Terms and Schedules and has a Contract Line End Date.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Renews_Line_Number;
    /**
     * The Renewed_By_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Contract Line Number that renews this Contract Line. Only applies to Contracts that support Renewal Terms and Schedules and has a Contract Line End Date.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Renewed_By_Line_Number;
    /**
     * Constructor method for Supplier_Contract_Line_Renewal_DataType
     * @uses Supplier_Contract_Line_Renewal_DataType::setDo_Not_Auto_Renew()
     * @uses Supplier_Contract_Line_Renewal_DataType::setRenewal_Amount()
     * @uses Supplier_Contract_Line_Renewal_DataType::setRenewal_Quantity()
     * @uses Supplier_Contract_Line_Renewal_DataType::setRenews_Line_Number()
     * @uses Supplier_Contract_Line_Renewal_DataType::setRenewed_By_Line_Number()
     * @param bool $do_Not_Auto_Renew
     * @param float $renewal_Amount
     * @param float $renewal_Quantity
     * @param string $renews_Line_Number
     * @param string $renewed_By_Line_Number
     */
    public function __construct($do_Not_Auto_Renew = null, $renewal_Amount = null, $renewal_Quantity = null, $renews_Line_Number = null, $renewed_By_Line_Number = null)
    {
        $this
            ->setDo_Not_Auto_Renew($do_Not_Auto_Renew)
            ->setRenewal_Amount($renewal_Amount)
            ->setRenewal_Quantity($renewal_Quantity)
            ->setRenews_Line_Number($renews_Line_Number)
            ->setRenewed_By_Line_Number($renewed_By_Line_Number);
    }
    /**
     * Get Do_Not_Auto_Renew value
     * @return bool|null
     */
    public function getDo_Not_Auto_Renew()
    {
        return $this->{'Do_Not_Auto-Renew'};
    }
    /**
     * Set Do_Not_Auto_Renew value
     * @param bool $do_Not_Auto_Renew
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public function setDo_Not_Auto_Renew($do_Not_Auto_Renew = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_Not_Auto_Renew) && !is_bool($do_Not_Auto_Renew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_Not_Auto_Renew, true), gettype($do_Not_Auto_Renew)), __LINE__);
        }
        $this->Do_Not_Auto_Renew = $this->{'Do_Not_Auto-Renew'} = $do_Not_Auto_Renew;
        return $this;
    }
    /**
     * Get Renewal_Amount value
     * @return float|null
     */
    public function getRenewal_Amount()
    {
        return $this->Renewal_Amount;
    }
    /**
     * Set Renewal_Amount value
     * @param float $renewal_Amount
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public function setRenewal_Amount($renewal_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($renewal_Amount) && !(is_float($renewal_Amount) || is_numeric($renewal_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($renewal_Amount, true), gettype($renewal_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($renewal_Amount) && mb_strlen(mb_substr($renewal_Amount, false !== mb_strpos($renewal_Amount, '.') ? mb_strpos($renewal_Amount, '.') + 1 : mb_strlen($renewal_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($renewal_Amount, true), mb_strlen(mb_substr($renewal_Amount, mb_strpos($renewal_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($renewal_Amount) && $renewal_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($renewal_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($renewal_Amount) && mb_strlen(preg_replace('/(\D)/', '', $renewal_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($renewal_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $renewal_Amount))), __LINE__);
        }
        $this->Renewal_Amount = $renewal_Amount;
        return $this;
    }
    /**
     * Get Renewal_Quantity value
     * @return float|null
     */
    public function getRenewal_Quantity()
    {
        return $this->Renewal_Quantity;
    }
    /**
     * Set Renewal_Quantity value
     * @param float $renewal_Quantity
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public function setRenewal_Quantity($renewal_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($renewal_Quantity) && !(is_float($renewal_Quantity) || is_numeric($renewal_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($renewal_Quantity, true), gettype($renewal_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($renewal_Quantity) && mb_strlen(mb_substr($renewal_Quantity, false !== mb_strpos($renewal_Quantity, '.') ? mb_strpos($renewal_Quantity, '.') + 1 : mb_strlen($renewal_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($renewal_Quantity, true), mb_strlen(mb_substr($renewal_Quantity, mb_strpos($renewal_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($renewal_Quantity) && $renewal_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($renewal_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($renewal_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $renewal_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($renewal_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $renewal_Quantity))), __LINE__);
        }
        $this->Renewal_Quantity = $renewal_Quantity;
        return $this;
    }
    /**
     * Get Renews_Line_Number value
     * @return string|null
     */
    public function getRenews_Line_Number()
    {
        return $this->Renews_Line_Number;
    }
    /**
     * Set Renews_Line_Number value
     * @param string $renews_Line_Number
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public function setRenews_Line_Number($renews_Line_Number = null)
    {
        // validation for constraint: string
        if (!is_null($renews_Line_Number) && !is_string($renews_Line_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renews_Line_Number, true), gettype($renews_Line_Number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($renews_Line_Number) && mb_strlen($renews_Line_Number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($renews_Line_Number)), __LINE__);
        }
        $this->Renews_Line_Number = $renews_Line_Number;
        return $this;
    }
    /**
     * Get Renewed_By_Line_Number value
     * @return string|null
     */
    public function getRenewed_By_Line_Number()
    {
        return $this->Renewed_By_Line_Number;
    }
    /**
     * Set Renewed_By_Line_Number value
     * @param string $renewed_By_Line_Number
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public function setRenewed_By_Line_Number($renewed_By_Line_Number = null)
    {
        // validation for constraint: string
        if (!is_null($renewed_By_Line_Number) && !is_string($renewed_By_Line_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewed_By_Line_Number, true), gettype($renewed_By_Line_Number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($renewed_By_Line_Number) && mb_strlen($renewed_By_Line_Number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($renewed_By_Line_Number)), __LINE__);
        }
        $this->Renewed_By_Line_Number = $renewed_By_Line_Number;
        return $this;
    }
}
