<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Category_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Category reference for update and all Supplier Category data items
 * @subpackage Structs
 */
class Put_Supplier_Category_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Category for update only purposes
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType
     */
    public $Supplier_Category_Reference;
    /**
     * The Supplier_Category_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category Data
     * @var \StructType\Supplier_Category_DataType
     */
    public $Supplier_Category_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Category_RequestType
     * @uses Put_Supplier_Category_RequestType::setSupplier_Category_Reference()
     * @uses Put_Supplier_Category_RequestType::setSupplier_Category_Data()
     * @uses Put_Supplier_Category_RequestType::setAdd_Only()
     * @uses Put_Supplier_Category_RequestType::setVersion()
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @param \StructType\Supplier_Category_DataType $supplier_Category_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null, \StructType\Supplier_Category_DataType $supplier_Category_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setSupplier_Category_Data($supplier_Category_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * Set Supplier_Category_Reference value
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @return \StructType\Put_Supplier_Category_RequestType
     */
    public function setSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null)
    {
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Get Supplier_Category_Data value
     * @return \StructType\Supplier_Category_DataType|null
     */
    public function getSupplier_Category_Data()
    {
        return $this->Supplier_Category_Data;
    }
    /**
     * Set Supplier_Category_Data value
     * @param \StructType\Supplier_Category_DataType $supplier_Category_Data
     * @return \StructType\Put_Supplier_Category_RequestType
     */
    public function setSupplier_Category_Data(\StructType\Supplier_Category_DataType $supplier_Category_Data = null)
    {
        $this->Supplier_Category_Data = $supplier_Category_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_Category_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Category_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
