<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Internal_Service_Provider_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for all Put Internal Service Provider Request Data.
 * @subpackage Structs
 */
class Put_Internal_Service_Provider_RequestType extends AbstractStructBase
{
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Service Provider for update only purposes
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Internal_Service_Provider_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Provider_DataType
     */
    public $Internal_Service_Provider_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Internal_Service_Provider_RequestType
     * @uses Put_Internal_Service_Provider_RequestType::setInternal_Service_Provider_Reference()
     * @uses Put_Internal_Service_Provider_RequestType::setInternal_Service_Provider_Data()
     * @uses Put_Internal_Service_Provider_RequestType::setAdd_Only()
     * @uses Put_Internal_Service_Provider_RequestType::setVersion()
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @param \StructType\Internal_Service_Provider_DataType $internal_Service_Provider_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null, \StructType\Internal_Service_Provider_DataType $internal_Service_Provider_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setInternal_Service_Provider_Data($internal_Service_Provider_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Put_Internal_Service_Provider_RequestType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Data value
     * @return \StructType\Internal_Service_Provider_DataType|null
     */
    public function getInternal_Service_Provider_Data()
    {
        return $this->Internal_Service_Provider_Data;
    }
    /**
     * Set Internal_Service_Provider_Data value
     * @param \StructType\Internal_Service_Provider_DataType $internal_Service_Provider_Data
     * @return \StructType\Put_Internal_Service_Provider_RequestType
     */
    public function setInternal_Service_Provider_Data(\StructType\Internal_Service_Provider_DataType $internal_Service_Provider_Data = null)
    {
        $this->Internal_Service_Provider_Data = $internal_Service_Provider_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Internal_Service_Provider_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Internal_Service_Provider_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
