<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the Get Projects response data.
 * @subpackage Structs
 */
class Project_Response_DataType extends AbstractStructBase
{
    /**
     * The Project
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectType[]
     */
    public $Project;
    /**
     * Constructor method for Project_Response_DataType
     * @uses Project_Response_DataType::setProject()
     * @param \StructType\ProjectType[] $project
     */
    public function __construct(array $project = array())
    {
        $this
            ->setProject($project);
    }
    /**
     * Get Project value
     * @return \StructType\ProjectType[]|null
     */
    public function getProject()
    {
        return $this->Project;
    }
    /**
     * This method is responsible for validating the values passed to the setProject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProjectForArrayConstraintsFromSetProject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Response_DataTypeProjectItem) {
            // validation for constraint: itemType
            if (!$project_Response_DataTypeProjectItem instanceof \StructType\ProjectType) {
                $invalidValues[] = is_object($project_Response_DataTypeProjectItem) ? get_class($project_Response_DataTypeProjectItem) : sprintf('%s(%s)', gettype($project_Response_DataTypeProjectItem), var_export($project_Response_DataTypeProjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project property can only contain items of type \StructType\ProjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectType[] $project
     * @return \StructType\Project_Response_DataType
     */
    public function setProject(array $project = array())
    {
        // validation for constraint: array
        if ('' !== ($projectArrayErrorMessage = self::validateProjectForArrayConstraintsFromSetProject($project))) {
            throw new \InvalidArgumentException($projectArrayErrorMessage, __LINE__);
        }
        $this->Project = $project;
        return $this;
    }
    /**
     * Add item to Project value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectType $item
     * @return \StructType\Project_Response_DataType
     */
    public function addToProject(\StructType\ProjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectType) {
            throw new \InvalidArgumentException(sprintf('The Project property can only contain items of type \StructType\ProjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project[] = $item;
        return $this;
    }
}
