<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Bill To Address
 * @subpackage Structs
 */
class Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Address_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Bill To Address ID cXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/BillTo/Address@addressID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address_ID;
    /**
     * The Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference IDcXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Address@addressIDandRequest/OrderRequest/OrderRequestHeader/BillTo/Address@addressIDandRequest/OrderRequest/OrderRequestHeader/Contact@addressIDPunchout Setup
     * RequestRequest/PunchoutSetupRequest/Contact@addressIDandRequest/PunchoutSetupRequest/ShipTo/Address@addressIDAddress Reference ID is the Reference ID of the Address of the Worker for a Punchout or the Shipto Address on a Purchase Order
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceType[]
     */
    public $Address_Reference;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - documentation: Formatted Street Address Line 1 and Line 2.cXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/BillTo/PostalAddress/Street
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The Street_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Street Line Data. An address can have up to 9 address lines, but configuration will determine how many will be sent
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Street_Line_DataType[]
     */
    public $Street_Line_Data;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: CitycXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/BillTo/PostalAddress/City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - documentation: Address State ISO CodecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/BillTo/PostalAddress/State
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip_Code
     * Meta information extracted from the WSDL
     * - documentation: Zip Code (PostalCode)cXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/PostalAddress/PostalCode
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip_Code;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: Address Country NamecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/PostalAddress/Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Country_Code
     * Meta information extracted from the WSDL
     * - documentation: Address Country ISO Code.cXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/PostalAddress/Country@isoCountryCode
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country_Code;
    /**
     * Constructor method for
     * Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setAddress_ID()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setAddress_Reference()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setStreet()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setStreet_Line_Data()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCity()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setState()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setZip_Code()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCountry()
     * @uses Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCountry_Code()
     * @param string $address_ID
     * @param \StructType\Address_ReferenceType[] $address_Reference
     * @param string $street
     * @param \StructType\Street_Line_DataType[] $street_Line_Data
     * @param string $city
     * @param string $state
     * @param string $zip_Code
     * @param string $country
     * @param string $country_Code
     */
    public function __construct($address_ID = null, array $address_Reference = array(), $street = null, array $street_Line_Data = array(), $city = null, $state = null, $zip_Code = null, $country = null, $country_Code = null)
    {
        $this
            ->setAddress_ID($address_ID)
            ->setAddress_Reference($address_Reference)
            ->setStreet($street)
            ->setStreet_Line_Data($street_Line_Data)
            ->setCity($city)
            ->setState($state)
            ->setZip_Code($zip_Code)
            ->setCountry($country)
            ->setCountry_Code($country_Code);
    }
    /**
     * Get Address_ID value
     * @return string|null
     */
    public function getAddress_ID()
    {
        return $this->Address_ID;
    }
    /**
     * Set Address_ID value
     * @param string $address_ID
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setAddress_ID($address_ID = null)
    {
        // validation for constraint: string
        if (!is_null($address_ID) && !is_string($address_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address_ID, true), gettype($address_ID)), __LINE__);
        }
        $this->Address_ID = $address_ID;
        return $this;
    }
    /**
     * Get Address_Reference value
     * @return \StructType\Address_ReferenceType[]|null
     */
    public function getAddress_Reference()
    {
        return $this->Address_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem) {
            // validation for constraint: itemType
            if (!$bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem instanceof \StructType\Address_ReferenceType) {
                $invalidValues[] = is_object($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem) ? get_class($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem) : sprintf('%s(%s)', gettype($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem), var_export($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeAddress_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType[] $address_Reference
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setAddress_Reference(array $address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($address_ReferenceArrayErrorMessage = self::validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference($address_Reference))) {
            throw new \InvalidArgumentException($address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Address_Reference = $address_Reference;
        return $this;
    }
    /**
     * Add item to Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType $item
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToAddress_Reference(\StructType\Address_ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address_Reference[] = $item;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get Street_Line_Data value
     * @return \StructType\Street_Line_DataType[]|null
     */
    public function getStreet_Line_Data()
    {
        return $this->Street_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setStreet_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreet_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreet_Line_DataForArrayConstraintsFromSetStreet_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem) {
            // validation for constraint: itemType
            if (!$bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem instanceof \StructType\Street_Line_DataType) {
                $invalidValues[] = is_object($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem) ? get_class($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem) : sprintf('%s(%s)', gettype($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem), var_export($bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeStreet_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Street_Line_Data property can only contain items of type \StructType\Street_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Street_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Street_Line_DataType[] $street_Line_Data
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setStreet_Line_Data(array $street_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($street_Line_DataArrayErrorMessage = self::validateStreet_Line_DataForArrayConstraintsFromSetStreet_Line_Data($street_Line_Data))) {
            throw new \InvalidArgumentException($street_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Street_Line_Data = $street_Line_Data;
        return $this;
    }
    /**
     * Add item to Street_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Street_Line_DataType $item
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToStreet_Line_Data(\StructType\Street_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Street_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Street_Line_Data property can only contain items of type \StructType\Street_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Street_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip_Code value
     * @return string|null
     */
    public function getZip_Code()
    {
        return $this->Zip_Code;
    }
    /**
     * Set Zip_Code value
     * @param string $zip_Code
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setZip_Code($zip_Code = null)
    {
        // validation for constraint: string
        if (!is_null($zip_Code) && !is_string($zip_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip_Code, true), gettype($zip_Code)), __LINE__);
        }
        $this->Zip_Code = $zip_Code;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Country_Code value
     * @return string|null
     */
    public function getCountry_Code()
    {
        return $this->Country_Code;
    }
    /**
     * Set Country_Code value
     * @param string $country_Code
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCountry_Code($country_Code = null)
    {
        // validation for constraint: string
        if (!is_null($country_Code) && !is_string($country_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_Code, true), gettype($country_Code)), __LINE__);
        }
        $this->Country_Code = $country_Code;
        return $this;
    }
}
